/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.CaptionLanguageMapping;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CaptionLanguageMappingMarshaller {
    private static final MarshallingInfo<Integer> CAPTIONCHANNEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("captionChannel").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGECODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageCode").isBinary(false).build();
    private static final MarshallingInfo<String> LANGUAGEDESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("languageDescription").isBinary(false).build();
    private static final CaptionLanguageMappingMarshaller INSTANCE = new CaptionLanguageMappingMarshaller();

    private CaptionLanguageMappingMarshaller() {
    }

    public static CaptionLanguageMappingMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CaptionLanguageMapping captionLanguageMapping, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)captionLanguageMapping, (String)"captionLanguageMapping");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)captionLanguageMapping.captionChannel(), CAPTIONCHANNEL_BINDING);
            protocolMarshaller.marshall((Object)captionLanguageMapping.languageCode(), LANGUAGECODE_BINDING);
            protocolMarshaller.marshall((Object)captionLanguageMapping.languageDescription(), LANGUAGEDESCRIPTION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

