/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.CaptionDestinationSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CaptionDestinationSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> ARIBDESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("aribDestinationSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> BURNINDESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("burnInDestinationSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> DVBSUBDESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dvbSubDestinationSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EMBEDDEDDESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("embeddedDestinationSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> EMBEDDEDPLUSSCTE20DESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("embeddedPlusScte20DestinationSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SCTE20PLUSEMBEDDEDDESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scte20PlusEmbeddedDestinationSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SCTE27DESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scte27DestinationSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SMPTETTDESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("smpteTtDestinationSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TELETEXTDESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("teletextDestinationSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TTMLDESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ttmlDestinationSettings").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> WEBVTTDESTINATIONSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("webvttDestinationSettings").isBinary(false).build();
    private static final CaptionDestinationSettingsMarshaller INSTANCE = new CaptionDestinationSettingsMarshaller();

    private CaptionDestinationSettingsMarshaller() {
    }

    public static CaptionDestinationSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CaptionDestinationSettings captionDestinationSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)captionDestinationSettings, (String)"captionDestinationSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)captionDestinationSettings.aribDestinationSettings(), ARIBDESTINATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionDestinationSettings.burnInDestinationSettings(), BURNINDESTINATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionDestinationSettings.dvbSubDestinationSettings(), DVBSUBDESTINATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionDestinationSettings.embeddedDestinationSettings(), EMBEDDEDDESTINATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionDestinationSettings.embeddedPlusScte20DestinationSettings(), EMBEDDEDPLUSSCTE20DESTINATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionDestinationSettings.scte20PlusEmbeddedDestinationSettings(), SCTE20PLUSEMBEDDEDDESTINATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionDestinationSettings.scte27DestinationSettings(), SCTE27DESTINATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionDestinationSettings.smpteTtDestinationSettings(), SMPTETTDESTINATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionDestinationSettings.teletextDestinationSettings(), TELETEXTDESTINATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionDestinationSettings.ttmlDestinationSettings(), TTMLDESTINATIONSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)captionDestinationSettings.webvttDestinationSettings(), WEBVTTDESTINATIONSETTINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

