/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.medialive.model.AudioChannelMapping;
import software.amazon.awssdk.services.medialive.transform.InputChannelLevelUnmarshaller;

public class AudioChannelMappingUnmarshaller
implements Unmarshaller<AudioChannelMapping, JsonUnmarshallerContext> {
    private static final AudioChannelMappingUnmarshaller INSTANCE = new AudioChannelMappingUnmarshaller();

    public AudioChannelMapping unmarshall(JsonUnmarshallerContext context) throws Exception {
        AudioChannelMapping.Builder audioChannelMappingBuilder = AudioChannelMapping.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("inputChannelLevels", targetDepth)) {
                    context.nextToken();
                    audioChannelMappingBuilder.inputChannelLevels(new ListUnmarshaller((Unmarshaller)InputChannelLevelUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("outputChannel", targetDepth)) {
                    context.nextToken();
                    audioChannelMappingBuilder.outputChannel((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (AudioChannelMapping)audioChannelMappingBuilder.build();
    }

    public static AudioChannelMappingUnmarshaller getInstance() {
        return INSTANCE;
    }
}

