/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.ArchiveOutputSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ArchiveOutputSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> CONTAINERSETTINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("containerSettings").isBinary(false).build();
    private static final MarshallingInfo<String> EXTENSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("extension").isBinary(false).build();
    private static final MarshallingInfo<String> NAMEMODIFIER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nameModifier").isBinary(false).build();
    private static final ArchiveOutputSettingsMarshaller INSTANCE = new ArchiveOutputSettingsMarshaller();

    private ArchiveOutputSettingsMarshaller() {
    }

    public static ArchiveOutputSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ArchiveOutputSettings archiveOutputSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)archiveOutputSettings, (String)"archiveOutputSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)archiveOutputSettings.containerSettings(), CONTAINERSETTINGS_BINDING);
            protocolMarshaller.marshall((Object)archiveOutputSettings.extension(), EXTENSION_BINDING);
            protocolMarshaller.marshall((Object)archiveOutputSettings.nameModifier(), NAMEMODIFIER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

