/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.ArchiveGroupSettings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ArchiveGroupSettingsMarshaller {
    private static final MarshallingInfo<StructuredPojo> DESTINATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("destination").isBinary(false).build();
    private static final MarshallingInfo<Integer> ROLLOVERINTERVAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rolloverInterval").isBinary(false).build();
    private static final ArchiveGroupSettingsMarshaller INSTANCE = new ArchiveGroupSettingsMarshaller();

    private ArchiveGroupSettingsMarshaller() {
    }

    public static ArchiveGroupSettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ArchiveGroupSettings archiveGroupSettings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)archiveGroupSettings, (String)"archiveGroupSettings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)archiveGroupSettings.destination(), DESTINATION_BINDING);
            protocolMarshaller.marshall((Object)archiveGroupSettings.rolloverInterval(), ROLLOVERINTERVAL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

