/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.medialive.model.Ac3Settings;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class Ac3SettingsMarshaller {
    private static final MarshallingInfo<Double> BITRATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitrate").isBinary(false).build();
    private static final MarshallingInfo<String> BITSTREAMMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("bitstreamMode").isBinary(false).build();
    private static final MarshallingInfo<String> CODINGMODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("codingMode").isBinary(false).build();
    private static final MarshallingInfo<Integer> DIALNORM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dialnorm").isBinary(false).build();
    private static final MarshallingInfo<String> DRCPROFILE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("drcProfile").isBinary(false).build();
    private static final MarshallingInfo<String> LFEFILTER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lfeFilter").isBinary(false).build();
    private static final MarshallingInfo<String> METADATACONTROL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("metadataControl").isBinary(false).build();
    private static final Ac3SettingsMarshaller INSTANCE = new Ac3SettingsMarshaller();

    private Ac3SettingsMarshaller() {
    }

    public static Ac3SettingsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Ac3Settings ac3Settings, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ac3Settings, (String)"ac3Settings");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ac3Settings.bitrate(), BITRATE_BINDING);
            protocolMarshaller.marshall((Object)ac3Settings.bitstreamModeString(), BITSTREAMMODE_BINDING);
            protocolMarshaller.marshall((Object)ac3Settings.codingModeString(), CODINGMODE_BINDING);
            protocolMarshaller.marshall((Object)ac3Settings.dialnorm(), DIALNORM_BINDING);
            protocolMarshaller.marshall((Object)ac3Settings.drcProfileString(), DRCPROFILE_BINDING);
            protocolMarshaller.marshall((Object)ac3Settings.lfeFilterString(), LFEFILTER_BINDING);
            protocolMarshaller.marshall((Object)ac3Settings.metadataControlString(), METADATACONTROL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

