/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.medialive.MediaLiveAsyncClient;
import software.amazon.awssdk.services.medialive.model.Input;
import software.amazon.awssdk.services.medialive.model.ListInputsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputsResponse;

public class ListInputsPublisher
implements SdkPublisher<ListInputsResponse> {
    private final MediaLiveAsyncClient client;
    private final ListInputsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInputsPublisher(MediaLiveAsyncClient client, ListInputsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInputsPublisher(MediaLiveAsyncClient client, ListInputsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInputsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInputsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<Input> inputs() {
        Function<ListInputsResponse, Iterator> getIterator = response -> {
            if (response != null && response.inputs() != null) {
                return response.inputs().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListInputsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListInputsPublisher resume(ListInputsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInputsPublisher(this.client, (ListInputsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListInputsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListInputsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListInputsResponseFetcher
    implements AsyncPageFetcher<ListInputsResponse> {
        private ListInputsResponseFetcher() {
        }

        public boolean hasNextPage(ListInputsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListInputsResponse> nextPage(ListInputsResponse previousPage) {
            if (previousPage == null) {
                return ListInputsPublisher.this.client.listInputs(ListInputsPublisher.this.firstRequest);
            }
            return ListInputsPublisher.this.client.listInputs((ListInputsRequest)((Object)ListInputsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

