/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.model.ChannelSummary;
import software.amazon.awssdk.services.medialive.model.ListChannelsRequest;
import software.amazon.awssdk.services.medialive.model.ListChannelsResponse;

public class ListChannelsIterable
implements SdkIterable<ListChannelsResponse> {
    private final MediaLiveClient client;
    private final ListChannelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListChannelsIterable(MediaLiveClient client, ListChannelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListChannelsResponseFetcher();
    }

    public Iterator<ListChannelsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<ChannelSummary> channels() {
        Function<ListChannelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.channels() != null) {
                return response.channels().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListChannelsIterable resume(ListChannelsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListChannelsIterable(this.client, (ListChannelsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListChannelsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListChannelsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListChannelsResponseFetcher
    implements SyncPageFetcher<ListChannelsResponse> {
        private ListChannelsResponseFetcher() {
        }

        public boolean hasNextPage(ListChannelsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListChannelsResponse nextPage(ListChannelsResponse previousPage) {
            if (previousPage == null) {
                return ListChannelsIterable.this.client.listChannels(ListChannelsIterable.this.firstRequest);
            }
            return ListChannelsIterable.this.client.listChannels((ListChannelsRequest)((Object)ListChannelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

