/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.H264Settings;
import software.amazon.awssdk.services.medialive.transform.VideoCodecSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VideoCodecSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, VideoCodecSettings> {
    private final H264Settings h264Settings;

    private VideoCodecSettings(BuilderImpl builder) {
        this.h264Settings = builder.h264Settings;
    }

    public H264Settings h264Settings() {
        return this.h264Settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.h264Settings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoCodecSettings)) {
            return false;
        }
        VideoCodecSettings other = (VideoCodecSettings)obj;
        return Objects.equals(this.h264Settings(), other.h264Settings());
    }

    public String toString() {
        return ToString.builder((String)"VideoCodecSettings").add("H264Settings", (Object)this.h264Settings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "H264Settings": {
                return Optional.of(clazz.cast(this.h264Settings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VideoCodecSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private H264Settings h264Settings;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoCodecSettings model) {
            this.h264Settings(model.h264Settings);
        }

        public final H264Settings.Builder getH264Settings() {
            return this.h264Settings != null ? this.h264Settings.toBuilder() : null;
        }

        @Override
        public final Builder h264Settings(H264Settings h264Settings) {
            this.h264Settings = h264Settings;
            return this;
        }

        public final void setH264Settings(H264Settings.BuilderImpl h264Settings) {
            this.h264Settings = h264Settings != null ? h264Settings.build() : null;
        }

        public VideoCodecSettings build() {
            return new VideoCodecSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VideoCodecSettings> {
        public Builder h264Settings(H264Settings var1);

        default public Builder h264Settings(Consumer<H264Settings.Builder> h264Settings) {
            return this.h264Settings((H264Settings)((H264Settings.Builder)H264Settings.builder().apply(h264Settings)).build());
        }
    }
}

