/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.FecOutputSettings;
import software.amazon.awssdk.services.medialive.model.OutputLocationRef;
import software.amazon.awssdk.services.medialive.model.UdpContainerSettings;
import software.amazon.awssdk.services.medialive.transform.UdpOutputSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UdpOutputSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, UdpOutputSettings> {
    private final Integer bufferMsec;
    private final UdpContainerSettings containerSettings;
    private final OutputLocationRef destination;
    private final FecOutputSettings fecOutputSettings;

    private UdpOutputSettings(BuilderImpl builder) {
        this.bufferMsec = builder.bufferMsec;
        this.containerSettings = builder.containerSettings;
        this.destination = builder.destination;
        this.fecOutputSettings = builder.fecOutputSettings;
    }

    public Integer bufferMsec() {
        return this.bufferMsec;
    }

    public UdpContainerSettings containerSettings() {
        return this.containerSettings;
    }

    public OutputLocationRef destination() {
        return this.destination;
    }

    public FecOutputSettings fecOutputSettings() {
        return this.fecOutputSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bufferMsec());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.fecOutputSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UdpOutputSettings)) {
            return false;
        }
        UdpOutputSettings other = (UdpOutputSettings)obj;
        return Objects.equals(this.bufferMsec(), other.bufferMsec()) && Objects.equals(this.containerSettings(), other.containerSettings()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.fecOutputSettings(), other.fecOutputSettings());
    }

    public String toString() {
        return ToString.builder((String)"UdpOutputSettings").add("BufferMsec", (Object)this.bufferMsec()).add("ContainerSettings", (Object)this.containerSettings()).add("Destination", (Object)this.destination()).add("FecOutputSettings", (Object)this.fecOutputSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BufferMsec": {
                return Optional.of(clazz.cast(this.bufferMsec()));
            }
            case "ContainerSettings": {
                return Optional.of(clazz.cast(this.containerSettings()));
            }
            case "Destination": {
                return Optional.of(clazz.cast(this.destination()));
            }
            case "FecOutputSettings": {
                return Optional.of(clazz.cast(this.fecOutputSettings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UdpOutputSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer bufferMsec;
        private UdpContainerSettings containerSettings;
        private OutputLocationRef destination;
        private FecOutputSettings fecOutputSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UdpOutputSettings model) {
            this.bufferMsec(model.bufferMsec);
            this.containerSettings(model.containerSettings);
            this.destination(model.destination);
            this.fecOutputSettings(model.fecOutputSettings);
        }

        public final Integer getBufferMsec() {
            return this.bufferMsec;
        }

        @Override
        public final Builder bufferMsec(Integer bufferMsec) {
            this.bufferMsec = bufferMsec;
            return this;
        }

        public final void setBufferMsec(Integer bufferMsec) {
            this.bufferMsec = bufferMsec;
        }

        public final UdpContainerSettings.Builder getContainerSettings() {
            return this.containerSettings != null ? this.containerSettings.toBuilder() : null;
        }

        @Override
        public final Builder containerSettings(UdpContainerSettings containerSettings) {
            this.containerSettings = containerSettings;
            return this;
        }

        public final void setContainerSettings(UdpContainerSettings.BuilderImpl containerSettings) {
            this.containerSettings = containerSettings != null ? containerSettings.build() : null;
        }

        public final OutputLocationRef.Builder getDestination() {
            return this.destination != null ? this.destination.toBuilder() : null;
        }

        @Override
        public final Builder destination(OutputLocationRef destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(OutputLocationRef.BuilderImpl destination) {
            this.destination = destination != null ? destination.build() : null;
        }

        public final FecOutputSettings.Builder getFecOutputSettings() {
            return this.fecOutputSettings != null ? this.fecOutputSettings.toBuilder() : null;
        }

        @Override
        public final Builder fecOutputSettings(FecOutputSettings fecOutputSettings) {
            this.fecOutputSettings = fecOutputSettings;
            return this;
        }

        public final void setFecOutputSettings(FecOutputSettings.BuilderImpl fecOutputSettings) {
            this.fecOutputSettings = fecOutputSettings != null ? fecOutputSettings.build() : null;
        }

        public UdpOutputSettings build() {
            return new UdpOutputSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UdpOutputSettings> {
        public Builder bufferMsec(Integer var1);

        public Builder containerSettings(UdpContainerSettings var1);

        default public Builder containerSettings(Consumer<UdpContainerSettings.Builder> containerSettings) {
            return this.containerSettings((UdpContainerSettings)((UdpContainerSettings.Builder)UdpContainerSettings.builder().apply(containerSettings)).build());
        }

        public Builder destination(OutputLocationRef var1);

        default public Builder destination(Consumer<OutputLocationRef.Builder> destination) {
            return this.destination((OutputLocationRef)((OutputLocationRef.Builder)OutputLocationRef.builder().apply(destination)).build());
        }

        public Builder fecOutputSettings(FecOutputSettings var1);

        default public Builder fecOutputSettings(Consumer<FecOutputSettings.Builder> fecOutputSettings) {
            return this.fecOutputSettings((FecOutputSettings)((FecOutputSettings.Builder)FecOutputSettings.builder().apply(fecOutputSettings)).build());
        }
    }
}

