/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.M3u8PcrControl;
import software.amazon.awssdk.services.medialive.model.M3u8Scte35Behavior;
import software.amazon.awssdk.services.medialive.model.M3u8TimedMetadataBehavior;
import software.amazon.awssdk.services.medialive.transform.M3u8SettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class M3u8Settings
implements StructuredPojo,
ToCopyableBuilder<Builder, M3u8Settings> {
    private final Integer audioFramesPerPes;
    private final String audioPids;
    private final String ecmPid;
    private final Integer patInterval;
    private final String pcrControl;
    private final Integer pcrPeriod;
    private final String pcrPid;
    private final Integer pmtInterval;
    private final String pmtPid;
    private final Integer programNum;
    private final String scte35Behavior;
    private final String scte35Pid;
    private final String timedMetadataBehavior;
    private final Integer transportStreamId;
    private final String videoPid;

    private M3u8Settings(BuilderImpl builder) {
        this.audioFramesPerPes = builder.audioFramesPerPes;
        this.audioPids = builder.audioPids;
        this.ecmPid = builder.ecmPid;
        this.patInterval = builder.patInterval;
        this.pcrControl = builder.pcrControl;
        this.pcrPeriod = builder.pcrPeriod;
        this.pcrPid = builder.pcrPid;
        this.pmtInterval = builder.pmtInterval;
        this.pmtPid = builder.pmtPid;
        this.programNum = builder.programNum;
        this.scte35Behavior = builder.scte35Behavior;
        this.scte35Pid = builder.scte35Pid;
        this.timedMetadataBehavior = builder.timedMetadataBehavior;
        this.transportStreamId = builder.transportStreamId;
        this.videoPid = builder.videoPid;
    }

    public Integer audioFramesPerPes() {
        return this.audioFramesPerPes;
    }

    public String audioPids() {
        return this.audioPids;
    }

    public String ecmPid() {
        return this.ecmPid;
    }

    public Integer patInterval() {
        return this.patInterval;
    }

    public M3u8PcrControl pcrControl() {
        return M3u8PcrControl.fromValue(this.pcrControl);
    }

    public String pcrControlString() {
        return this.pcrControl;
    }

    public Integer pcrPeriod() {
        return this.pcrPeriod;
    }

    public String pcrPid() {
        return this.pcrPid;
    }

    public Integer pmtInterval() {
        return this.pmtInterval;
    }

    public String pmtPid() {
        return this.pmtPid;
    }

    public Integer programNum() {
        return this.programNum;
    }

    public M3u8Scte35Behavior scte35Behavior() {
        return M3u8Scte35Behavior.fromValue(this.scte35Behavior);
    }

    public String scte35BehaviorString() {
        return this.scte35Behavior;
    }

    public String scte35Pid() {
        return this.scte35Pid;
    }

    public M3u8TimedMetadataBehavior timedMetadataBehavior() {
        return M3u8TimedMetadataBehavior.fromValue(this.timedMetadataBehavior);
    }

    public String timedMetadataBehaviorString() {
        return this.timedMetadataBehavior;
    }

    public Integer transportStreamId() {
        return this.transportStreamId;
    }

    public String videoPid() {
        return this.videoPid;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioFramesPerPes());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioPids());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecmPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.patInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcrControlString());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcrPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.pcrPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.pmtInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.pmtPid());
        hashCode = 31 * hashCode + Objects.hashCode(this.programNum());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35BehaviorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35Pid());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataBehaviorString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transportStreamId());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoPid());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M3u8Settings)) {
            return false;
        }
        M3u8Settings other = (M3u8Settings)obj;
        return Objects.equals(this.audioFramesPerPes(), other.audioFramesPerPes()) && Objects.equals(this.audioPids(), other.audioPids()) && Objects.equals(this.ecmPid(), other.ecmPid()) && Objects.equals(this.patInterval(), other.patInterval()) && Objects.equals(this.pcrControlString(), other.pcrControlString()) && Objects.equals(this.pcrPeriod(), other.pcrPeriod()) && Objects.equals(this.pcrPid(), other.pcrPid()) && Objects.equals(this.pmtInterval(), other.pmtInterval()) && Objects.equals(this.pmtPid(), other.pmtPid()) && Objects.equals(this.programNum(), other.programNum()) && Objects.equals(this.scte35BehaviorString(), other.scte35BehaviorString()) && Objects.equals(this.scte35Pid(), other.scte35Pid()) && Objects.equals(this.timedMetadataBehaviorString(), other.timedMetadataBehaviorString()) && Objects.equals(this.transportStreamId(), other.transportStreamId()) && Objects.equals(this.videoPid(), other.videoPid());
    }

    public String toString() {
        return ToString.builder((String)"M3u8Settings").add("AudioFramesPerPes", (Object)this.audioFramesPerPes()).add("AudioPids", (Object)this.audioPids()).add("EcmPid", (Object)this.ecmPid()).add("PatInterval", (Object)this.patInterval()).add("PcrControl", (Object)this.pcrControlString()).add("PcrPeriod", (Object)this.pcrPeriod()).add("PcrPid", (Object)this.pcrPid()).add("PmtInterval", (Object)this.pmtInterval()).add("PmtPid", (Object)this.pmtPid()).add("ProgramNum", (Object)this.programNum()).add("Scte35Behavior", (Object)this.scte35BehaviorString()).add("Scte35Pid", (Object)this.scte35Pid()).add("TimedMetadataBehavior", (Object)this.timedMetadataBehaviorString()).add("TransportStreamId", (Object)this.transportStreamId()).add("VideoPid", (Object)this.videoPid()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioFramesPerPes": {
                return Optional.of(clazz.cast(this.audioFramesPerPes()));
            }
            case "AudioPids": {
                return Optional.of(clazz.cast(this.audioPids()));
            }
            case "EcmPid": {
                return Optional.of(clazz.cast(this.ecmPid()));
            }
            case "PatInterval": {
                return Optional.of(clazz.cast(this.patInterval()));
            }
            case "PcrControl": {
                return Optional.of(clazz.cast(this.pcrControlString()));
            }
            case "PcrPeriod": {
                return Optional.of(clazz.cast(this.pcrPeriod()));
            }
            case "PcrPid": {
                return Optional.of(clazz.cast(this.pcrPid()));
            }
            case "PmtInterval": {
                return Optional.of(clazz.cast(this.pmtInterval()));
            }
            case "PmtPid": {
                return Optional.of(clazz.cast(this.pmtPid()));
            }
            case "ProgramNum": {
                return Optional.of(clazz.cast(this.programNum()));
            }
            case "Scte35Behavior": {
                return Optional.of(clazz.cast(this.scte35BehaviorString()));
            }
            case "Scte35Pid": {
                return Optional.of(clazz.cast(this.scte35Pid()));
            }
            case "TimedMetadataBehavior": {
                return Optional.of(clazz.cast(this.timedMetadataBehaviorString()));
            }
            case "TransportStreamId": {
                return Optional.of(clazz.cast(this.transportStreamId()));
            }
            case "VideoPid": {
                return Optional.of(clazz.cast(this.videoPid()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        M3u8SettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer audioFramesPerPes;
        private String audioPids;
        private String ecmPid;
        private Integer patInterval;
        private String pcrControl;
        private Integer pcrPeriod;
        private String pcrPid;
        private Integer pmtInterval;
        private String pmtPid;
        private Integer programNum;
        private String scte35Behavior;
        private String scte35Pid;
        private String timedMetadataBehavior;
        private Integer transportStreamId;
        private String videoPid;

        private BuilderImpl() {
        }

        private BuilderImpl(M3u8Settings model) {
            this.audioFramesPerPes(model.audioFramesPerPes);
            this.audioPids(model.audioPids);
            this.ecmPid(model.ecmPid);
            this.patInterval(model.patInterval);
            this.pcrControl(model.pcrControl);
            this.pcrPeriod(model.pcrPeriod);
            this.pcrPid(model.pcrPid);
            this.pmtInterval(model.pmtInterval);
            this.pmtPid(model.pmtPid);
            this.programNum(model.programNum);
            this.scte35Behavior(model.scte35Behavior);
            this.scte35Pid(model.scte35Pid);
            this.timedMetadataBehavior(model.timedMetadataBehavior);
            this.transportStreamId(model.transportStreamId);
            this.videoPid(model.videoPid);
        }

        public final Integer getAudioFramesPerPes() {
            return this.audioFramesPerPes;
        }

        @Override
        public final Builder audioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
            return this;
        }

        public final void setAudioFramesPerPes(Integer audioFramesPerPes) {
            this.audioFramesPerPes = audioFramesPerPes;
        }

        public final String getAudioPids() {
            return this.audioPids;
        }

        @Override
        public final Builder audioPids(String audioPids) {
            this.audioPids = audioPids;
            return this;
        }

        public final void setAudioPids(String audioPids) {
            this.audioPids = audioPids;
        }

        public final String getEcmPid() {
            return this.ecmPid;
        }

        @Override
        public final Builder ecmPid(String ecmPid) {
            this.ecmPid = ecmPid;
            return this;
        }

        public final void setEcmPid(String ecmPid) {
            this.ecmPid = ecmPid;
        }

        public final Integer getPatInterval() {
            return this.patInterval;
        }

        @Override
        public final Builder patInterval(Integer patInterval) {
            this.patInterval = patInterval;
            return this;
        }

        public final void setPatInterval(Integer patInterval) {
            this.patInterval = patInterval;
        }

        public final String getPcrControl() {
            return this.pcrControl;
        }

        @Override
        public final Builder pcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
            return this;
        }

        @Override
        public final Builder pcrControl(M3u8PcrControl pcrControl) {
            this.pcrControl(pcrControl.toString());
            return this;
        }

        public final void setPcrControl(String pcrControl) {
            this.pcrControl = pcrControl;
        }

        public final Integer getPcrPeriod() {
            return this.pcrPeriod;
        }

        @Override
        public final Builder pcrPeriod(Integer pcrPeriod) {
            this.pcrPeriod = pcrPeriod;
            return this;
        }

        public final void setPcrPeriod(Integer pcrPeriod) {
            this.pcrPeriod = pcrPeriod;
        }

        public final String getPcrPid() {
            return this.pcrPid;
        }

        @Override
        public final Builder pcrPid(String pcrPid) {
            this.pcrPid = pcrPid;
            return this;
        }

        public final void setPcrPid(String pcrPid) {
            this.pcrPid = pcrPid;
        }

        public final Integer getPmtInterval() {
            return this.pmtInterval;
        }

        @Override
        public final Builder pmtInterval(Integer pmtInterval) {
            this.pmtInterval = pmtInterval;
            return this;
        }

        public final void setPmtInterval(Integer pmtInterval) {
            this.pmtInterval = pmtInterval;
        }

        public final String getPmtPid() {
            return this.pmtPid;
        }

        @Override
        public final Builder pmtPid(String pmtPid) {
            this.pmtPid = pmtPid;
            return this;
        }

        public final void setPmtPid(String pmtPid) {
            this.pmtPid = pmtPid;
        }

        public final Integer getProgramNum() {
            return this.programNum;
        }

        @Override
        public final Builder programNum(Integer programNum) {
            this.programNum = programNum;
            return this;
        }

        public final void setProgramNum(Integer programNum) {
            this.programNum = programNum;
        }

        public final String getScte35Behavior() {
            return this.scte35Behavior;
        }

        @Override
        public final Builder scte35Behavior(String scte35Behavior) {
            this.scte35Behavior = scte35Behavior;
            return this;
        }

        @Override
        public final Builder scte35Behavior(M3u8Scte35Behavior scte35Behavior) {
            this.scte35Behavior(scte35Behavior.toString());
            return this;
        }

        public final void setScte35Behavior(String scte35Behavior) {
            this.scte35Behavior = scte35Behavior;
        }

        public final String getScte35Pid() {
            return this.scte35Pid;
        }

        @Override
        public final Builder scte35Pid(String scte35Pid) {
            this.scte35Pid = scte35Pid;
            return this;
        }

        public final void setScte35Pid(String scte35Pid) {
            this.scte35Pid = scte35Pid;
        }

        public final String getTimedMetadataBehavior() {
            return this.timedMetadataBehavior;
        }

        @Override
        public final Builder timedMetadataBehavior(String timedMetadataBehavior) {
            this.timedMetadataBehavior = timedMetadataBehavior;
            return this;
        }

        @Override
        public final Builder timedMetadataBehavior(M3u8TimedMetadataBehavior timedMetadataBehavior) {
            this.timedMetadataBehavior(timedMetadataBehavior.toString());
            return this;
        }

        public final void setTimedMetadataBehavior(String timedMetadataBehavior) {
            this.timedMetadataBehavior = timedMetadataBehavior;
        }

        public final Integer getTransportStreamId() {
            return this.transportStreamId;
        }

        @Override
        public final Builder transportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
            return this;
        }

        public final void setTransportStreamId(Integer transportStreamId) {
            this.transportStreamId = transportStreamId;
        }

        public final String getVideoPid() {
            return this.videoPid;
        }

        @Override
        public final Builder videoPid(String videoPid) {
            this.videoPid = videoPid;
            return this;
        }

        public final void setVideoPid(String videoPid) {
            this.videoPid = videoPid;
        }

        public M3u8Settings build() {
            return new M3u8Settings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, M3u8Settings> {
        public Builder audioFramesPerPes(Integer var1);

        public Builder audioPids(String var1);

        public Builder ecmPid(String var1);

        public Builder patInterval(Integer var1);

        public Builder pcrControl(String var1);

        public Builder pcrControl(M3u8PcrControl var1);

        public Builder pcrPeriod(Integer var1);

        public Builder pcrPid(String var1);

        public Builder pmtInterval(Integer var1);

        public Builder pmtPid(String var1);

        public Builder programNum(Integer var1);

        public Builder scte35Behavior(String var1);

        public Builder scte35Behavior(M3u8Scte35Behavior var1);

        public Builder scte35Pid(String var1);

        public Builder timedMetadataBehavior(String var1);

        public Builder timedMetadataBehavior(M3u8TimedMetadataBehavior var1);

        public Builder transportStreamId(Integer var1);

        public Builder videoPid(String var1);
    }
}

