/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.medialive.model.InputSecurityGroup;
import software.amazon.awssdk.services.medialive.model.ListOfInputSecurityGroupCopier;
import software.amazon.awssdk.services.medialive.model.MediaLiveResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListInputSecurityGroupsResponse
extends MediaLiveResponse
implements ToCopyableBuilder<Builder, ListInputSecurityGroupsResponse> {
    private final List<InputSecurityGroup> inputSecurityGroups;
    private final String nextToken;

    private ListInputSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.inputSecurityGroups = builder.inputSecurityGroups;
        this.nextToken = builder.nextToken;
    }

    public List<InputSecurityGroup> inputSecurityGroups() {
        return this.inputSecurityGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInputSecurityGroupsResponse)) {
            return false;
        }
        ListInputSecurityGroupsResponse other = (ListInputSecurityGroupsResponse)((Object)obj);
        return Objects.equals(this.inputSecurityGroups(), other.inputSecurityGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListInputSecurityGroupsResponse").add("InputSecurityGroups", this.inputSecurityGroups()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputSecurityGroups": {
                return Optional.of(clazz.cast(this.inputSecurityGroups()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaLiveResponse.BuilderImpl
    implements Builder {
        private List<InputSecurityGroup> inputSecurityGroups;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInputSecurityGroupsResponse model) {
            this.inputSecurityGroups(model.inputSecurityGroups);
            this.nextToken(model.nextToken);
        }

        public final Collection<InputSecurityGroup.Builder> getInputSecurityGroups() {
            return this.inputSecurityGroups != null ? (Collection)this.inputSecurityGroups.stream().map(InputSecurityGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputSecurityGroups(Collection<InputSecurityGroup> inputSecurityGroups) {
            this.inputSecurityGroups = ListOfInputSecurityGroupCopier.copy(inputSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputSecurityGroups(InputSecurityGroup ... inputSecurityGroups) {
            this.inputSecurityGroups(Arrays.asList(inputSecurityGroups));
            return this;
        }

        public final void setInputSecurityGroups(Collection<InputSecurityGroup.BuilderImpl> inputSecurityGroups) {
            this.inputSecurityGroups = ListOfInputSecurityGroupCopier.copyFromBuilder(inputSecurityGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInputSecurityGroupsResponse build() {
            return new ListInputSecurityGroupsResponse(this);
        }
    }

    public static interface Builder
    extends MediaLiveResponse.Builder,
    CopyableBuilder<Builder, ListInputSecurityGroupsResponse> {
        public Builder inputSecurityGroups(Collection<InputSecurityGroup> var1);

        public Builder inputSecurityGroups(InputSecurityGroup ... var1);

        public Builder nextToken(String var1);
    }
}

