/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.transform.InputLocationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InputLocation
implements StructuredPojo,
ToCopyableBuilder<Builder, InputLocation> {
    private final String passwordParam;
    private final String uri;
    private final String username;

    private InputLocation(BuilderImpl builder) {
        this.passwordParam = builder.passwordParam;
        this.uri = builder.uri;
        this.username = builder.username;
    }

    public String passwordParam() {
        return this.passwordParam;
    }

    public String uri() {
        return this.uri;
    }

    public String username() {
        return this.username;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordParam());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputLocation)) {
            return false;
        }
        InputLocation other = (InputLocation)obj;
        return Objects.equals(this.passwordParam(), other.passwordParam()) && Objects.equals(this.uri(), other.uri()) && Objects.equals(this.username(), other.username());
    }

    public String toString() {
        return ToString.builder((String)"InputLocation").add("PasswordParam", (Object)this.passwordParam()).add("Uri", (Object)this.uri()).add("Username", (Object)this.username()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PasswordParam": {
                return Optional.of(clazz.cast(this.passwordParam()));
            }
            case "Uri": {
                return Optional.of(clazz.cast(this.uri()));
            }
            case "Username": {
                return Optional.of(clazz.cast(this.username()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputLocationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String passwordParam;
        private String uri;
        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(InputLocation model) {
            this.passwordParam(model.passwordParam);
            this.uri(model.uri);
            this.username(model.username);
        }

        public final String getPasswordParam() {
            return this.passwordParam;
        }

        @Override
        public final Builder passwordParam(String passwordParam) {
            this.passwordParam = passwordParam;
            return this;
        }

        public final void setPasswordParam(String passwordParam) {
            this.passwordParam = passwordParam;
        }

        public final String getUri() {
            return this.uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        public final String getUsername() {
            return this.username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        public InputLocation build() {
            return new InputLocation(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputLocation> {
        public Builder passwordParam(String var1);

        public Builder uri(String var1);

        public Builder username(String var1);
    }
}

