/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.transform.InputChannelLevelMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InputChannelLevel
implements StructuredPojo,
ToCopyableBuilder<Builder, InputChannelLevel> {
    private final Integer gain;
    private final Integer inputChannel;

    private InputChannelLevel(BuilderImpl builder) {
        this.gain = builder.gain;
        this.inputChannel = builder.inputChannel;
    }

    public Integer gain() {
        return this.gain;
    }

    public Integer inputChannel() {
        return this.inputChannel;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gain());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputChannel());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputChannelLevel)) {
            return false;
        }
        InputChannelLevel other = (InputChannelLevel)obj;
        return Objects.equals(this.gain(), other.gain()) && Objects.equals(this.inputChannel(), other.inputChannel());
    }

    public String toString() {
        return ToString.builder((String)"InputChannelLevel").add("Gain", (Object)this.gain()).add("InputChannel", (Object)this.inputChannel()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Gain": {
                return Optional.of(clazz.cast(this.gain()));
            }
            case "InputChannel": {
                return Optional.of(clazz.cast(this.inputChannel()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InputChannelLevelMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer gain;
        private Integer inputChannel;

        private BuilderImpl() {
        }

        private BuilderImpl(InputChannelLevel model) {
            this.gain(model.gain);
            this.inputChannel(model.inputChannel);
        }

        public final Integer getGain() {
            return this.gain;
        }

        @Override
        public final Builder gain(Integer gain) {
            this.gain = gain;
            return this;
        }

        public final void setGain(Integer gain) {
            this.gain = gain;
        }

        public final Integer getInputChannel() {
            return this.inputChannel;
        }

        @Override
        public final Builder inputChannel(Integer inputChannel) {
            this.inputChannel = inputChannel;
            return this;
        }

        public final void setInputChannel(Integer inputChannel) {
            this.inputChannel = inputChannel;
        }

        public InputChannelLevel build() {
            return new InputChannelLevel(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InputChannelLevel> {
        public Builder gain(Integer var1);

        public Builder inputChannel(Integer var1);
    }
}

