/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AudioOnlyHlsSettings;
import software.amazon.awssdk.services.medialive.model.StandardHlsSettings;
import software.amazon.awssdk.services.medialive.transform.HlsSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HlsSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, HlsSettings> {
    private final AudioOnlyHlsSettings audioOnlyHlsSettings;
    private final StandardHlsSettings standardHlsSettings;

    private HlsSettings(BuilderImpl builder) {
        this.audioOnlyHlsSettings = builder.audioOnlyHlsSettings;
        this.standardHlsSettings = builder.standardHlsSettings;
    }

    public AudioOnlyHlsSettings audioOnlyHlsSettings() {
        return this.audioOnlyHlsSettings;
    }

    public StandardHlsSettings standardHlsSettings() {
        return this.standardHlsSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioOnlyHlsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.standardHlsSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsSettings)) {
            return false;
        }
        HlsSettings other = (HlsSettings)obj;
        return Objects.equals(this.audioOnlyHlsSettings(), other.audioOnlyHlsSettings()) && Objects.equals(this.standardHlsSettings(), other.standardHlsSettings());
    }

    public String toString() {
        return ToString.builder((String)"HlsSettings").add("AudioOnlyHlsSettings", (Object)this.audioOnlyHlsSettings()).add("StandardHlsSettings", (Object)this.standardHlsSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioOnlyHlsSettings": {
                return Optional.of(clazz.cast(this.audioOnlyHlsSettings()));
            }
            case "StandardHlsSettings": {
                return Optional.of(clazz.cast(this.standardHlsSettings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HlsSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private AudioOnlyHlsSettings audioOnlyHlsSettings;
        private StandardHlsSettings standardHlsSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsSettings model) {
            this.audioOnlyHlsSettings(model.audioOnlyHlsSettings);
            this.standardHlsSettings(model.standardHlsSettings);
        }

        public final AudioOnlyHlsSettings.Builder getAudioOnlyHlsSettings() {
            return this.audioOnlyHlsSettings != null ? this.audioOnlyHlsSettings.toBuilder() : null;
        }

        @Override
        public final Builder audioOnlyHlsSettings(AudioOnlyHlsSettings audioOnlyHlsSettings) {
            this.audioOnlyHlsSettings = audioOnlyHlsSettings;
            return this;
        }

        public final void setAudioOnlyHlsSettings(AudioOnlyHlsSettings.BuilderImpl audioOnlyHlsSettings) {
            this.audioOnlyHlsSettings = audioOnlyHlsSettings != null ? audioOnlyHlsSettings.build() : null;
        }

        public final StandardHlsSettings.Builder getStandardHlsSettings() {
            return this.standardHlsSettings != null ? this.standardHlsSettings.toBuilder() : null;
        }

        @Override
        public final Builder standardHlsSettings(StandardHlsSettings standardHlsSettings) {
            this.standardHlsSettings = standardHlsSettings;
            return this;
        }

        public final void setStandardHlsSettings(StandardHlsSettings.BuilderImpl standardHlsSettings) {
            this.standardHlsSettings = standardHlsSettings != null ? standardHlsSettings.build() : null;
        }

        public HlsSettings build() {
            return new HlsSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HlsSettings> {
        public Builder audioOnlyHlsSettings(AudioOnlyHlsSettings var1);

        default public Builder audioOnlyHlsSettings(Consumer<AudioOnlyHlsSettings.Builder> audioOnlyHlsSettings) {
            return this.audioOnlyHlsSettings((AudioOnlyHlsSettings)((AudioOnlyHlsSettings.Builder)AudioOnlyHlsSettings.builder().apply(audioOnlyHlsSettings)).build());
        }

        public Builder standardHlsSettings(StandardHlsSettings var1);

        default public Builder standardHlsSettings(Consumer<StandardHlsSettings.Builder> standardHlsSettings) {
            return this.standardHlsSettings((StandardHlsSettings)((StandardHlsSettings.Builder)StandardHlsSettings.builder().apply(standardHlsSettings)).build());
        }
    }
}

