/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.medialive.model.InputWhitelistRuleCidr;
import software.amazon.awssdk.services.medialive.model.ListOfInputWhitelistRuleCidrCopier;
import software.amazon.awssdk.services.medialive.model.MediaLiveRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateInputSecurityGroupRequest
extends MediaLiveRequest
implements ToCopyableBuilder<Builder, CreateInputSecurityGroupRequest> {
    private final List<InputWhitelistRuleCidr> whitelistRules;

    private CreateInputSecurityGroupRequest(BuilderImpl builder) {
        super(builder);
        this.whitelistRules = builder.whitelistRules;
    }

    public List<InputWhitelistRuleCidr> whitelistRules() {
        return this.whitelistRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.whitelistRules());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInputSecurityGroupRequest)) {
            return false;
        }
        CreateInputSecurityGroupRequest other = (CreateInputSecurityGroupRequest)((Object)obj);
        return Objects.equals(this.whitelistRules(), other.whitelistRules());
    }

    public String toString() {
        return ToString.builder((String)"CreateInputSecurityGroupRequest").add("WhitelistRules", this.whitelistRules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WhitelistRules": {
                return Optional.of(clazz.cast(this.whitelistRules()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MediaLiveRequest.BuilderImpl
    implements Builder {
        private List<InputWhitelistRuleCidr> whitelistRules;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInputSecurityGroupRequest model) {
            this.whitelistRules(model.whitelistRules);
        }

        public final Collection<InputWhitelistRuleCidr.Builder> getWhitelistRules() {
            return this.whitelistRules != null ? (Collection)this.whitelistRules.stream().map(InputWhitelistRuleCidr::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder whitelistRules(Collection<InputWhitelistRuleCidr> whitelistRules) {
            this.whitelistRules = ListOfInputWhitelistRuleCidrCopier.copy(whitelistRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder whitelistRules(InputWhitelistRuleCidr ... whitelistRules) {
            this.whitelistRules(Arrays.asList(whitelistRules));
            return this;
        }

        public final void setWhitelistRules(Collection<InputWhitelistRuleCidr.BuilderImpl> whitelistRules) {
            this.whitelistRules = ListOfInputWhitelistRuleCidrCopier.copyFromBuilder(whitelistRules);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateInputSecurityGroupRequest build() {
            return new CreateInputSecurityGroupRequest(this);
        }
    }

    public static interface Builder
    extends MediaLiveRequest.Builder,
    CopyableBuilder<Builder, CreateInputSecurityGroupRequest> {
        public Builder whitelistRules(Collection<InputWhitelistRuleCidr> var1);

        public Builder whitelistRules(InputWhitelistRuleCidr ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

