/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.CaptionSelectorSettings;
import software.amazon.awssdk.services.medialive.transform.CaptionSelectorMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CaptionSelector
implements StructuredPojo,
ToCopyableBuilder<Builder, CaptionSelector> {
    private final String languageCode;
    private final String name;
    private final CaptionSelectorSettings selectorSettings;

    private CaptionSelector(BuilderImpl builder) {
        this.languageCode = builder.languageCode;
        this.name = builder.name;
        this.selectorSettings = builder.selectorSettings;
    }

    public String languageCode() {
        return this.languageCode;
    }

    public String name() {
        return this.name;
    }

    public CaptionSelectorSettings selectorSettings() {
        return this.selectorSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.languageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectorSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaptionSelector)) {
            return false;
        }
        CaptionSelector other = (CaptionSelector)obj;
        return Objects.equals(this.languageCode(), other.languageCode()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.selectorSettings(), other.selectorSettings());
    }

    public String toString() {
        return ToString.builder((String)"CaptionSelector").add("LanguageCode", (Object)this.languageCode()).add("Name", (Object)this.name()).add("SelectorSettings", (Object)this.selectorSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LanguageCode": {
                return Optional.of(clazz.cast(this.languageCode()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "SelectorSettings": {
                return Optional.of(clazz.cast(this.selectorSettings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CaptionSelectorMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String languageCode;
        private String name;
        private CaptionSelectorSettings selectorSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CaptionSelector model) {
            this.languageCode(model.languageCode);
            this.name(model.name);
            this.selectorSettings(model.selectorSettings);
        }

        public final String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public final Builder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public final void setLanguageCode(String languageCode) {
            this.languageCode = languageCode;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final CaptionSelectorSettings.Builder getSelectorSettings() {
            return this.selectorSettings != null ? this.selectorSettings.toBuilder() : null;
        }

        @Override
        public final Builder selectorSettings(CaptionSelectorSettings selectorSettings) {
            this.selectorSettings = selectorSettings;
            return this;
        }

        public final void setSelectorSettings(CaptionSelectorSettings.BuilderImpl selectorSettings) {
            this.selectorSettings = selectorSettings != null ? selectorSettings.build() : null;
        }

        public CaptionSelector build() {
            return new CaptionSelector(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CaptionSelector> {
        public Builder languageCode(String var1);

        public Builder name(String var1);

        public Builder selectorSettings(CaptionSelectorSettings var1);

        default public Builder selectorSettings(Consumer<CaptionSelectorSettings.Builder> selectorSettings) {
            return this.selectorSettings((CaptionSelectorSettings)((CaptionSelectorSettings.Builder)CaptionSelectorSettings.builder().apply(selectorSettings)).build());
        }
    }
}

