/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AudioLanguageSelection;
import software.amazon.awssdk.services.medialive.model.AudioPidSelection;
import software.amazon.awssdk.services.medialive.transform.AudioSelectorSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AudioSelectorSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, AudioSelectorSettings> {
    private final AudioLanguageSelection audioLanguageSelection;
    private final AudioPidSelection audioPidSelection;

    private AudioSelectorSettings(BuilderImpl builder) {
        this.audioLanguageSelection = builder.audioLanguageSelection;
        this.audioPidSelection = builder.audioPidSelection;
    }

    public AudioLanguageSelection audioLanguageSelection() {
        return this.audioLanguageSelection;
    }

    public AudioPidSelection audioPidSelection() {
        return this.audioPidSelection;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioLanguageSelection());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioPidSelection());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSelectorSettings)) {
            return false;
        }
        AudioSelectorSettings other = (AudioSelectorSettings)obj;
        return Objects.equals(this.audioLanguageSelection(), other.audioLanguageSelection()) && Objects.equals(this.audioPidSelection(), other.audioPidSelection());
    }

    public String toString() {
        return ToString.builder((String)"AudioSelectorSettings").add("AudioLanguageSelection", (Object)this.audioLanguageSelection()).add("AudioPidSelection", (Object)this.audioPidSelection()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioLanguageSelection": {
                return Optional.of(clazz.cast(this.audioLanguageSelection()));
            }
            case "AudioPidSelection": {
                return Optional.of(clazz.cast(this.audioPidSelection()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioSelectorSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private AudioLanguageSelection audioLanguageSelection;
        private AudioPidSelection audioPidSelection;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioSelectorSettings model) {
            this.audioLanguageSelection(model.audioLanguageSelection);
            this.audioPidSelection(model.audioPidSelection);
        }

        public final AudioLanguageSelection.Builder getAudioLanguageSelection() {
            return this.audioLanguageSelection != null ? this.audioLanguageSelection.toBuilder() : null;
        }

        @Override
        public final Builder audioLanguageSelection(AudioLanguageSelection audioLanguageSelection) {
            this.audioLanguageSelection = audioLanguageSelection;
            return this;
        }

        public final void setAudioLanguageSelection(AudioLanguageSelection.BuilderImpl audioLanguageSelection) {
            this.audioLanguageSelection = audioLanguageSelection != null ? audioLanguageSelection.build() : null;
        }

        public final AudioPidSelection.Builder getAudioPidSelection() {
            return this.audioPidSelection != null ? this.audioPidSelection.toBuilder() : null;
        }

        @Override
        public final Builder audioPidSelection(AudioPidSelection audioPidSelection) {
            this.audioPidSelection = audioPidSelection;
            return this;
        }

        public final void setAudioPidSelection(AudioPidSelection.BuilderImpl audioPidSelection) {
            this.audioPidSelection = audioPidSelection != null ? audioPidSelection.build() : null;
        }

        public AudioSelectorSettings build() {
            return new AudioSelectorSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AudioSelectorSettings> {
        public Builder audioLanguageSelection(AudioLanguageSelection var1);

        default public Builder audioLanguageSelection(Consumer<AudioLanguageSelection.Builder> audioLanguageSelection) {
            return this.audioLanguageSelection((AudioLanguageSelection)((AudioLanguageSelection.Builder)AudioLanguageSelection.builder().apply(audioLanguageSelection)).build());
        }

        public Builder audioPidSelection(AudioPidSelection var1);

        default public Builder audioPidSelection(Consumer<AudioPidSelection.Builder> audioPidSelection) {
            return this.audioPidSelection((AudioPidSelection)((AudioPidSelection.Builder)AudioPidSelection.builder().apply(audioPidSelection)).build());
        }
    }
}

