/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AudioOnlyHlsTrackType;
import software.amazon.awssdk.services.medialive.model.InputLocation;
import software.amazon.awssdk.services.medialive.transform.AudioOnlyHlsSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AudioOnlyHlsSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, AudioOnlyHlsSettings> {
    private final String audioGroupId;
    private final InputLocation audioOnlyImage;
    private final String audioTrackType;

    private AudioOnlyHlsSettings(BuilderImpl builder) {
        this.audioGroupId = builder.audioGroupId;
        this.audioOnlyImage = builder.audioOnlyImage;
        this.audioTrackType = builder.audioTrackType;
    }

    public String audioGroupId() {
        return this.audioGroupId;
    }

    public InputLocation audioOnlyImage() {
        return this.audioOnlyImage;
    }

    public AudioOnlyHlsTrackType audioTrackType() {
        return AudioOnlyHlsTrackType.fromValue(this.audioTrackType);
    }

    public String audioTrackTypeString() {
        return this.audioTrackType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioOnlyImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioTrackTypeString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioOnlyHlsSettings)) {
            return false;
        }
        AudioOnlyHlsSettings other = (AudioOnlyHlsSettings)obj;
        return Objects.equals(this.audioGroupId(), other.audioGroupId()) && Objects.equals(this.audioOnlyImage(), other.audioOnlyImage()) && Objects.equals(this.audioTrackTypeString(), other.audioTrackTypeString());
    }

    public String toString() {
        return ToString.builder((String)"AudioOnlyHlsSettings").add("AudioGroupId", (Object)this.audioGroupId()).add("AudioOnlyImage", (Object)this.audioOnlyImage()).add("AudioTrackType", (Object)this.audioTrackTypeString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioGroupId": {
                return Optional.of(clazz.cast(this.audioGroupId()));
            }
            case "AudioOnlyImage": {
                return Optional.of(clazz.cast(this.audioOnlyImage()));
            }
            case "AudioTrackType": {
                return Optional.of(clazz.cast(this.audioTrackTypeString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioOnlyHlsSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioGroupId;
        private InputLocation audioOnlyImage;
        private String audioTrackType;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioOnlyHlsSettings model) {
            this.audioGroupId(model.audioGroupId);
            this.audioOnlyImage(model.audioOnlyImage);
            this.audioTrackType(model.audioTrackType);
        }

        public final String getAudioGroupId() {
            return this.audioGroupId;
        }

        @Override
        public final Builder audioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
            return this;
        }

        public final void setAudioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
        }

        public final InputLocation.Builder getAudioOnlyImage() {
            return this.audioOnlyImage != null ? this.audioOnlyImage.toBuilder() : null;
        }

        @Override
        public final Builder audioOnlyImage(InputLocation audioOnlyImage) {
            this.audioOnlyImage = audioOnlyImage;
            return this;
        }

        public final void setAudioOnlyImage(InputLocation.BuilderImpl audioOnlyImage) {
            this.audioOnlyImage = audioOnlyImage != null ? audioOnlyImage.build() : null;
        }

        public final String getAudioTrackType() {
            return this.audioTrackType;
        }

        @Override
        public final Builder audioTrackType(String audioTrackType) {
            this.audioTrackType = audioTrackType;
            return this;
        }

        @Override
        public final Builder audioTrackType(AudioOnlyHlsTrackType audioTrackType) {
            this.audioTrackType(audioTrackType.toString());
            return this;
        }

        public final void setAudioTrackType(String audioTrackType) {
            this.audioTrackType = audioTrackType;
        }

        public AudioOnlyHlsSettings build() {
            return new AudioOnlyHlsSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AudioOnlyHlsSettings> {
        public Builder audioGroupId(String var1);

        public Builder audioOnlyImage(InputLocation var1);

        default public Builder audioOnlyImage(Consumer<InputLocation.Builder> audioOnlyImage) {
            return this.audioOnlyImage((InputLocation)((InputLocation.Builder)InputLocation.builder().apply(audioOnlyImage)).build());
        }

        public Builder audioTrackType(String var1);

        public Builder audioTrackType(AudioOnlyHlsTrackType var1);
    }
}

