/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.medialive.model.AudioNormalizationAlgorithm;
import software.amazon.awssdk.services.medialive.model.AudioNormalizationAlgorithmControl;
import software.amazon.awssdk.services.medialive.transform.AudioNormalizationSettingsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AudioNormalizationSettings
implements StructuredPojo,
ToCopyableBuilder<Builder, AudioNormalizationSettings> {
    private final String algorithm;
    private final String algorithmControl;
    private final Double targetLkfs;

    private AudioNormalizationSettings(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.algorithmControl = builder.algorithmControl;
        this.targetLkfs = builder.targetLkfs;
    }

    public AudioNormalizationAlgorithm algorithm() {
        return AudioNormalizationAlgorithm.fromValue(this.algorithm);
    }

    public String algorithmString() {
        return this.algorithm;
    }

    public AudioNormalizationAlgorithmControl algorithmControl() {
        return AudioNormalizationAlgorithmControl.fromValue(this.algorithmControl);
    }

    public String algorithmControlString() {
        return this.algorithmControl;
    }

    public Double targetLkfs() {
        return this.targetLkfs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmString());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmControlString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLkfs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioNormalizationSettings)) {
            return false;
        }
        AudioNormalizationSettings other = (AudioNormalizationSettings)obj;
        return Objects.equals(this.algorithmString(), other.algorithmString()) && Objects.equals(this.algorithmControlString(), other.algorithmControlString()) && Objects.equals(this.targetLkfs(), other.targetLkfs());
    }

    public String toString() {
        return ToString.builder((String)"AudioNormalizationSettings").add("Algorithm", (Object)this.algorithmString()).add("AlgorithmControl", (Object)this.algorithmControlString()).add("TargetLkfs", (Object)this.targetLkfs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Algorithm": {
                return Optional.of(clazz.cast(this.algorithmString()));
            }
            case "AlgorithmControl": {
                return Optional.of(clazz.cast(this.algorithmControlString()));
            }
            case "TargetLkfs": {
                return Optional.of(clazz.cast(this.targetLkfs()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AudioNormalizationSettingsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithm;
        private String algorithmControl;
        private Double targetLkfs;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioNormalizationSettings model) {
            this.algorithm(model.algorithm);
            this.algorithmControl(model.algorithmControl);
            this.targetLkfs(model.targetLkfs);
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(AudioNormalizationAlgorithm algorithm) {
            this.algorithm(algorithm.toString());
            return this;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public final String getAlgorithmControl() {
            return this.algorithmControl;
        }

        @Override
        public final Builder algorithmControl(String algorithmControl) {
            this.algorithmControl = algorithmControl;
            return this;
        }

        @Override
        public final Builder algorithmControl(AudioNormalizationAlgorithmControl algorithmControl) {
            this.algorithmControl(algorithmControl.toString());
            return this;
        }

        public final void setAlgorithmControl(String algorithmControl) {
            this.algorithmControl = algorithmControl;
        }

        public final Double getTargetLkfs() {
            return this.targetLkfs;
        }

        @Override
        public final Builder targetLkfs(Double targetLkfs) {
            this.targetLkfs = targetLkfs;
            return this;
        }

        public final void setTargetLkfs(Double targetLkfs) {
            this.targetLkfs = targetLkfs;
        }

        public AudioNormalizationSettings build() {
            return new AudioNormalizationSettings(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AudioNormalizationSettings> {
        public Builder algorithm(String var1);

        public Builder algorithm(AudioNormalizationAlgorithm var1);

        public Builder algorithmControl(String var1);

        public Builder algorithmControl(AudioNormalizationAlgorithmControl var1);

        public Builder targetLkfs(Double var1);
    }
}

