/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive;

import java.util.function.Consumer;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.medialive.DefaultMediaLiveClientBuilder;
import software.amazon.awssdk.services.medialive.MediaLiveClientBuilder;
import software.amazon.awssdk.services.medialive.model.BadGatewayException;
import software.amazon.awssdk.services.medialive.model.BadRequestException;
import software.amazon.awssdk.services.medialive.model.ConflictException;
import software.amazon.awssdk.services.medialive.model.CreateChannelRequest;
import software.amazon.awssdk.services.medialive.model.CreateChannelResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputResponse;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.CreateInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DeleteChannelRequest;
import software.amazon.awssdk.services.medialive.model.DeleteChannelResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputResponse;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DeleteInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.DescribeChannelRequest;
import software.amazon.awssdk.services.medialive.model.DescribeChannelResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputResponse;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupRequest;
import software.amazon.awssdk.services.medialive.model.DescribeInputSecurityGroupResponse;
import software.amazon.awssdk.services.medialive.model.ForbiddenException;
import software.amazon.awssdk.services.medialive.model.GatewayTimeoutException;
import software.amazon.awssdk.services.medialive.model.InternalServerErrorException;
import software.amazon.awssdk.services.medialive.model.ListChannelsRequest;
import software.amazon.awssdk.services.medialive.model.ListChannelsResponse;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputSecurityGroupsResponse;
import software.amazon.awssdk.services.medialive.model.ListInputsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputsResponse;
import software.amazon.awssdk.services.medialive.model.MediaLiveException;
import software.amazon.awssdk.services.medialive.model.NotFoundException;
import software.amazon.awssdk.services.medialive.model.StartChannelRequest;
import software.amazon.awssdk.services.medialive.model.StartChannelResponse;
import software.amazon.awssdk.services.medialive.model.StopChannelRequest;
import software.amazon.awssdk.services.medialive.model.StopChannelResponse;
import software.amazon.awssdk.services.medialive.model.TooManyRequestsException;
import software.amazon.awssdk.services.medialive.model.UnprocessableEntityException;
import software.amazon.awssdk.services.medialive.paginators.ListChannelsIterable;
import software.amazon.awssdk.services.medialive.paginators.ListInputSecurityGroupsIterable;
import software.amazon.awssdk.services.medialive.paginators.ListInputsIterable;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public interface MediaLiveClient
extends SdkClient,
SdkAutoCloseable {
    public static final String SERVICE_NAME = "medialive";

    public static MediaLiveClient create() {
        return (MediaLiveClient)MediaLiveClient.builder().build();
    }

    public static MediaLiveClientBuilder builder() {
        return new DefaultMediaLiveClientBuilder();
    }

    default public CreateChannelResponse createChannel(CreateChannelRequest createChannelRequest) throws UnprocessableEntityException, BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public CreateChannelResponse createChannel(Consumer<CreateChannelRequest.Builder> createChannelRequest) throws UnprocessableEntityException, BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, ConflictException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.createChannel((CreateChannelRequest)((Object)((CreateChannelRequest.Builder)CreateChannelRequest.builder().apply(createChannelRequest)).build()));
    }

    default public CreateInputResponse createInput(CreateInputRequest createInputRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public CreateInputResponse createInput(Consumer<CreateInputRequest.Builder> createInputRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.createInput((CreateInputRequest)((Object)((CreateInputRequest.Builder)CreateInputRequest.builder().apply(createInputRequest)).build()));
    }

    default public CreateInputSecurityGroupResponse createInputSecurityGroup(CreateInputSecurityGroupRequest createInputSecurityGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public CreateInputSecurityGroupResponse createInputSecurityGroup(Consumer<CreateInputSecurityGroupRequest.Builder> createInputSecurityGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.createInputSecurityGroup((CreateInputSecurityGroupRequest)((Object)((CreateInputSecurityGroupRequest.Builder)CreateInputSecurityGroupRequest.builder().apply(createInputSecurityGroupRequest)).build()));
    }

    default public DeleteChannelResponse deleteChannel(DeleteChannelRequest deleteChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public DeleteChannelResponse deleteChannel(Consumer<DeleteChannelRequest.Builder> deleteChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.deleteChannel((DeleteChannelRequest)((Object)((DeleteChannelRequest.Builder)DeleteChannelRequest.builder().apply(deleteChannelRequest)).build()));
    }

    default public DeleteInputResponse deleteInput(DeleteInputRequest deleteInputRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public DeleteInputResponse deleteInput(Consumer<DeleteInputRequest.Builder> deleteInputRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.deleteInput((DeleteInputRequest)((Object)((DeleteInputRequest.Builder)DeleteInputRequest.builder().apply(deleteInputRequest)).build()));
    }

    default public DeleteInputSecurityGroupResponse deleteInputSecurityGroup(DeleteInputSecurityGroupRequest deleteInputSecurityGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public DeleteInputSecurityGroupResponse deleteInputSecurityGroup(Consumer<DeleteInputSecurityGroupRequest.Builder> deleteInputSecurityGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.deleteInputSecurityGroup((DeleteInputSecurityGroupRequest)((Object)((DeleteInputSecurityGroupRequest.Builder)DeleteInputSecurityGroupRequest.builder().apply(deleteInputSecurityGroupRequest)).build()));
    }

    default public DescribeChannelResponse describeChannel(DescribeChannelRequest describeChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public DescribeChannelResponse describeChannel(Consumer<DescribeChannelRequest.Builder> describeChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.describeChannel((DescribeChannelRequest)((Object)((DescribeChannelRequest.Builder)DescribeChannelRequest.builder().apply(describeChannelRequest)).build()));
    }

    default public DescribeInputResponse describeInput(DescribeInputRequest describeInputRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public DescribeInputResponse describeInput(Consumer<DescribeInputRequest.Builder> describeInputRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.describeInput((DescribeInputRequest)((Object)((DescribeInputRequest.Builder)DescribeInputRequest.builder().apply(describeInputRequest)).build()));
    }

    default public DescribeInputSecurityGroupResponse describeInputSecurityGroup(DescribeInputSecurityGroupRequest describeInputSecurityGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public DescribeInputSecurityGroupResponse describeInputSecurityGroup(Consumer<DescribeInputSecurityGroupRequest.Builder> describeInputSecurityGroupRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.describeInputSecurityGroup((DescribeInputSecurityGroupRequest)((Object)((DescribeInputSecurityGroupRequest.Builder)DescribeInputSecurityGroupRequest.builder().apply(describeInputSecurityGroupRequest)).build()));
    }

    default public ListChannelsResponse listChannels() throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.listChannels((ListChannelsRequest)((Object)ListChannelsRequest.builder().build()));
    }

    default public ListChannelsResponse listChannels(ListChannelsRequest listChannelsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public ListChannelsResponse listChannels(Consumer<ListChannelsRequest.Builder> listChannelsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.listChannels((ListChannelsRequest)((Object)((ListChannelsRequest.Builder)ListChannelsRequest.builder().apply(listChannelsRequest)).build()));
    }

    default public ListChannelsIterable listChannelsPaginator() throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.listChannelsPaginator((ListChannelsRequest)((Object)ListChannelsRequest.builder().build()));
    }

    default public ListChannelsIterable listChannelsPaginator(ListChannelsRequest listChannelsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public ListInputSecurityGroupsResponse listInputSecurityGroups() throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.listInputSecurityGroups((ListInputSecurityGroupsRequest)((Object)ListInputSecurityGroupsRequest.builder().build()));
    }

    default public ListInputSecurityGroupsResponse listInputSecurityGroups(ListInputSecurityGroupsRequest listInputSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public ListInputSecurityGroupsResponse listInputSecurityGroups(Consumer<ListInputSecurityGroupsRequest.Builder> listInputSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.listInputSecurityGroups((ListInputSecurityGroupsRequest)((Object)((ListInputSecurityGroupsRequest.Builder)ListInputSecurityGroupsRequest.builder().apply(listInputSecurityGroupsRequest)).build()));
    }

    default public ListInputSecurityGroupsIterable listInputSecurityGroupsPaginator() throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.listInputSecurityGroupsPaginator((ListInputSecurityGroupsRequest)((Object)ListInputSecurityGroupsRequest.builder().build()));
    }

    default public ListInputSecurityGroupsIterable listInputSecurityGroupsPaginator(ListInputSecurityGroupsRequest listInputSecurityGroupsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public ListInputsResponse listInputs() throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.listInputs((ListInputsRequest)((Object)ListInputsRequest.builder().build()));
    }

    default public ListInputsResponse listInputs(ListInputsRequest listInputsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public ListInputsResponse listInputs(Consumer<ListInputsRequest.Builder> listInputsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.listInputs((ListInputsRequest)((Object)((ListInputsRequest.Builder)ListInputsRequest.builder().apply(listInputsRequest)).build()));
    }

    default public ListInputsIterable listInputsPaginator() throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.listInputsPaginator((ListInputsRequest)((Object)ListInputsRequest.builder().build()));
    }

    default public ListInputsIterable listInputsPaginator(ListInputsRequest listInputsRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, GatewayTimeoutException, TooManyRequestsException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public StartChannelResponse startChannel(StartChannelRequest startChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public StartChannelResponse startChannel(Consumer<StartChannelRequest.Builder> startChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.startChannel((StartChannelRequest)((Object)((StartChannelRequest.Builder)StartChannelRequest.builder().apply(startChannelRequest)).build()));
    }

    default public StopChannelResponse stopChannel(StopChannelRequest stopChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, SdkServiceException, SdkClientException, MediaLiveException {
        throw new UnsupportedOperationException();
    }

    default public StopChannelResponse stopChannel(Consumer<StopChannelRequest.Builder> stopChannelRequest) throws BadRequestException, InternalServerErrorException, ForbiddenException, BadGatewayException, NotFoundException, GatewayTimeoutException, TooManyRequestsException, ConflictException, SdkServiceException, SdkClientException, MediaLiveException {
        return this.stopChannel((StopChannelRequest)((Object)((StopChannelRequest.Builder)StopChannelRequest.builder().apply(stopChannelRequest)).build()));
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)SERVICE_NAME);
    }
}

