/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medialive.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.medialive.MediaLiveClient;
import software.amazon.awssdk.services.medialive.model.Input;
import software.amazon.awssdk.services.medialive.model.ListInputsRequest;
import software.amazon.awssdk.services.medialive.model.ListInputsResponse;

public class ListInputsIterable
implements SdkIterable<ListInputsResponse> {
    private final MediaLiveClient client;
    private final ListInputsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInputsIterable(MediaLiveClient client, ListInputsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInputsResponseFetcher();
    }

    public Iterator<ListInputsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Input> inputs() {
        Function<ListInputsResponse, Iterator> getIterator = response -> {
            if (response != null && response.inputs() != null) {
                return response.inputs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListInputsIterable resume(ListInputsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInputsIterable(this.client, (ListInputsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListInputsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListInputsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListInputsResponseFetcher
    implements SyncPageFetcher<ListInputsResponse> {
        private ListInputsResponseFetcher() {
        }

        public boolean hasNextPage(ListInputsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInputsResponse nextPage(ListInputsResponse previousPage) {
            if (previousPage == null) {
                return ListInputsIterable.this.client.listInputs(ListInputsIterable.this.firstRequest);
            }
            return ListInputsIterable.this.client.listInputs((ListInputsRequest)((Object)ListInputsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

