/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.NoiseReducerFilter;
import software.amazon.awssdk.services.mediaconvert.model.NoiseReducerFilterSettings;
import software.amazon.awssdk.services.mediaconvert.model.NoiseReducerSpatialFilterSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NoiseReducer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NoiseReducer> {
    private static final SdkField<String> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NoiseReducer.getter(NoiseReducer::filterAsString)).setter(NoiseReducer.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final SdkField<NoiseReducerFilterSettings> FILTER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(NoiseReducer.getter(NoiseReducer::filterSettings)).setter(NoiseReducer.setter(Builder::filterSettings)).constructor(NoiseReducerFilterSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterSettings").build()}).build();
    private static final SdkField<NoiseReducerSpatialFilterSettings> SPATIAL_FILTER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(NoiseReducer.getter(NoiseReducer::spatialFilterSettings)).setter(NoiseReducer.setter(Builder::spatialFilterSettings)).constructor(NoiseReducerSpatialFilterSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spatialFilterSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, FILTER_SETTINGS_FIELD, SPATIAL_FILTER_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String filter;
    private final NoiseReducerFilterSettings filterSettings;
    private final NoiseReducerSpatialFilterSettings spatialFilterSettings;

    private NoiseReducer(BuilderImpl builder) {
        this.filter = builder.filter;
        this.filterSettings = builder.filterSettings;
        this.spatialFilterSettings = builder.spatialFilterSettings;
    }

    public NoiseReducerFilter filter() {
        return NoiseReducerFilter.fromValue(this.filter);
    }

    public String filterAsString() {
        return this.filter;
    }

    public NoiseReducerFilterSettings filterSettings() {
        return this.filterSettings;
    }

    public NoiseReducerSpatialFilterSettings spatialFilterSettings() {
        return this.spatialFilterSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.spatialFilterSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NoiseReducer)) {
            return false;
        }
        NoiseReducer other = (NoiseReducer)obj;
        return Objects.equals(this.filterAsString(), other.filterAsString()) && Objects.equals(this.filterSettings(), other.filterSettings()) && Objects.equals(this.spatialFilterSettings(), other.spatialFilterSettings());
    }

    public String toString() {
        return ToString.builder((String)"NoiseReducer").add("Filter", (Object)this.filterAsString()).add("FilterSettings", (Object)this.filterSettings()).add("SpatialFilterSettings", (Object)this.spatialFilterSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filterAsString()));
            }
            case "FilterSettings": {
                return Optional.ofNullable(clazz.cast(this.filterSettings()));
            }
            case "SpatialFilterSettings": {
                return Optional.ofNullable(clazz.cast(this.spatialFilterSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NoiseReducer, T> g) {
        return obj -> g.apply((NoiseReducer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filter;
        private NoiseReducerFilterSettings filterSettings;
        private NoiseReducerSpatialFilterSettings spatialFilterSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(NoiseReducer model) {
            this.filter(model.filter);
            this.filterSettings(model.filterSettings);
            this.spatialFilterSettings(model.spatialFilterSettings);
        }

        public final String getFilterAsString() {
            return this.filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public final Builder filter(NoiseReducerFilter filter) {
            this.filter(filter == null ? null : filter.toString());
            return this;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        public final NoiseReducerFilterSettings.Builder getFilterSettings() {
            return this.filterSettings != null ? this.filterSettings.toBuilder() : null;
        }

        @Override
        public final Builder filterSettings(NoiseReducerFilterSettings filterSettings) {
            this.filterSettings = filterSettings;
            return this;
        }

        public final void setFilterSettings(NoiseReducerFilterSettings.BuilderImpl filterSettings) {
            this.filterSettings = filterSettings != null ? filterSettings.build() : null;
        }

        public final NoiseReducerSpatialFilterSettings.Builder getSpatialFilterSettings() {
            return this.spatialFilterSettings != null ? this.spatialFilterSettings.toBuilder() : null;
        }

        @Override
        public final Builder spatialFilterSettings(NoiseReducerSpatialFilterSettings spatialFilterSettings) {
            this.spatialFilterSettings = spatialFilterSettings;
            return this;
        }

        public final void setSpatialFilterSettings(NoiseReducerSpatialFilterSettings.BuilderImpl spatialFilterSettings) {
            this.spatialFilterSettings = spatialFilterSettings != null ? spatialFilterSettings.build() : null;
        }

        public NoiseReducer build() {
            return new NoiseReducer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NoiseReducer> {
        public Builder filter(String var1);

        public Builder filter(NoiseReducerFilter var1);

        public Builder filterSettings(NoiseReducerFilterSettings var1);

        default public Builder filterSettings(Consumer<NoiseReducerFilterSettings.Builder> filterSettings) {
            return this.filterSettings((NoiseReducerFilterSettings)((NoiseReducerFilterSettings.Builder)NoiseReducerFilterSettings.builder().applyMutation(filterSettings)).build());
        }

        public Builder spatialFilterSettings(NoiseReducerSpatialFilterSettings var1);

        default public Builder spatialFilterSettings(Consumer<NoiseReducerSpatialFilterSettings.Builder> spatialFilterSettings) {
            return this.spatialFilterSettings((NoiseReducerSpatialFilterSettings)((NoiseReducerSpatialFilterSettings.Builder)NoiseReducerSpatialFilterSettings.builder().applyMutation(spatialFilterSettings)).build());
        }
    }
}

