/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.ContainerType;
import software.amazon.awssdk.services.mediaconvert.model.F4vSettings;
import software.amazon.awssdk.services.mediaconvert.model.M2tsSettings;
import software.amazon.awssdk.services.mediaconvert.model.M3u8Settings;
import software.amazon.awssdk.services.mediaconvert.model.MovSettings;
import software.amazon.awssdk.services.mediaconvert.model.Mp4Settings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerSettings> {
    private static final SdkField<String> CONTAINER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ContainerSettings.getter(ContainerSettings::containerAsString)).setter(ContainerSettings.setter(Builder::container)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("container").build()}).build();
    private static final SdkField<F4vSettings> F4_V_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ContainerSettings.getter(ContainerSettings::f4vSettings)).setter(ContainerSettings.setter(Builder::f4vSettings)).constructor(F4vSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("f4vSettings").build()}).build();
    private static final SdkField<M2tsSettings> M2_TS_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ContainerSettings.getter(ContainerSettings::m2tsSettings)).setter(ContainerSettings.setter(Builder::m2tsSettings)).constructor(M2tsSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2tsSettings").build()}).build();
    private static final SdkField<M3u8Settings> M3_U8_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ContainerSettings.getter(ContainerSettings::m3u8Settings)).setter(ContainerSettings.setter(Builder::m3u8Settings)).constructor(M3u8Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m3u8Settings").build()}).build();
    private static final SdkField<MovSettings> MOV_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ContainerSettings.getter(ContainerSettings::movSettings)).setter(ContainerSettings.setter(Builder::movSettings)).constructor(MovSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("movSettings").build()}).build();
    private static final SdkField<Mp4Settings> MP4_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ContainerSettings.getter(ContainerSettings::mp4Settings)).setter(ContainerSettings.setter(Builder::mp4Settings)).constructor(Mp4Settings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mp4Settings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_FIELD, F4_V_SETTINGS_FIELD, M2_TS_SETTINGS_FIELD, M3_U8_SETTINGS_FIELD, MOV_SETTINGS_FIELD, MP4_SETTINGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String container;
    private final F4vSettings f4vSettings;
    private final M2tsSettings m2tsSettings;
    private final M3u8Settings m3u8Settings;
    private final MovSettings movSettings;
    private final Mp4Settings mp4Settings;

    private ContainerSettings(BuilderImpl builder) {
        this.container = builder.container;
        this.f4vSettings = builder.f4vSettings;
        this.m2tsSettings = builder.m2tsSettings;
        this.m3u8Settings = builder.m3u8Settings;
        this.movSettings = builder.movSettings;
        this.mp4Settings = builder.mp4Settings;
    }

    public ContainerType container() {
        return ContainerType.fromValue(this.container);
    }

    public String containerAsString() {
        return this.container;
    }

    public F4vSettings f4vSettings() {
        return this.f4vSettings;
    }

    public M2tsSettings m2tsSettings() {
        return this.m2tsSettings;
    }

    public M3u8Settings m3u8Settings() {
        return this.m3u8Settings;
    }

    public MovSettings movSettings() {
        return this.movSettings;
    }

    public Mp4Settings mp4Settings() {
        return this.mp4Settings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.containerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.f4vSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.m2tsSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.m3u8Settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.movSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.mp4Settings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerSettings)) {
            return false;
        }
        ContainerSettings other = (ContainerSettings)obj;
        return Objects.equals(this.containerAsString(), other.containerAsString()) && Objects.equals(this.f4vSettings(), other.f4vSettings()) && Objects.equals(this.m2tsSettings(), other.m2tsSettings()) && Objects.equals(this.m3u8Settings(), other.m3u8Settings()) && Objects.equals(this.movSettings(), other.movSettings()) && Objects.equals(this.mp4Settings(), other.mp4Settings());
    }

    public String toString() {
        return ToString.builder((String)"ContainerSettings").add("Container", (Object)this.containerAsString()).add("F4vSettings", (Object)this.f4vSettings()).add("M2tsSettings", (Object)this.m2tsSettings()).add("M3u8Settings", (Object)this.m3u8Settings()).add("MovSettings", (Object)this.movSettings()).add("Mp4Settings", (Object)this.mp4Settings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Container": {
                return Optional.ofNullable(clazz.cast(this.containerAsString()));
            }
            case "F4vSettings": {
                return Optional.ofNullable(clazz.cast(this.f4vSettings()));
            }
            case "M2tsSettings": {
                return Optional.ofNullable(clazz.cast(this.m2tsSettings()));
            }
            case "M3u8Settings": {
                return Optional.ofNullable(clazz.cast(this.m3u8Settings()));
            }
            case "MovSettings": {
                return Optional.ofNullable(clazz.cast(this.movSettings()));
            }
            case "Mp4Settings": {
                return Optional.ofNullable(clazz.cast(this.mp4Settings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerSettings, T> g) {
        return obj -> g.apply((ContainerSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String container;
        private F4vSettings f4vSettings;
        private M2tsSettings m2tsSettings;
        private M3u8Settings m3u8Settings;
        private MovSettings movSettings;
        private Mp4Settings mp4Settings;

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerSettings model) {
            this.container(model.container);
            this.f4vSettings(model.f4vSettings);
            this.m2tsSettings(model.m2tsSettings);
            this.m3u8Settings(model.m3u8Settings);
            this.movSettings(model.movSettings);
            this.mp4Settings(model.mp4Settings);
        }

        public final String getContainerAsString() {
            return this.container;
        }

        @Override
        public final Builder container(String container) {
            this.container = container;
            return this;
        }

        @Override
        public final Builder container(ContainerType container) {
            this.container(container.toString());
            return this;
        }

        public final void setContainer(String container) {
            this.container = container;
        }

        public final F4vSettings.Builder getF4vSettings() {
            return this.f4vSettings != null ? this.f4vSettings.toBuilder() : null;
        }

        @Override
        public final Builder f4vSettings(F4vSettings f4vSettings) {
            this.f4vSettings = f4vSettings;
            return this;
        }

        public final void setF4vSettings(F4vSettings.BuilderImpl f4vSettings) {
            this.f4vSettings = f4vSettings != null ? f4vSettings.build() : null;
        }

        public final M2tsSettings.Builder getM2tsSettings() {
            return this.m2tsSettings != null ? this.m2tsSettings.toBuilder() : null;
        }

        @Override
        public final Builder m2tsSettings(M2tsSettings m2tsSettings) {
            this.m2tsSettings = m2tsSettings;
            return this;
        }

        public final void setM2tsSettings(M2tsSettings.BuilderImpl m2tsSettings) {
            this.m2tsSettings = m2tsSettings != null ? m2tsSettings.build() : null;
        }

        public final M3u8Settings.Builder getM3u8Settings() {
            return this.m3u8Settings != null ? this.m3u8Settings.toBuilder() : null;
        }

        @Override
        public final Builder m3u8Settings(M3u8Settings m3u8Settings) {
            this.m3u8Settings = m3u8Settings;
            return this;
        }

        public final void setM3u8Settings(M3u8Settings.BuilderImpl m3u8Settings) {
            this.m3u8Settings = m3u8Settings != null ? m3u8Settings.build() : null;
        }

        public final MovSettings.Builder getMovSettings() {
            return this.movSettings != null ? this.movSettings.toBuilder() : null;
        }

        @Override
        public final Builder movSettings(MovSettings movSettings) {
            this.movSettings = movSettings;
            return this;
        }

        public final void setMovSettings(MovSettings.BuilderImpl movSettings) {
            this.movSettings = movSettings != null ? movSettings.build() : null;
        }

        public final Mp4Settings.Builder getMp4Settings() {
            return this.mp4Settings != null ? this.mp4Settings.toBuilder() : null;
        }

        @Override
        public final Builder mp4Settings(Mp4Settings mp4Settings) {
            this.mp4Settings = mp4Settings;
            return this;
        }

        public final void setMp4Settings(Mp4Settings.BuilderImpl mp4Settings) {
            this.mp4Settings = mp4Settings != null ? mp4Settings.build() : null;
        }

        public ContainerSettings build() {
            return new ContainerSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerSettings> {
        public Builder container(String var1);

        public Builder container(ContainerType var1);

        public Builder f4vSettings(F4vSettings var1);

        default public Builder f4vSettings(Consumer<F4vSettings.Builder> f4vSettings) {
            return this.f4vSettings((F4vSettings)((F4vSettings.Builder)F4vSettings.builder().applyMutation(f4vSettings)).build());
        }

        public Builder m2tsSettings(M2tsSettings var1);

        default public Builder m2tsSettings(Consumer<M2tsSettings.Builder> m2tsSettings) {
            return this.m2tsSettings((M2tsSettings)((M2tsSettings.Builder)M2tsSettings.builder().applyMutation(m2tsSettings)).build());
        }

        public Builder m3u8Settings(M3u8Settings var1);

        default public Builder m3u8Settings(Consumer<M3u8Settings.Builder> m3u8Settings) {
            return this.m3u8Settings((M3u8Settings)((M3u8Settings.Builder)M3u8Settings.builder().applyMutation(m3u8Settings)).build());
        }

        public Builder movSettings(MovSettings var1);

        default public Builder movSettings(Consumer<MovSettings.Builder> movSettings) {
            return this.movSettings((MovSettings)((MovSettings.Builder)MovSettings.builder().applyMutation(movSettings)).build());
        }

        public Builder mp4Settings(Mp4Settings var1);

        default public Builder mp4Settings(Consumer<Mp4Settings.Builder> mp4Settings) {
            return this.mp4Settings((Mp4Settings)((Mp4Settings.Builder)Mp4Settings.builder().applyMutation(mp4Settings)).build());
        }
    }
}

