/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.S3EncryptionSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DestinationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DestinationSettings> {
    private static final SdkField<S3EncryptionSettings> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(S3DestinationSettings.getter(S3DestinationSettings::encryption)).setter(S3DestinationSettings.setter(Builder::encryption)).constructor(S3EncryptionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final S3EncryptionSettings encryption;

    private S3DestinationSettings(BuilderImpl builder) {
        this.encryption = builder.encryption;
    }

    public S3EncryptionSettings encryption() {
        return this.encryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationSettings)) {
            return false;
        }
        S3DestinationSettings other = (S3DestinationSettings)obj;
        return Objects.equals(this.encryption(), other.encryption());
    }

    public String toString() {
        return ToString.builder((String)"S3DestinationSettings").add("Encryption", (Object)this.encryption()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3DestinationSettings, T> g) {
        return obj -> g.apply((S3DestinationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3EncryptionSettings encryption;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DestinationSettings model) {
            this.encryption(model.encryption);
        }

        public final S3EncryptionSettings.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(S3EncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(S3EncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public S3DestinationSettings build() {
            return new S3DestinationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DestinationSettings> {
        public Builder encryption(S3EncryptionSettings var1);

        default public Builder encryption(Consumer<S3EncryptionSettings.Builder> encryption) {
            return this.encryption((S3EncryptionSettings)((S3EncryptionSettings.Builder)S3EncryptionSettings.builder().applyMutation(encryption)).build());
        }
    }
}

