/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.HlsAudioTrackType;
import software.amazon.awssdk.services.mediaconvert.model.HlsIFrameOnlyManifest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HlsSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HlsSettings> {
    private static final SdkField<String> AUDIO_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsSettings.getter(HlsSettings::audioGroupId)).setter(HlsSettings.setter(Builder::audioGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioGroupId").build()}).build();
    private static final SdkField<String> AUDIO_RENDITION_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsSettings.getter(HlsSettings::audioRenditionSets)).setter(HlsSettings.setter(Builder::audioRenditionSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioRenditionSets").build()}).build();
    private static final SdkField<String> AUDIO_TRACK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsSettings.getter(HlsSettings::audioTrackTypeAsString)).setter(HlsSettings.setter(Builder::audioTrackType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioTrackType").build()}).build();
    private static final SdkField<String> I_FRAME_ONLY_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsSettings.getter(HlsSettings::iFrameOnlyManifestAsString)).setter(HlsSettings.setter(Builder::iFrameOnlyManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iFrameOnlyManifest").build()}).build();
    private static final SdkField<String> SEGMENT_MODIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(HlsSettings.getter(HlsSettings::segmentModifier)).setter(HlsSettings.setter(Builder::segmentModifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentModifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUDIO_GROUP_ID_FIELD, AUDIO_RENDITION_SETS_FIELD, AUDIO_TRACK_TYPE_FIELD, I_FRAME_ONLY_MANIFEST_FIELD, SEGMENT_MODIFIER_FIELD));
    private static final long serialVersionUID = 1L;
    private final String audioGroupId;
    private final String audioRenditionSets;
    private final String audioTrackType;
    private final String iFrameOnlyManifest;
    private final String segmentModifier;

    private HlsSettings(BuilderImpl builder) {
        this.audioGroupId = builder.audioGroupId;
        this.audioRenditionSets = builder.audioRenditionSets;
        this.audioTrackType = builder.audioTrackType;
        this.iFrameOnlyManifest = builder.iFrameOnlyManifest;
        this.segmentModifier = builder.segmentModifier;
    }

    public String audioGroupId() {
        return this.audioGroupId;
    }

    public String audioRenditionSets() {
        return this.audioRenditionSets;
    }

    public HlsAudioTrackType audioTrackType() {
        return HlsAudioTrackType.fromValue(this.audioTrackType);
    }

    public String audioTrackTypeAsString() {
        return this.audioTrackType;
    }

    public HlsIFrameOnlyManifest iFrameOnlyManifest() {
        return HlsIFrameOnlyManifest.fromValue(this.iFrameOnlyManifest);
    }

    public String iFrameOnlyManifestAsString() {
        return this.iFrameOnlyManifest;
    }

    public String segmentModifier() {
        return this.segmentModifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.audioGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioRenditionSets());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioTrackTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.iFrameOnlyManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentModifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HlsSettings)) {
            return false;
        }
        HlsSettings other = (HlsSettings)obj;
        return Objects.equals(this.audioGroupId(), other.audioGroupId()) && Objects.equals(this.audioRenditionSets(), other.audioRenditionSets()) && Objects.equals(this.audioTrackTypeAsString(), other.audioTrackTypeAsString()) && Objects.equals(this.iFrameOnlyManifestAsString(), other.iFrameOnlyManifestAsString()) && Objects.equals(this.segmentModifier(), other.segmentModifier());
    }

    public String toString() {
        return ToString.builder((String)"HlsSettings").add("AudioGroupId", (Object)this.audioGroupId()).add("AudioRenditionSets", (Object)this.audioRenditionSets()).add("AudioTrackType", (Object)this.audioTrackTypeAsString()).add("IFrameOnlyManifest", (Object)this.iFrameOnlyManifestAsString()).add("SegmentModifier", (Object)this.segmentModifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AudioGroupId": {
                return Optional.ofNullable(clazz.cast(this.audioGroupId()));
            }
            case "AudioRenditionSets": {
                return Optional.ofNullable(clazz.cast(this.audioRenditionSets()));
            }
            case "AudioTrackType": {
                return Optional.ofNullable(clazz.cast(this.audioTrackTypeAsString()));
            }
            case "IFrameOnlyManifest": {
                return Optional.ofNullable(clazz.cast(this.iFrameOnlyManifestAsString()));
            }
            case "SegmentModifier": {
                return Optional.ofNullable(clazz.cast(this.segmentModifier()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HlsSettings, T> g) {
        return obj -> g.apply((HlsSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String audioGroupId;
        private String audioRenditionSets;
        private String audioTrackType;
        private String iFrameOnlyManifest;
        private String segmentModifier;

        private BuilderImpl() {
        }

        private BuilderImpl(HlsSettings model) {
            this.audioGroupId(model.audioGroupId);
            this.audioRenditionSets(model.audioRenditionSets);
            this.audioTrackType(model.audioTrackType);
            this.iFrameOnlyManifest(model.iFrameOnlyManifest);
            this.segmentModifier(model.segmentModifier);
        }

        public final String getAudioGroupId() {
            return this.audioGroupId;
        }

        @Override
        public final Builder audioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
            return this;
        }

        public final void setAudioGroupId(String audioGroupId) {
            this.audioGroupId = audioGroupId;
        }

        public final String getAudioRenditionSets() {
            return this.audioRenditionSets;
        }

        @Override
        public final Builder audioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
            return this;
        }

        public final void setAudioRenditionSets(String audioRenditionSets) {
            this.audioRenditionSets = audioRenditionSets;
        }

        public final String getAudioTrackTypeAsString() {
            return this.audioTrackType;
        }

        @Override
        public final Builder audioTrackType(String audioTrackType) {
            this.audioTrackType = audioTrackType;
            return this;
        }

        @Override
        public final Builder audioTrackType(HlsAudioTrackType audioTrackType) {
            this.audioTrackType(audioTrackType.toString());
            return this;
        }

        public final void setAudioTrackType(String audioTrackType) {
            this.audioTrackType = audioTrackType;
        }

        public final String getIFrameOnlyManifestAsString() {
            return this.iFrameOnlyManifest;
        }

        @Override
        public final Builder iFrameOnlyManifest(String iFrameOnlyManifest) {
            this.iFrameOnlyManifest = iFrameOnlyManifest;
            return this;
        }

        @Override
        public final Builder iFrameOnlyManifest(HlsIFrameOnlyManifest iFrameOnlyManifest) {
            this.iFrameOnlyManifest(iFrameOnlyManifest.toString());
            return this;
        }

        public final void setIFrameOnlyManifest(String iFrameOnlyManifest) {
            this.iFrameOnlyManifest = iFrameOnlyManifest;
        }

        public final String getSegmentModifier() {
            return this.segmentModifier;
        }

        @Override
        public final Builder segmentModifier(String segmentModifier) {
            this.segmentModifier = segmentModifier;
            return this;
        }

        public final void setSegmentModifier(String segmentModifier) {
            this.segmentModifier = segmentModifier;
        }

        public HlsSettings build() {
            return new HlsSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HlsSettings> {
        public Builder audioGroupId(String var1);

        public Builder audioRenditionSets(String var1);

        public Builder audioTrackType(String var1);

        public Builder audioTrackType(HlsAudioTrackType var1);

        public Builder iFrameOnlyManifest(String var1);

        public Builder iFrameOnlyManifest(HlsIFrameOnlyManifest var1);

        public Builder segmentModifier(String var1);
    }
}

