/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.CmafClientCache;
import software.amazon.awssdk.services.mediaconvert.model.CmafCodecSpecification;
import software.amazon.awssdk.services.mediaconvert.model.CmafEncryptionSettings;
import software.amazon.awssdk.services.mediaconvert.model.CmafManifestCompression;
import software.amazon.awssdk.services.mediaconvert.model.CmafManifestDurationFormat;
import software.amazon.awssdk.services.mediaconvert.model.CmafSegmentControl;
import software.amazon.awssdk.services.mediaconvert.model.CmafStreamInfResolution;
import software.amazon.awssdk.services.mediaconvert.model.CmafWriteDASHManifest;
import software.amazon.awssdk.services.mediaconvert.model.CmafWriteHLSManifest;
import software.amazon.awssdk.services.mediaconvert.model.DestinationSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CmafGroupSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CmafGroupSettings> {
    private static final SdkField<String> BASE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CmafGroupSettings.getter(CmafGroupSettings::baseUrl)).setter(CmafGroupSettings.setter(Builder::baseUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseUrl").build()}).build();
    private static final SdkField<String> CLIENT_CACHE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CmafGroupSettings.getter(CmafGroupSettings::clientCacheAsString)).setter(CmafGroupSettings.setter(Builder::clientCache)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientCache").build()}).build();
    private static final SdkField<String> CODEC_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CmafGroupSettings.getter(CmafGroupSettings::codecSpecificationAsString)).setter(CmafGroupSettings.setter(Builder::codecSpecification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecSpecification").build()}).build();
    private static final SdkField<String> DESTINATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CmafGroupSettings.getter(CmafGroupSettings::destination)).setter(CmafGroupSettings.setter(Builder::destination)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()}).build();
    private static final SdkField<DestinationSettings> DESTINATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CmafGroupSettings.getter(CmafGroupSettings::destinationSettings)).setter(CmafGroupSettings.setter(Builder::destinationSettings)).constructor(DestinationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationSettings").build()}).build();
    private static final SdkField<CmafEncryptionSettings> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CmafGroupSettings.getter(CmafGroupSettings::encryption)).setter(CmafGroupSettings.setter(Builder::encryption)).constructor(CmafEncryptionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final SdkField<Integer> FRAGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CmafGroupSettings.getter(CmafGroupSettings::fragmentLength)).setter(CmafGroupSettings.setter(Builder::fragmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fragmentLength").build()}).build();
    private static final SdkField<String> MANIFEST_COMPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CmafGroupSettings.getter(CmafGroupSettings::manifestCompressionAsString)).setter(CmafGroupSettings.setter(Builder::manifestCompression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestCompression").build()}).build();
    private static final SdkField<String> MANIFEST_DURATION_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CmafGroupSettings.getter(CmafGroupSettings::manifestDurationFormatAsString)).setter(CmafGroupSettings.setter(Builder::manifestDurationFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifestDurationFormat").build()}).build();
    private static final SdkField<Integer> MIN_BUFFER_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CmafGroupSettings.getter(CmafGroupSettings::minBufferTime)).setter(CmafGroupSettings.setter(Builder::minBufferTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minBufferTime").build()}).build();
    private static final SdkField<Double> MIN_FINAL_SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(CmafGroupSettings.getter(CmafGroupSettings::minFinalSegmentLength)).setter(CmafGroupSettings.setter(Builder::minFinalSegmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minFinalSegmentLength").build()}).build();
    private static final SdkField<String> SEGMENT_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CmafGroupSettings.getter(CmafGroupSettings::segmentControlAsString)).setter(CmafGroupSettings.setter(Builder::segmentControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentControl").build()}).build();
    private static final SdkField<Integer> SEGMENT_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CmafGroupSettings.getter(CmafGroupSettings::segmentLength)).setter(CmafGroupSettings.setter(Builder::segmentLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentLength").build()}).build();
    private static final SdkField<String> STREAM_INF_RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CmafGroupSettings.getter(CmafGroupSettings::streamInfResolutionAsString)).setter(CmafGroupSettings.setter(Builder::streamInfResolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streamInfResolution").build()}).build();
    private static final SdkField<String> WRITE_DASH_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CmafGroupSettings.getter(CmafGroupSettings::writeDashManifestAsString)).setter(CmafGroupSettings.setter(Builder::writeDashManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeDashManifest").build()}).build();
    private static final SdkField<String> WRITE_HLS_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CmafGroupSettings.getter(CmafGroupSettings::writeHlsManifestAsString)).setter(CmafGroupSettings.setter(Builder::writeHlsManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("writeHlsManifest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_URL_FIELD, CLIENT_CACHE_FIELD, CODEC_SPECIFICATION_FIELD, DESTINATION_FIELD, DESTINATION_SETTINGS_FIELD, ENCRYPTION_FIELD, FRAGMENT_LENGTH_FIELD, MANIFEST_COMPRESSION_FIELD, MANIFEST_DURATION_FORMAT_FIELD, MIN_BUFFER_TIME_FIELD, MIN_FINAL_SEGMENT_LENGTH_FIELD, SEGMENT_CONTROL_FIELD, SEGMENT_LENGTH_FIELD, STREAM_INF_RESOLUTION_FIELD, WRITE_DASH_MANIFEST_FIELD, WRITE_HLS_MANIFEST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String baseUrl;
    private final String clientCache;
    private final String codecSpecification;
    private final String destination;
    private final DestinationSettings destinationSettings;
    private final CmafEncryptionSettings encryption;
    private final Integer fragmentLength;
    private final String manifestCompression;
    private final String manifestDurationFormat;
    private final Integer minBufferTime;
    private final Double minFinalSegmentLength;
    private final String segmentControl;
    private final Integer segmentLength;
    private final String streamInfResolution;
    private final String writeDashManifest;
    private final String writeHlsManifest;

    private CmafGroupSettings(BuilderImpl builder) {
        this.baseUrl = builder.baseUrl;
        this.clientCache = builder.clientCache;
        this.codecSpecification = builder.codecSpecification;
        this.destination = builder.destination;
        this.destinationSettings = builder.destinationSettings;
        this.encryption = builder.encryption;
        this.fragmentLength = builder.fragmentLength;
        this.manifestCompression = builder.manifestCompression;
        this.manifestDurationFormat = builder.manifestDurationFormat;
        this.minBufferTime = builder.minBufferTime;
        this.minFinalSegmentLength = builder.minFinalSegmentLength;
        this.segmentControl = builder.segmentControl;
        this.segmentLength = builder.segmentLength;
        this.streamInfResolution = builder.streamInfResolution;
        this.writeDashManifest = builder.writeDashManifest;
        this.writeHlsManifest = builder.writeHlsManifest;
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public CmafClientCache clientCache() {
        return CmafClientCache.fromValue(this.clientCache);
    }

    public String clientCacheAsString() {
        return this.clientCache;
    }

    public CmafCodecSpecification codecSpecification() {
        return CmafCodecSpecification.fromValue(this.codecSpecification);
    }

    public String codecSpecificationAsString() {
        return this.codecSpecification;
    }

    public String destination() {
        return this.destination;
    }

    public DestinationSettings destinationSettings() {
        return this.destinationSettings;
    }

    public CmafEncryptionSettings encryption() {
        return this.encryption;
    }

    public Integer fragmentLength() {
        return this.fragmentLength;
    }

    public CmafManifestCompression manifestCompression() {
        return CmafManifestCompression.fromValue(this.manifestCompression);
    }

    public String manifestCompressionAsString() {
        return this.manifestCompression;
    }

    public CmafManifestDurationFormat manifestDurationFormat() {
        return CmafManifestDurationFormat.fromValue(this.manifestDurationFormat);
    }

    public String manifestDurationFormatAsString() {
        return this.manifestDurationFormat;
    }

    public Integer minBufferTime() {
        return this.minBufferTime;
    }

    public Double minFinalSegmentLength() {
        return this.minFinalSegmentLength;
    }

    public CmafSegmentControl segmentControl() {
        return CmafSegmentControl.fromValue(this.segmentControl);
    }

    public String segmentControlAsString() {
        return this.segmentControl;
    }

    public Integer segmentLength() {
        return this.segmentLength;
    }

    public CmafStreamInfResolution streamInfResolution() {
        return CmafStreamInfResolution.fromValue(this.streamInfResolution);
    }

    public String streamInfResolutionAsString() {
        return this.streamInfResolution;
    }

    public CmafWriteDASHManifest writeDashManifest() {
        return CmafWriteDASHManifest.fromValue(this.writeDashManifest);
    }

    public String writeDashManifestAsString() {
        return this.writeDashManifest;
    }

    public CmafWriteHLSManifest writeHlsManifest() {
        return CmafWriteHLSManifest.fromValue(this.writeHlsManifest);
    }

    public String writeHlsManifestAsString() {
        return this.writeHlsManifest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.baseUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientCacheAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecSpecificationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.destination());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.fragmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestCompressionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.manifestDurationFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.minBufferTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.minFinalSegmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.segmentLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamInfResolutionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeDashManifestAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.writeHlsManifestAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CmafGroupSettings)) {
            return false;
        }
        CmafGroupSettings other = (CmafGroupSettings)obj;
        return Objects.equals(this.baseUrl(), other.baseUrl()) && Objects.equals(this.clientCacheAsString(), other.clientCacheAsString()) && Objects.equals(this.codecSpecificationAsString(), other.codecSpecificationAsString()) && Objects.equals(this.destination(), other.destination()) && Objects.equals(this.destinationSettings(), other.destinationSettings()) && Objects.equals(this.encryption(), other.encryption()) && Objects.equals(this.fragmentLength(), other.fragmentLength()) && Objects.equals(this.manifestCompressionAsString(), other.manifestCompressionAsString()) && Objects.equals(this.manifestDurationFormatAsString(), other.manifestDurationFormatAsString()) && Objects.equals(this.minBufferTime(), other.minBufferTime()) && Objects.equals(this.minFinalSegmentLength(), other.minFinalSegmentLength()) && Objects.equals(this.segmentControlAsString(), other.segmentControlAsString()) && Objects.equals(this.segmentLength(), other.segmentLength()) && Objects.equals(this.streamInfResolutionAsString(), other.streamInfResolutionAsString()) && Objects.equals(this.writeDashManifestAsString(), other.writeDashManifestAsString()) && Objects.equals(this.writeHlsManifestAsString(), other.writeHlsManifestAsString());
    }

    public String toString() {
        return ToString.builder((String)"CmafGroupSettings").add("BaseUrl", (Object)this.baseUrl()).add("ClientCache", (Object)this.clientCacheAsString()).add("CodecSpecification", (Object)this.codecSpecificationAsString()).add("Destination", (Object)this.destination()).add("DestinationSettings", (Object)this.destinationSettings()).add("Encryption", (Object)this.encryption()).add("FragmentLength", (Object)this.fragmentLength()).add("ManifestCompression", (Object)this.manifestCompressionAsString()).add("ManifestDurationFormat", (Object)this.manifestDurationFormatAsString()).add("MinBufferTime", (Object)this.minBufferTime()).add("MinFinalSegmentLength", (Object)this.minFinalSegmentLength()).add("SegmentControl", (Object)this.segmentControlAsString()).add("SegmentLength", (Object)this.segmentLength()).add("StreamInfResolution", (Object)this.streamInfResolutionAsString()).add("WriteDashManifest", (Object)this.writeDashManifestAsString()).add("WriteHlsManifest", (Object)this.writeHlsManifestAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BaseUrl": {
                return Optional.ofNullable(clazz.cast(this.baseUrl()));
            }
            case "ClientCache": {
                return Optional.ofNullable(clazz.cast(this.clientCacheAsString()));
            }
            case "CodecSpecification": {
                return Optional.ofNullable(clazz.cast(this.codecSpecificationAsString()));
            }
            case "Destination": {
                return Optional.ofNullable(clazz.cast(this.destination()));
            }
            case "DestinationSettings": {
                return Optional.ofNullable(clazz.cast(this.destinationSettings()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
            case "FragmentLength": {
                return Optional.ofNullable(clazz.cast(this.fragmentLength()));
            }
            case "ManifestCompression": {
                return Optional.ofNullable(clazz.cast(this.manifestCompressionAsString()));
            }
            case "ManifestDurationFormat": {
                return Optional.ofNullable(clazz.cast(this.manifestDurationFormatAsString()));
            }
            case "MinBufferTime": {
                return Optional.ofNullable(clazz.cast(this.minBufferTime()));
            }
            case "MinFinalSegmentLength": {
                return Optional.ofNullable(clazz.cast(this.minFinalSegmentLength()));
            }
            case "SegmentControl": {
                return Optional.ofNullable(clazz.cast(this.segmentControlAsString()));
            }
            case "SegmentLength": {
                return Optional.ofNullable(clazz.cast(this.segmentLength()));
            }
            case "StreamInfResolution": {
                return Optional.ofNullable(clazz.cast(this.streamInfResolutionAsString()));
            }
            case "WriteDashManifest": {
                return Optional.ofNullable(clazz.cast(this.writeDashManifestAsString()));
            }
            case "WriteHlsManifest": {
                return Optional.ofNullable(clazz.cast(this.writeHlsManifestAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CmafGroupSettings, T> g) {
        return obj -> g.apply((CmafGroupSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String baseUrl;
        private String clientCache;
        private String codecSpecification;
        private String destination;
        private DestinationSettings destinationSettings;
        private CmafEncryptionSettings encryption;
        private Integer fragmentLength;
        private String manifestCompression;
        private String manifestDurationFormat;
        private Integer minBufferTime;
        private Double minFinalSegmentLength;
        private String segmentControl;
        private Integer segmentLength;
        private String streamInfResolution;
        private String writeDashManifest;
        private String writeHlsManifest;

        private BuilderImpl() {
        }

        private BuilderImpl(CmafGroupSettings model) {
            this.baseUrl(model.baseUrl);
            this.clientCache(model.clientCache);
            this.codecSpecification(model.codecSpecification);
            this.destination(model.destination);
            this.destinationSettings(model.destinationSettings);
            this.encryption(model.encryption);
            this.fragmentLength(model.fragmentLength);
            this.manifestCompression(model.manifestCompression);
            this.manifestDurationFormat(model.manifestDurationFormat);
            this.minBufferTime(model.minBufferTime);
            this.minFinalSegmentLength(model.minFinalSegmentLength);
            this.segmentControl(model.segmentControl);
            this.segmentLength(model.segmentLength);
            this.streamInfResolution(model.streamInfResolution);
            this.writeDashManifest(model.writeDashManifest);
            this.writeHlsManifest(model.writeHlsManifest);
        }

        public final String getBaseUrl() {
            return this.baseUrl;
        }

        @Override
        public final Builder baseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public final void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        public final String getClientCacheAsString() {
            return this.clientCache;
        }

        @Override
        public final Builder clientCache(String clientCache) {
            this.clientCache = clientCache;
            return this;
        }

        @Override
        public final Builder clientCache(CmafClientCache clientCache) {
            this.clientCache(clientCache.toString());
            return this;
        }

        public final void setClientCache(String clientCache) {
            this.clientCache = clientCache;
        }

        public final String getCodecSpecificationAsString() {
            return this.codecSpecification;
        }

        @Override
        public final Builder codecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
            return this;
        }

        @Override
        public final Builder codecSpecification(CmafCodecSpecification codecSpecification) {
            this.codecSpecification(codecSpecification.toString());
            return this;
        }

        public final void setCodecSpecification(String codecSpecification) {
            this.codecSpecification = codecSpecification;
        }

        public final String getDestination() {
            return this.destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        public final DestinationSettings.Builder getDestinationSettings() {
            return this.destinationSettings != null ? this.destinationSettings.toBuilder() : null;
        }

        @Override
        public final Builder destinationSettings(DestinationSettings destinationSettings) {
            this.destinationSettings = destinationSettings;
            return this;
        }

        public final void setDestinationSettings(DestinationSettings.BuilderImpl destinationSettings) {
            this.destinationSettings = destinationSettings != null ? destinationSettings.build() : null;
        }

        public final CmafEncryptionSettings.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        @Override
        public final Builder encryption(CmafEncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public final void setEncryption(CmafEncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        public final Integer getFragmentLength() {
            return this.fragmentLength;
        }

        @Override
        public final Builder fragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
            return this;
        }

        public final void setFragmentLength(Integer fragmentLength) {
            this.fragmentLength = fragmentLength;
        }

        public final String getManifestCompressionAsString() {
            return this.manifestCompression;
        }

        @Override
        public final Builder manifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
            return this;
        }

        @Override
        public final Builder manifestCompression(CmafManifestCompression manifestCompression) {
            this.manifestCompression(manifestCompression.toString());
            return this;
        }

        public final void setManifestCompression(String manifestCompression) {
            this.manifestCompression = manifestCompression;
        }

        public final String getManifestDurationFormatAsString() {
            return this.manifestDurationFormat;
        }

        @Override
        public final Builder manifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
            return this;
        }

        @Override
        public final Builder manifestDurationFormat(CmafManifestDurationFormat manifestDurationFormat) {
            this.manifestDurationFormat(manifestDurationFormat.toString());
            return this;
        }

        public final void setManifestDurationFormat(String manifestDurationFormat) {
            this.manifestDurationFormat = manifestDurationFormat;
        }

        public final Integer getMinBufferTime() {
            return this.minBufferTime;
        }

        @Override
        public final Builder minBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
            return this;
        }

        public final void setMinBufferTime(Integer minBufferTime) {
            this.minBufferTime = minBufferTime;
        }

        public final Double getMinFinalSegmentLength() {
            return this.minFinalSegmentLength;
        }

        @Override
        public final Builder minFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
            return this;
        }

        public final void setMinFinalSegmentLength(Double minFinalSegmentLength) {
            this.minFinalSegmentLength = minFinalSegmentLength;
        }

        public final String getSegmentControlAsString() {
            return this.segmentControl;
        }

        @Override
        public final Builder segmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
            return this;
        }

        @Override
        public final Builder segmentControl(CmafSegmentControl segmentControl) {
            this.segmentControl(segmentControl.toString());
            return this;
        }

        public final void setSegmentControl(String segmentControl) {
            this.segmentControl = segmentControl;
        }

        public final Integer getSegmentLength() {
            return this.segmentLength;
        }

        @Override
        public final Builder segmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
            return this;
        }

        public final void setSegmentLength(Integer segmentLength) {
            this.segmentLength = segmentLength;
        }

        public final String getStreamInfResolutionAsString() {
            return this.streamInfResolution;
        }

        @Override
        public final Builder streamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
            return this;
        }

        @Override
        public final Builder streamInfResolution(CmafStreamInfResolution streamInfResolution) {
            this.streamInfResolution(streamInfResolution.toString());
            return this;
        }

        public final void setStreamInfResolution(String streamInfResolution) {
            this.streamInfResolution = streamInfResolution;
        }

        public final String getWriteDashManifestAsString() {
            return this.writeDashManifest;
        }

        @Override
        public final Builder writeDashManifest(String writeDashManifest) {
            this.writeDashManifest = writeDashManifest;
            return this;
        }

        @Override
        public final Builder writeDashManifest(CmafWriteDASHManifest writeDashManifest) {
            this.writeDashManifest(writeDashManifest.toString());
            return this;
        }

        public final void setWriteDashManifest(String writeDashManifest) {
            this.writeDashManifest = writeDashManifest;
        }

        public final String getWriteHlsManifestAsString() {
            return this.writeHlsManifest;
        }

        @Override
        public final Builder writeHlsManifest(String writeHlsManifest) {
            this.writeHlsManifest = writeHlsManifest;
            return this;
        }

        @Override
        public final Builder writeHlsManifest(CmafWriteHLSManifest writeHlsManifest) {
            this.writeHlsManifest(writeHlsManifest.toString());
            return this;
        }

        public final void setWriteHlsManifest(String writeHlsManifest) {
            this.writeHlsManifest = writeHlsManifest;
        }

        public CmafGroupSettings build() {
            return new CmafGroupSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CmafGroupSettings> {
        public Builder baseUrl(String var1);

        public Builder clientCache(String var1);

        public Builder clientCache(CmafClientCache var1);

        public Builder codecSpecification(String var1);

        public Builder codecSpecification(CmafCodecSpecification var1);

        public Builder destination(String var1);

        public Builder destinationSettings(DestinationSettings var1);

        default public Builder destinationSettings(Consumer<DestinationSettings.Builder> destinationSettings) {
            return this.destinationSettings((DestinationSettings)((DestinationSettings.Builder)DestinationSettings.builder().applyMutation(destinationSettings)).build());
        }

        public Builder encryption(CmafEncryptionSettings var1);

        default public Builder encryption(Consumer<CmafEncryptionSettings.Builder> encryption) {
            return this.encryption((CmafEncryptionSettings)((CmafEncryptionSettings.Builder)CmafEncryptionSettings.builder().applyMutation(encryption)).build());
        }

        public Builder fragmentLength(Integer var1);

        public Builder manifestCompression(String var1);

        public Builder manifestCompression(CmafManifestCompression var1);

        public Builder manifestDurationFormat(String var1);

        public Builder manifestDurationFormat(CmafManifestDurationFormat var1);

        public Builder minBufferTime(Integer var1);

        public Builder minFinalSegmentLength(Double var1);

        public Builder segmentControl(String var1);

        public Builder segmentControl(CmafSegmentControl var1);

        public Builder segmentLength(Integer var1);

        public Builder streamInfResolution(String var1);

        public Builder streamInfResolution(CmafStreamInfResolution var1);

        public Builder writeDashManifest(String var1);

        public Builder writeDashManifest(CmafWriteDASHManifest var1);

        public Builder writeHlsManifest(String var1);

        public Builder writeHlsManifest(CmafWriteHLSManifest var1);
    }
}

