/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.AccelerationSettings;
import software.amazon.awssdk.services.mediaconvert.model.JobTemplateSettings;
import software.amazon.awssdk.services.mediaconvert.model.StatusUpdateInterval;
import software.amazon.awssdk.services.mediaconvert.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobTemplate> {
    private static final SdkField<AccelerationSettings> ACCELERATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobTemplate.getter(JobTemplate::accelerationSettings)).setter(JobTemplate.setter(Builder::accelerationSettings)).constructor(AccelerationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerationSettings").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobTemplate.getter(JobTemplate::arn)).setter(JobTemplate.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobTemplate.getter(JobTemplate::category)).setter(JobTemplate.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(JobTemplate.getter(JobTemplate::createdAt)).setter(JobTemplate.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobTemplate.getter(JobTemplate::description)).setter(JobTemplate.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(JobTemplate.getter(JobTemplate::lastUpdated)).setter(JobTemplate.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobTemplate.getter(JobTemplate::name)).setter(JobTemplate.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(JobTemplate.getter(JobTemplate::priority)).setter(JobTemplate.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<String> QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobTemplate.getter(JobTemplate::queue)).setter(JobTemplate.setter(Builder::queue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queue").build()}).build();
    private static final SdkField<JobTemplateSettings> SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(JobTemplate.getter(JobTemplate::settings)).setter(JobTemplate.setter(Builder::settings)).constructor(JobTemplateSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("settings").build()}).build();
    private static final SdkField<String> STATUS_UPDATE_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobTemplate.getter(JobTemplate::statusUpdateIntervalAsString)).setter(JobTemplate.setter(Builder::statusUpdateInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusUpdateInterval").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(JobTemplate.getter(JobTemplate::typeAsString)).setter(JobTemplate.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCELERATION_SETTINGS_FIELD, ARN_FIELD, CATEGORY_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, LAST_UPDATED_FIELD, NAME_FIELD, PRIORITY_FIELD, QUEUE_FIELD, SETTINGS_FIELD, STATUS_UPDATE_INTERVAL_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final AccelerationSettings accelerationSettings;
    private final String arn;
    private final String category;
    private final Instant createdAt;
    private final String description;
    private final Instant lastUpdated;
    private final String name;
    private final Integer priority;
    private final String queue;
    private final JobTemplateSettings settings;
    private final String statusUpdateInterval;
    private final String type;

    private JobTemplate(BuilderImpl builder) {
        this.accelerationSettings = builder.accelerationSettings;
        this.arn = builder.arn;
        this.category = builder.category;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.lastUpdated = builder.lastUpdated;
        this.name = builder.name;
        this.priority = builder.priority;
        this.queue = builder.queue;
        this.settings = builder.settings;
        this.statusUpdateInterval = builder.statusUpdateInterval;
        this.type = builder.type;
    }

    public AccelerationSettings accelerationSettings() {
        return this.accelerationSettings;
    }

    public String arn() {
        return this.arn;
    }

    public String category() {
        return this.category;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String description() {
        return this.description;
    }

    public Instant lastUpdated() {
        return this.lastUpdated;
    }

    public String name() {
        return this.name;
    }

    public Integer priority() {
        return this.priority;
    }

    public String queue() {
        return this.queue;
    }

    public JobTemplateSettings settings() {
        return this.settings;
    }

    public StatusUpdateInterval statusUpdateInterval() {
        return StatusUpdateInterval.fromValue(this.statusUpdateInterval);
    }

    public String statusUpdateIntervalAsString() {
        return this.statusUpdateInterval;
    }

    public Type type() {
        return Type.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accelerationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.queue());
        hashCode = 31 * hashCode + Objects.hashCode(this.settings());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusUpdateIntervalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobTemplate)) {
            return false;
        }
        JobTemplate other = (JobTemplate)obj;
        return Objects.equals(this.accelerationSettings(), other.accelerationSettings()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.queue(), other.queue()) && Objects.equals(this.settings(), other.settings()) && Objects.equals(this.statusUpdateIntervalAsString(), other.statusUpdateIntervalAsString()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"JobTemplate").add("AccelerationSettings", (Object)this.accelerationSettings()).add("Arn", (Object)this.arn()).add("Category", (Object)this.category()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("LastUpdated", (Object)this.lastUpdated()).add("Name", (Object)this.name()).add("Priority", (Object)this.priority()).add("Queue", (Object)this.queue()).add("Settings", (Object)this.settings()).add("StatusUpdateInterval", (Object)this.statusUpdateIntervalAsString()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccelerationSettings": {
                return Optional.ofNullable(clazz.cast(this.accelerationSettings()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Queue": {
                return Optional.ofNullable(clazz.cast(this.queue()));
            }
            case "Settings": {
                return Optional.ofNullable(clazz.cast(this.settings()));
            }
            case "StatusUpdateInterval": {
                return Optional.ofNullable(clazz.cast(this.statusUpdateIntervalAsString()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobTemplate, T> g) {
        return obj -> g.apply((JobTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AccelerationSettings accelerationSettings;
        private String arn;
        private String category;
        private Instant createdAt;
        private String description;
        private Instant lastUpdated;
        private String name;
        private Integer priority;
        private String queue;
        private JobTemplateSettings settings;
        private String statusUpdateInterval;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(JobTemplate model) {
            this.accelerationSettings(model.accelerationSettings);
            this.arn(model.arn);
            this.category(model.category);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.lastUpdated(model.lastUpdated);
            this.name(model.name);
            this.priority(model.priority);
            this.queue(model.queue);
            this.settings(model.settings);
            this.statusUpdateInterval(model.statusUpdateInterval);
            this.type(model.type);
        }

        public final AccelerationSettings.Builder getAccelerationSettings() {
            return this.accelerationSettings != null ? this.accelerationSettings.toBuilder() : null;
        }

        @Override
        public final Builder accelerationSettings(AccelerationSettings accelerationSettings) {
            this.accelerationSettings = accelerationSettings;
            return this;
        }

        public final void setAccelerationSettings(AccelerationSettings.BuilderImpl accelerationSettings) {
            this.accelerationSettings = accelerationSettings != null ? accelerationSettings.build() : null;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getCategory() {
            return this.category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getQueue() {
            return this.queue;
        }

        @Override
        public final Builder queue(String queue) {
            this.queue = queue;
            return this;
        }

        public final void setQueue(String queue) {
            this.queue = queue;
        }

        public final JobTemplateSettings.Builder getSettings() {
            return this.settings != null ? this.settings.toBuilder() : null;
        }

        @Override
        public final Builder settings(JobTemplateSettings settings) {
            this.settings = settings;
            return this;
        }

        public final void setSettings(JobTemplateSettings.BuilderImpl settings) {
            this.settings = settings != null ? settings.build() : null;
        }

        public final String getStatusUpdateIntervalAsString() {
            return this.statusUpdateInterval;
        }

        @Override
        public final Builder statusUpdateInterval(String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
            return this;
        }

        @Override
        public final Builder statusUpdateInterval(StatusUpdateInterval statusUpdateInterval) {
            this.statusUpdateInterval(statusUpdateInterval == null ? null : statusUpdateInterval.toString());
            return this;
        }

        public final void setStatusUpdateInterval(String statusUpdateInterval) {
            this.statusUpdateInterval = statusUpdateInterval;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public JobTemplate build() {
            return new JobTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobTemplate> {
        public Builder accelerationSettings(AccelerationSettings var1);

        default public Builder accelerationSettings(Consumer<AccelerationSettings.Builder> accelerationSettings) {
            return this.accelerationSettings((AccelerationSettings)((AccelerationSettings.Builder)AccelerationSettings.builder().applyMutation(accelerationSettings)).build());
        }

        public Builder arn(String var1);

        public Builder category(String var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder lastUpdated(Instant var1);

        public Builder name(String var1);

        public Builder priority(Integer var1);

        public Builder queue(String var1);

        public Builder settings(JobTemplateSettings var1);

        default public Builder settings(Consumer<JobTemplateSettings.Builder> settings) {
            return this.settings((JobTemplateSettings)((JobTemplateSettings.Builder)JobTemplateSettings.builder().applyMutation(settings)).build());
        }

        public Builder statusUpdateInterval(String var1);

        public Builder statusUpdateInterval(StatusUpdateInterval var1);

        public Builder type(String var1);

        public Builder type(Type var1);
    }
}

