/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H265TreeBlockSize {
    AUTO("AUTO"),
    TREE_SIZE_32_X32("TREE_SIZE_32X32"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H265TreeBlockSize> VALUE_MAP;
    private final String value;

    private H265TreeBlockSize(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H265TreeBlockSize fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H265TreeBlockSize> knownValues() {
        EnumSet<H265TreeBlockSize> knownValues = EnumSet.allOf(H265TreeBlockSize.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H265TreeBlockSize.class, H265TreeBlockSize::toString);
    }
}

