/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mediaconvert.MediaConvertClient;
import software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsRequest;
import software.amazon.awssdk.services.mediaconvert.model.DescribeEndpointsResponse;
import software.amazon.awssdk.services.mediaconvert.model.Endpoint;

public class DescribeEndpointsIterable
implements SdkIterable<DescribeEndpointsResponse> {
    private final MediaConvertClient client;
    private final DescribeEndpointsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEndpointsIterable(MediaConvertClient client, DescribeEndpointsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEndpointsResponseFetcher();
    }

    public Iterator<DescribeEndpointsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Endpoint> endpoints() {
        Function<DescribeEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.endpoints() != null) {
                return response.endpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeEndpointsIterable resume(DescribeEndpointsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEndpointsIterable(this.client, (DescribeEndpointsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeEndpointsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeEndpointsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeEndpointsResponseFetcher
    implements SyncPageFetcher<DescribeEndpointsResponse> {
        private DescribeEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeEndpointsResponse nextPage(DescribeEndpointsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEndpointsIterable.this.client.describeEndpoints(DescribeEndpointsIterable.this.firstRequest);
            }
            return DescribeEndpointsIterable.this.client.describeEndpoints((DescribeEndpointsRequest)((Object)DescribeEndpointsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

