/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mediaconvert.model.PricingPlan;
import software.amazon.awssdk.services.mediaconvert.model.QueueStatus;
import software.amazon.awssdk.services.mediaconvert.model.ReservationPlan;
import software.amazon.awssdk.services.mediaconvert.model.ServiceOverride;
import software.amazon.awssdk.services.mediaconvert.model.Type;
import software.amazon.awssdk.services.mediaconvert.model.___listOfServiceOverrideCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Queue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Queue> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(Queue.getter(Queue::arn)).setter(Queue.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Integer> CONCURRENT_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ConcurrentJobs").getter(Queue.getter(Queue::concurrentJobs)).setter(Queue.setter(Builder::concurrentJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("concurrentJobs").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(Queue.getter(Queue::createdAt)).setter(Queue.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Queue.getter(Queue::description)).setter(Queue.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdated").getter(Queue.getter(Queue::lastUpdated)).setter(Queue.setter(Builder::lastUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdated").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.UNIX_TIMESTAMP)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Queue.getter(Queue::name)).setter(Queue.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PRICING_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PricingPlan").getter(Queue.getter(Queue::pricingPlanAsString)).setter(Queue.setter(Builder::pricingPlan)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pricingPlan").build()}).build();
    private static final SdkField<Integer> PROGRESSING_JOBS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgressingJobsCount").getter(Queue.getter(Queue::progressingJobsCount)).setter(Queue.setter(Builder::progressingJobsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressingJobsCount").build()}).build();
    private static final SdkField<ReservationPlan> RESERVATION_PLAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReservationPlan").getter(Queue.getter(Queue::reservationPlan)).setter(Queue.setter(Builder::reservationPlan)).constructor(ReservationPlan::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservationPlan").build()}).build();
    private static final SdkField<List<ServiceOverride>> SERVICE_OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceOverrides").getter(Queue.getter(Queue::serviceOverrides)).setter(Queue.setter(Builder::serviceOverrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceOverrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Queue.getter(Queue::statusAsString)).setter(Queue.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Integer> SUBMITTED_JOBS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SubmittedJobsCount").getter(Queue.getter(Queue::submittedJobsCount)).setter(Queue.setter(Builder::submittedJobsCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("submittedJobsCount").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(Queue.getter(Queue::typeAsString)).setter(Queue.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CONCURRENT_JOBS_FIELD, CREATED_AT_FIELD, DESCRIPTION_FIELD, LAST_UPDATED_FIELD, NAME_FIELD, PRICING_PLAN_FIELD, PROGRESSING_JOBS_COUNT_FIELD, RESERVATION_PLAN_FIELD, SERVICE_OVERRIDES_FIELD, STATUS_FIELD, SUBMITTED_JOBS_COUNT_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Queue.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Integer concurrentJobs;
    private final Instant createdAt;
    private final String description;
    private final Instant lastUpdated;
    private final String name;
    private final String pricingPlan;
    private final Integer progressingJobsCount;
    private final ReservationPlan reservationPlan;
    private final List<ServiceOverride> serviceOverrides;
    private final String status;
    private final Integer submittedJobsCount;
    private final String type;

    private Queue(BuilderImpl builder) {
        this.arn = builder.arn;
        this.concurrentJobs = builder.concurrentJobs;
        this.createdAt = builder.createdAt;
        this.description = builder.description;
        this.lastUpdated = builder.lastUpdated;
        this.name = builder.name;
        this.pricingPlan = builder.pricingPlan;
        this.progressingJobsCount = builder.progressingJobsCount;
        this.reservationPlan = builder.reservationPlan;
        this.serviceOverrides = builder.serviceOverrides;
        this.status = builder.status;
        this.submittedJobsCount = builder.submittedJobsCount;
        this.type = builder.type;
    }

    public final String arn() {
        return this.arn;
    }

    public final Integer concurrentJobs() {
        return this.concurrentJobs;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String description() {
        return this.description;
    }

    public final Instant lastUpdated() {
        return this.lastUpdated;
    }

    public final String name() {
        return this.name;
    }

    public final PricingPlan pricingPlan() {
        return PricingPlan.fromValue(this.pricingPlan);
    }

    public final String pricingPlanAsString() {
        return this.pricingPlan;
    }

    public final Integer progressingJobsCount() {
        return this.progressingJobsCount;
    }

    public final ReservationPlan reservationPlan() {
        return this.reservationPlan;
    }

    public final boolean hasServiceOverrides() {
        return this.serviceOverrides != null && !(this.serviceOverrides instanceof SdkAutoConstructList);
    }

    public final List<ServiceOverride> serviceOverrides() {
        return this.serviceOverrides;
    }

    public final QueueStatus status() {
        return QueueStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Integer submittedJobsCount() {
        return this.submittedJobsCount;
    }

    public final Type type() {
        return Type.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.concurrentJobs());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.pricingPlanAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressingJobsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationPlan());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceOverrides() ? this.serviceOverrides() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.submittedJobsCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Queue)) {
            return false;
        }
        Queue other = (Queue)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.concurrentJobs(), other.concurrentJobs()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.lastUpdated(), other.lastUpdated()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.pricingPlanAsString(), other.pricingPlanAsString()) && Objects.equals(this.progressingJobsCount(), other.progressingJobsCount()) && Objects.equals(this.reservationPlan(), other.reservationPlan()) && this.hasServiceOverrides() == other.hasServiceOverrides() && Objects.equals(this.serviceOverrides(), other.serviceOverrides()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.submittedJobsCount(), other.submittedJobsCount()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Queue").add("Arn", (Object)this.arn()).add("ConcurrentJobs", (Object)this.concurrentJobs()).add("CreatedAt", (Object)this.createdAt()).add("Description", (Object)this.description()).add("LastUpdated", (Object)this.lastUpdated()).add("Name", (Object)this.name()).add("PricingPlan", (Object)this.pricingPlanAsString()).add("ProgressingJobsCount", (Object)this.progressingJobsCount()).add("ReservationPlan", (Object)this.reservationPlan()).add("ServiceOverrides", this.hasServiceOverrides() ? this.serviceOverrides() : null).add("Status", (Object)this.statusAsString()).add("SubmittedJobsCount", (Object)this.submittedJobsCount()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "ConcurrentJobs": {
                return Optional.ofNullable(clazz.cast(this.concurrentJobs()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "LastUpdated": {
                return Optional.ofNullable(clazz.cast(this.lastUpdated()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "PricingPlan": {
                return Optional.ofNullable(clazz.cast(this.pricingPlanAsString()));
            }
            case "ProgressingJobsCount": {
                return Optional.ofNullable(clazz.cast(this.progressingJobsCount()));
            }
            case "ReservationPlan": {
                return Optional.ofNullable(clazz.cast(this.reservationPlan()));
            }
            case "ServiceOverrides": {
                return Optional.ofNullable(clazz.cast(this.serviceOverrides()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "SubmittedJobsCount": {
                return Optional.ofNullable(clazz.cast(this.submittedJobsCount()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("concurrentJobs", CONCURRENT_JOBS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("lastUpdated", LAST_UPDATED_FIELD);
        map.put("name", NAME_FIELD);
        map.put("pricingPlan", PRICING_PLAN_FIELD);
        map.put("progressingJobsCount", PROGRESSING_JOBS_COUNT_FIELD);
        map.put("reservationPlan", RESERVATION_PLAN_FIELD);
        map.put("serviceOverrides", SERVICE_OVERRIDES_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("submittedJobsCount", SUBMITTED_JOBS_COUNT_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Queue, T> g) {
        return obj -> g.apply((Queue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Integer concurrentJobs;
        private Instant createdAt;
        private String description;
        private Instant lastUpdated;
        private String name;
        private String pricingPlan;
        private Integer progressingJobsCount;
        private ReservationPlan reservationPlan;
        private List<ServiceOverride> serviceOverrides = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Integer submittedJobsCount;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(Queue model) {
            this.arn(model.arn);
            this.concurrentJobs(model.concurrentJobs);
            this.createdAt(model.createdAt);
            this.description(model.description);
            this.lastUpdated(model.lastUpdated);
            this.name(model.name);
            this.pricingPlan(model.pricingPlan);
            this.progressingJobsCount(model.progressingJobsCount);
            this.reservationPlan(model.reservationPlan);
            this.serviceOverrides(model.serviceOverrides);
            this.status(model.status);
            this.submittedJobsCount(model.submittedJobsCount);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getConcurrentJobs() {
            return this.concurrentJobs;
        }

        public final void setConcurrentJobs(Integer concurrentJobs) {
            this.concurrentJobs = concurrentJobs;
        }

        @Override
        public final Builder concurrentJobs(Integer concurrentJobs) {
            this.concurrentJobs = concurrentJobs;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getLastUpdated() {
            return this.lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPricingPlan() {
            return this.pricingPlan;
        }

        public final void setPricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
        }

        @Override
        public final Builder pricingPlan(String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        @Override
        public final Builder pricingPlan(PricingPlan pricingPlan) {
            this.pricingPlan(pricingPlan == null ? null : pricingPlan.toString());
            return this;
        }

        public final Integer getProgressingJobsCount() {
            return this.progressingJobsCount;
        }

        public final void setProgressingJobsCount(Integer progressingJobsCount) {
            this.progressingJobsCount = progressingJobsCount;
        }

        @Override
        public final Builder progressingJobsCount(Integer progressingJobsCount) {
            this.progressingJobsCount = progressingJobsCount;
            return this;
        }

        public final ReservationPlan.Builder getReservationPlan() {
            return this.reservationPlan != null ? this.reservationPlan.toBuilder() : null;
        }

        public final void setReservationPlan(ReservationPlan.BuilderImpl reservationPlan) {
            this.reservationPlan = reservationPlan != null ? reservationPlan.build() : null;
        }

        @Override
        public final Builder reservationPlan(ReservationPlan reservationPlan) {
            this.reservationPlan = reservationPlan;
            return this;
        }

        public final List<ServiceOverride.Builder> getServiceOverrides() {
            List<ServiceOverride.Builder> result = ___listOfServiceOverrideCopier.copyToBuilder(this.serviceOverrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceOverrides(Collection<ServiceOverride.BuilderImpl> serviceOverrides) {
            this.serviceOverrides = ___listOfServiceOverrideCopier.copyFromBuilder(serviceOverrides);
        }

        @Override
        public final Builder serviceOverrides(Collection<ServiceOverride> serviceOverrides) {
            this.serviceOverrides = ___listOfServiceOverrideCopier.copy(serviceOverrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceOverrides(ServiceOverride ... serviceOverrides) {
            this.serviceOverrides(Arrays.asList(serviceOverrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceOverrides(Consumer<ServiceOverride.Builder> ... serviceOverrides) {
            this.serviceOverrides(Stream.of(serviceOverrides).map(c -> (ServiceOverride)((ServiceOverride.Builder)ServiceOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getSubmittedJobsCount() {
            return this.submittedJobsCount;
        }

        public final void setSubmittedJobsCount(Integer submittedJobsCount) {
            this.submittedJobsCount = submittedJobsCount;
        }

        @Override
        public final Builder submittedJobsCount(Integer submittedJobsCount) {
            this.submittedJobsCount = submittedJobsCount;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public Queue build() {
            return new Queue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Queue> {
        public Builder arn(String var1);

        public Builder concurrentJobs(Integer var1);

        public Builder createdAt(Instant var1);

        public Builder description(String var1);

        public Builder lastUpdated(Instant var1);

        public Builder name(String var1);

        public Builder pricingPlan(String var1);

        public Builder pricingPlan(PricingPlan var1);

        public Builder progressingJobsCount(Integer var1);

        public Builder reservationPlan(ReservationPlan var1);

        default public Builder reservationPlan(Consumer<ReservationPlan.Builder> reservationPlan) {
            return this.reservationPlan((ReservationPlan)((ReservationPlan.Builder)ReservationPlan.builder().applyMutation(reservationPlan)).build());
        }

        public Builder serviceOverrides(Collection<ServiceOverride> var1);

        public Builder serviceOverrides(ServiceOverride ... var1);

        public Builder serviceOverrides(Consumer<ServiceOverride.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(QueueStatus var1);

        public Builder submittedJobsCount(Integer var1);

        public Builder type(String var1);

        public Builder type(Type var1);
    }
}

