/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.CaptionSourceByteRateLimit;
import software.amazon.awssdk.services.mediaconvert.model.CaptionSourceConvertPaintOnToPopOn;
import software.amazon.awssdk.services.mediaconvert.model.CaptionSourceFramerate;
import software.amazon.awssdk.services.mediaconvert.model.FileSourceConvert608To708;
import software.amazon.awssdk.services.mediaconvert.model.FileSourceTimeDeltaUnits;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileSourceSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileSourceSettings> {
    private static final SdkField<String> BYTE_RATE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByteRateLimit").getter(FileSourceSettings.getter(FileSourceSettings::byteRateLimitAsString)).setter(FileSourceSettings.setter(Builder::byteRateLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("byteRateLimit").build()}).build();
    private static final SdkField<String> CONVERT608_TO708_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Convert608To708").getter(FileSourceSettings.getter(FileSourceSettings::convert608To708AsString)).setter(FileSourceSettings.setter(Builder::convert608To708)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("convert608To708").build()}).build();
    private static final SdkField<String> CONVERT_PAINT_TO_POP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConvertPaintToPop").getter(FileSourceSettings.getter(FileSourceSettings::convertPaintToPopAsString)).setter(FileSourceSettings.setter(Builder::convertPaintToPop)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("convertPaintToPop").build()}).build();
    private static final SdkField<CaptionSourceFramerate> FRAMERATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Framerate").getter(FileSourceSettings.getter(FileSourceSettings::framerate)).setter(FileSourceSettings.setter(Builder::framerate)).constructor(CaptionSourceFramerate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerate").build()}).build();
    private static final SdkField<String> SOURCE_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceFile").getter(FileSourceSettings.getter(FileSourceSettings::sourceFile)).setter(FileSourceSettings.setter(Builder::sourceFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceFile").build()}).build();
    private static final SdkField<Integer> TIME_DELTA_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TimeDelta").getter(FileSourceSettings.getter(FileSourceSettings::timeDelta)).setter(FileSourceSettings.setter(Builder::timeDelta)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeDelta").build()}).build();
    private static final SdkField<String> TIME_DELTA_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimeDeltaUnits").getter(FileSourceSettings.getter(FileSourceSettings::timeDeltaUnitsAsString)).setter(FileSourceSettings.setter(Builder::timeDeltaUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeDeltaUnits").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTE_RATE_LIMIT_FIELD, CONVERT608_TO708_FIELD, CONVERT_PAINT_TO_POP_FIELD, FRAMERATE_FIELD, SOURCE_FILE_FIELD, TIME_DELTA_FIELD, TIME_DELTA_UNITS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FileSourceSettings.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String byteRateLimit;
    private final String convert608To708;
    private final String convertPaintToPop;
    private final CaptionSourceFramerate framerate;
    private final String sourceFile;
    private final Integer timeDelta;
    private final String timeDeltaUnits;

    private FileSourceSettings(BuilderImpl builder) {
        this.byteRateLimit = builder.byteRateLimit;
        this.convert608To708 = builder.convert608To708;
        this.convertPaintToPop = builder.convertPaintToPop;
        this.framerate = builder.framerate;
        this.sourceFile = builder.sourceFile;
        this.timeDelta = builder.timeDelta;
        this.timeDeltaUnits = builder.timeDeltaUnits;
    }

    public final CaptionSourceByteRateLimit byteRateLimit() {
        return CaptionSourceByteRateLimit.fromValue(this.byteRateLimit);
    }

    public final String byteRateLimitAsString() {
        return this.byteRateLimit;
    }

    public final FileSourceConvert608To708 convert608To708() {
        return FileSourceConvert608To708.fromValue(this.convert608To708);
    }

    public final String convert608To708AsString() {
        return this.convert608To708;
    }

    public final CaptionSourceConvertPaintOnToPopOn convertPaintToPop() {
        return CaptionSourceConvertPaintOnToPopOn.fromValue(this.convertPaintToPop);
    }

    public final String convertPaintToPopAsString() {
        return this.convertPaintToPop;
    }

    public final CaptionSourceFramerate framerate() {
        return this.framerate;
    }

    public final String sourceFile() {
        return this.sourceFile;
    }

    public final Integer timeDelta() {
        return this.timeDelta;
    }

    public final FileSourceTimeDeltaUnits timeDeltaUnits() {
        return FileSourceTimeDeltaUnits.fromValue(this.timeDeltaUnits);
    }

    public final String timeDeltaUnitsAsString() {
        return this.timeDeltaUnits;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.byteRateLimitAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.convert608To708AsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.convertPaintToPopAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerate());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeDelta());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeDeltaUnitsAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileSourceSettings)) {
            return false;
        }
        FileSourceSettings other = (FileSourceSettings)obj;
        return Objects.equals(this.byteRateLimitAsString(), other.byteRateLimitAsString()) && Objects.equals(this.convert608To708AsString(), other.convert608To708AsString()) && Objects.equals(this.convertPaintToPopAsString(), other.convertPaintToPopAsString()) && Objects.equals(this.framerate(), other.framerate()) && Objects.equals(this.sourceFile(), other.sourceFile()) && Objects.equals(this.timeDelta(), other.timeDelta()) && Objects.equals(this.timeDeltaUnitsAsString(), other.timeDeltaUnitsAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FileSourceSettings").add("ByteRateLimit", (Object)this.byteRateLimitAsString()).add("Convert608To708", (Object)this.convert608To708AsString()).add("ConvertPaintToPop", (Object)this.convertPaintToPopAsString()).add("Framerate", (Object)this.framerate()).add("SourceFile", (Object)this.sourceFile()).add("TimeDelta", (Object)this.timeDelta()).add("TimeDeltaUnits", (Object)this.timeDeltaUnitsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ByteRateLimit": {
                return Optional.ofNullable(clazz.cast(this.byteRateLimitAsString()));
            }
            case "Convert608To708": {
                return Optional.ofNullable(clazz.cast(this.convert608To708AsString()));
            }
            case "ConvertPaintToPop": {
                return Optional.ofNullable(clazz.cast(this.convertPaintToPopAsString()));
            }
            case "Framerate": {
                return Optional.ofNullable(clazz.cast(this.framerate()));
            }
            case "SourceFile": {
                return Optional.ofNullable(clazz.cast(this.sourceFile()));
            }
            case "TimeDelta": {
                return Optional.ofNullable(clazz.cast(this.timeDelta()));
            }
            case "TimeDeltaUnits": {
                return Optional.ofNullable(clazz.cast(this.timeDeltaUnitsAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("byteRateLimit", BYTE_RATE_LIMIT_FIELD);
        map.put("convert608To708", CONVERT608_TO708_FIELD);
        map.put("convertPaintToPop", CONVERT_PAINT_TO_POP_FIELD);
        map.put("framerate", FRAMERATE_FIELD);
        map.put("sourceFile", SOURCE_FILE_FIELD);
        map.put("timeDelta", TIME_DELTA_FIELD);
        map.put("timeDeltaUnits", TIME_DELTA_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileSourceSettings, T> g) {
        return obj -> g.apply((FileSourceSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String byteRateLimit;
        private String convert608To708;
        private String convertPaintToPop;
        private CaptionSourceFramerate framerate;
        private String sourceFile;
        private Integer timeDelta;
        private String timeDeltaUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(FileSourceSettings model) {
            this.byteRateLimit(model.byteRateLimit);
            this.convert608To708(model.convert608To708);
            this.convertPaintToPop(model.convertPaintToPop);
            this.framerate(model.framerate);
            this.sourceFile(model.sourceFile);
            this.timeDelta(model.timeDelta);
            this.timeDeltaUnits(model.timeDeltaUnits);
        }

        public final String getByteRateLimit() {
            return this.byteRateLimit;
        }

        public final void setByteRateLimit(String byteRateLimit) {
            this.byteRateLimit = byteRateLimit;
        }

        @Override
        public final Builder byteRateLimit(String byteRateLimit) {
            this.byteRateLimit = byteRateLimit;
            return this;
        }

        @Override
        public final Builder byteRateLimit(CaptionSourceByteRateLimit byteRateLimit) {
            this.byteRateLimit(byteRateLimit == null ? null : byteRateLimit.toString());
            return this;
        }

        public final String getConvert608To708() {
            return this.convert608To708;
        }

        public final void setConvert608To708(String convert608To708) {
            this.convert608To708 = convert608To708;
        }

        @Override
        public final Builder convert608To708(String convert608To708) {
            this.convert608To708 = convert608To708;
            return this;
        }

        @Override
        public final Builder convert608To708(FileSourceConvert608To708 convert608To708) {
            this.convert608To708(convert608To708 == null ? null : convert608To708.toString());
            return this;
        }

        public final String getConvertPaintToPop() {
            return this.convertPaintToPop;
        }

        public final void setConvertPaintToPop(String convertPaintToPop) {
            this.convertPaintToPop = convertPaintToPop;
        }

        @Override
        public final Builder convertPaintToPop(String convertPaintToPop) {
            this.convertPaintToPop = convertPaintToPop;
            return this;
        }

        @Override
        public final Builder convertPaintToPop(CaptionSourceConvertPaintOnToPopOn convertPaintToPop) {
            this.convertPaintToPop(convertPaintToPop == null ? null : convertPaintToPop.toString());
            return this;
        }

        public final CaptionSourceFramerate.Builder getFramerate() {
            return this.framerate != null ? this.framerate.toBuilder() : null;
        }

        public final void setFramerate(CaptionSourceFramerate.BuilderImpl framerate) {
            this.framerate = framerate != null ? framerate.build() : null;
        }

        @Override
        public final Builder framerate(CaptionSourceFramerate framerate) {
            this.framerate = framerate;
            return this;
        }

        public final String getSourceFile() {
            return this.sourceFile;
        }

        public final void setSourceFile(String sourceFile) {
            this.sourceFile = sourceFile;
        }

        @Override
        public final Builder sourceFile(String sourceFile) {
            this.sourceFile = sourceFile;
            return this;
        }

        public final Integer getTimeDelta() {
            return this.timeDelta;
        }

        public final void setTimeDelta(Integer timeDelta) {
            this.timeDelta = timeDelta;
        }

        @Override
        public final Builder timeDelta(Integer timeDelta) {
            this.timeDelta = timeDelta;
            return this;
        }

        public final String getTimeDeltaUnits() {
            return this.timeDeltaUnits;
        }

        public final void setTimeDeltaUnits(String timeDeltaUnits) {
            this.timeDeltaUnits = timeDeltaUnits;
        }

        @Override
        public final Builder timeDeltaUnits(String timeDeltaUnits) {
            this.timeDeltaUnits = timeDeltaUnits;
            return this;
        }

        @Override
        public final Builder timeDeltaUnits(FileSourceTimeDeltaUnits timeDeltaUnits) {
            this.timeDeltaUnits(timeDeltaUnits == null ? null : timeDeltaUnits.toString());
            return this;
        }

        public FileSourceSettings build() {
            return new FileSourceSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileSourceSettings> {
        public Builder byteRateLimit(String var1);

        public Builder byteRateLimit(CaptionSourceByteRateLimit var1);

        public Builder convert608To708(String var1);

        public Builder convert608To708(FileSourceConvert608To708 var1);

        public Builder convertPaintToPop(String var1);

        public Builder convertPaintToPop(CaptionSourceConvertPaintOnToPopOn var1);

        public Builder framerate(CaptionSourceFramerate var1);

        default public Builder framerate(Consumer<CaptionSourceFramerate.Builder> framerate) {
            return this.framerate((CaptionSourceFramerate)((CaptionSourceFramerate.Builder)CaptionSourceFramerate.builder().applyMutation(framerate)).build());
        }

        public Builder sourceFile(String var1);

        public Builder timeDelta(Integer var1);

        public Builder timeDeltaUnits(String var1);

        public Builder timeDeltaUnits(FileSourceTimeDeltaUnits var1);
    }
}

