/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mediaconvert.model.AdvancedInputFilter;
import software.amazon.awssdk.services.mediaconvert.model.AdvancedInputFilterSettings;
import software.amazon.awssdk.services.mediaconvert.model.AudioSelector;
import software.amazon.awssdk.services.mediaconvert.model.AudioSelectorGroup;
import software.amazon.awssdk.services.mediaconvert.model.CaptionSelector;
import software.amazon.awssdk.services.mediaconvert.model.ImageInserter;
import software.amazon.awssdk.services.mediaconvert.model.InputClipping;
import software.amazon.awssdk.services.mediaconvert.model.InputDeblockFilter;
import software.amazon.awssdk.services.mediaconvert.model.InputDenoiseFilter;
import software.amazon.awssdk.services.mediaconvert.model.InputFilterEnable;
import software.amazon.awssdk.services.mediaconvert.model.InputPsiControl;
import software.amazon.awssdk.services.mediaconvert.model.InputScanType;
import software.amazon.awssdk.services.mediaconvert.model.InputTimecodeSource;
import software.amazon.awssdk.services.mediaconvert.model.Rectangle;
import software.amazon.awssdk.services.mediaconvert.model.VideoOverlay;
import software.amazon.awssdk.services.mediaconvert.model.VideoSelector;
import software.amazon.awssdk.services.mediaconvert.model.___listOfInputClippingCopier;
import software.amazon.awssdk.services.mediaconvert.model.___listOfVideoOverlayCopier;
import software.amazon.awssdk.services.mediaconvert.model.___mapOfAudioSelectorCopier;
import software.amazon.awssdk.services.mediaconvert.model.___mapOfAudioSelectorGroupCopier;
import software.amazon.awssdk.services.mediaconvert.model.___mapOfCaptionSelectorCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InputTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InputTemplate> {
    private static final SdkField<String> ADVANCED_INPUT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdvancedInputFilter").getter(InputTemplate.getter(InputTemplate::advancedInputFilterAsString)).setter(InputTemplate.setter(Builder::advancedInputFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("advancedInputFilter").build()}).build();
    private static final SdkField<AdvancedInputFilterSettings> ADVANCED_INPUT_FILTER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdvancedInputFilterSettings").getter(InputTemplate.getter(InputTemplate::advancedInputFilterSettings)).setter(InputTemplate.setter(Builder::advancedInputFilterSettings)).constructor(AdvancedInputFilterSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("advancedInputFilterSettings").build()}).build();
    private static final SdkField<Map<String, AudioSelectorGroup>> AUDIO_SELECTOR_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AudioSelectorGroups").getter(InputTemplate.getter(InputTemplate::audioSelectorGroups)).setter(InputTemplate.setter(Builder::audioSelectorGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSelectorGroups").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudioSelectorGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AudioSelector>> AUDIO_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("AudioSelectors").getter(InputTemplate.getter(InputTemplate::audioSelectors)).setter(InputTemplate.setter(Builder::audioSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioSelectors").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AudioSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, CaptionSelector>> CAPTION_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("CaptionSelectors").getter(InputTemplate.getter(InputTemplate::captionSelectors)).setter(InputTemplate.setter(Builder::captionSelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionSelectors").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaptionSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Rectangle> CROP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Crop").getter(InputTemplate.getter(InputTemplate::crop)).setter(InputTemplate.setter(Builder::crop)).constructor(Rectangle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crop").build()}).build();
    private static final SdkField<String> DEBLOCK_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeblockFilter").getter(InputTemplate.getter(InputTemplate::deblockFilterAsString)).setter(InputTemplate.setter(Builder::deblockFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deblockFilter").build()}).build();
    private static final SdkField<String> DENOISE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DenoiseFilter").getter(InputTemplate.getter(InputTemplate::denoiseFilterAsString)).setter(InputTemplate.setter(Builder::denoiseFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("denoiseFilter").build()}).build();
    private static final SdkField<String> DOLBY_VISION_METADATA_XML_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DolbyVisionMetadataXml").getter(InputTemplate.getter(InputTemplate::dolbyVisionMetadataXml)).setter(InputTemplate.setter(Builder::dolbyVisionMetadataXml)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dolbyVisionMetadataXml").build()}).build();
    private static final SdkField<String> FILTER_ENABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FilterEnable").getter(InputTemplate.getter(InputTemplate::filterEnableAsString)).setter(InputTemplate.setter(Builder::filterEnable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterEnable").build()}).build();
    private static final SdkField<Integer> FILTER_STRENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FilterStrength").getter(InputTemplate.getter(InputTemplate::filterStrength)).setter(InputTemplate.setter(Builder::filterStrength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterStrength").build()}).build();
    private static final SdkField<ImageInserter> IMAGE_INSERTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ImageInserter").getter(InputTemplate.getter(InputTemplate::imageInserter)).setter(InputTemplate.setter(Builder::imageInserter)).constructor(ImageInserter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageInserter").build()}).build();
    private static final SdkField<List<InputClipping>> INPUT_CLIPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputClippings").getter(InputTemplate.getter(InputTemplate::inputClippings)).setter(InputTemplate.setter(Builder::inputClippings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputClippings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InputClipping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INPUT_SCAN_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputScanType").getter(InputTemplate.getter(InputTemplate::inputScanTypeAsString)).setter(InputTemplate.setter(Builder::inputScanType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputScanType").build()}).build();
    private static final SdkField<Rectangle> POSITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Position").getter(InputTemplate.getter(InputTemplate::position)).setter(InputTemplate.setter(Builder::position)).constructor(Rectangle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("position").build()}).build();
    private static final SdkField<Integer> PROGRAM_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ProgramNumber").getter(InputTemplate.getter(InputTemplate::programNumber)).setter(InputTemplate.setter(Builder::programNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("programNumber").build()}).build();
    private static final SdkField<String> PSI_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PsiControl").getter(InputTemplate.getter(InputTemplate::psiControlAsString)).setter(InputTemplate.setter(Builder::psiControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("psiControl").build()}).build();
    private static final SdkField<String> TIMECODE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimecodeSource").getter(InputTemplate.getter(InputTemplate::timecodeSourceAsString)).setter(InputTemplate.setter(Builder::timecodeSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeSource").build()}).build();
    private static final SdkField<String> TIMECODE_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimecodeStart").getter(InputTemplate.getter(InputTemplate::timecodeStart)).setter(InputTemplate.setter(Builder::timecodeStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timecodeStart").build()}).build();
    private static final SdkField<List<VideoOverlay>> VIDEO_OVERLAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VideoOverlays").getter(InputTemplate.getter(InputTemplate::videoOverlays)).setter(InputTemplate.setter(Builder::videoOverlays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoOverlays").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VideoOverlay::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VideoSelector> VIDEO_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VideoSelector").getter(InputTemplate.getter(InputTemplate::videoSelector)).setter(InputTemplate.setter(Builder::videoSelector)).constructor(VideoSelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoSelector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADVANCED_INPUT_FILTER_FIELD, ADVANCED_INPUT_FILTER_SETTINGS_FIELD, AUDIO_SELECTOR_GROUPS_FIELD, AUDIO_SELECTORS_FIELD, CAPTION_SELECTORS_FIELD, CROP_FIELD, DEBLOCK_FILTER_FIELD, DENOISE_FILTER_FIELD, DOLBY_VISION_METADATA_XML_FIELD, FILTER_ENABLE_FIELD, FILTER_STRENGTH_FIELD, IMAGE_INSERTER_FIELD, INPUT_CLIPPINGS_FIELD, INPUT_SCAN_TYPE_FIELD, POSITION_FIELD, PROGRAM_NUMBER_FIELD, PSI_CONTROL_FIELD, TIMECODE_SOURCE_FIELD, TIMECODE_START_FIELD, VIDEO_OVERLAYS_FIELD, VIDEO_SELECTOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("advancedInputFilter", ADVANCED_INPUT_FILTER_FIELD);
            this.put("advancedInputFilterSettings", ADVANCED_INPUT_FILTER_SETTINGS_FIELD);
            this.put("audioSelectorGroups", AUDIO_SELECTOR_GROUPS_FIELD);
            this.put("audioSelectors", AUDIO_SELECTORS_FIELD);
            this.put("captionSelectors", CAPTION_SELECTORS_FIELD);
            this.put("crop", CROP_FIELD);
            this.put("deblockFilter", DEBLOCK_FILTER_FIELD);
            this.put("denoiseFilter", DENOISE_FILTER_FIELD);
            this.put("dolbyVisionMetadataXml", DOLBY_VISION_METADATA_XML_FIELD);
            this.put("filterEnable", FILTER_ENABLE_FIELD);
            this.put("filterStrength", FILTER_STRENGTH_FIELD);
            this.put("imageInserter", IMAGE_INSERTER_FIELD);
            this.put("inputClippings", INPUT_CLIPPINGS_FIELD);
            this.put("inputScanType", INPUT_SCAN_TYPE_FIELD);
            this.put("position", POSITION_FIELD);
            this.put("programNumber", PROGRAM_NUMBER_FIELD);
            this.put("psiControl", PSI_CONTROL_FIELD);
            this.put("timecodeSource", TIMECODE_SOURCE_FIELD);
            this.put("timecodeStart", TIMECODE_START_FIELD);
            this.put("videoOverlays", VIDEO_OVERLAYS_FIELD);
            this.put("videoSelector", VIDEO_SELECTOR_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String advancedInputFilter;
    private final AdvancedInputFilterSettings advancedInputFilterSettings;
    private final Map<String, AudioSelectorGroup> audioSelectorGroups;
    private final Map<String, AudioSelector> audioSelectors;
    private final Map<String, CaptionSelector> captionSelectors;
    private final Rectangle crop;
    private final String deblockFilter;
    private final String denoiseFilter;
    private final String dolbyVisionMetadataXml;
    private final String filterEnable;
    private final Integer filterStrength;
    private final ImageInserter imageInserter;
    private final List<InputClipping> inputClippings;
    private final String inputScanType;
    private final Rectangle position;
    private final Integer programNumber;
    private final String psiControl;
    private final String timecodeSource;
    private final String timecodeStart;
    private final List<VideoOverlay> videoOverlays;
    private final VideoSelector videoSelector;

    private InputTemplate(BuilderImpl builder) {
        this.advancedInputFilter = builder.advancedInputFilter;
        this.advancedInputFilterSettings = builder.advancedInputFilterSettings;
        this.audioSelectorGroups = builder.audioSelectorGroups;
        this.audioSelectors = builder.audioSelectors;
        this.captionSelectors = builder.captionSelectors;
        this.crop = builder.crop;
        this.deblockFilter = builder.deblockFilter;
        this.denoiseFilter = builder.denoiseFilter;
        this.dolbyVisionMetadataXml = builder.dolbyVisionMetadataXml;
        this.filterEnable = builder.filterEnable;
        this.filterStrength = builder.filterStrength;
        this.imageInserter = builder.imageInserter;
        this.inputClippings = builder.inputClippings;
        this.inputScanType = builder.inputScanType;
        this.position = builder.position;
        this.programNumber = builder.programNumber;
        this.psiControl = builder.psiControl;
        this.timecodeSource = builder.timecodeSource;
        this.timecodeStart = builder.timecodeStart;
        this.videoOverlays = builder.videoOverlays;
        this.videoSelector = builder.videoSelector;
    }

    public final AdvancedInputFilter advancedInputFilter() {
        return AdvancedInputFilter.fromValue(this.advancedInputFilter);
    }

    public final String advancedInputFilterAsString() {
        return this.advancedInputFilter;
    }

    public final AdvancedInputFilterSettings advancedInputFilterSettings() {
        return this.advancedInputFilterSettings;
    }

    public final boolean hasAudioSelectorGroups() {
        return this.audioSelectorGroups != null && !(this.audioSelectorGroups instanceof SdkAutoConstructMap);
    }

    public final Map<String, AudioSelectorGroup> audioSelectorGroups() {
        return this.audioSelectorGroups;
    }

    public final boolean hasAudioSelectors() {
        return this.audioSelectors != null && !(this.audioSelectors instanceof SdkAutoConstructMap);
    }

    public final Map<String, AudioSelector> audioSelectors() {
        return this.audioSelectors;
    }

    public final boolean hasCaptionSelectors() {
        return this.captionSelectors != null && !(this.captionSelectors instanceof SdkAutoConstructMap);
    }

    public final Map<String, CaptionSelector> captionSelectors() {
        return this.captionSelectors;
    }

    public final Rectangle crop() {
        return this.crop;
    }

    public final InputDeblockFilter deblockFilter() {
        return InputDeblockFilter.fromValue(this.deblockFilter);
    }

    public final String deblockFilterAsString() {
        return this.deblockFilter;
    }

    public final InputDenoiseFilter denoiseFilter() {
        return InputDenoiseFilter.fromValue(this.denoiseFilter);
    }

    public final String denoiseFilterAsString() {
        return this.denoiseFilter;
    }

    public final String dolbyVisionMetadataXml() {
        return this.dolbyVisionMetadataXml;
    }

    public final InputFilterEnable filterEnable() {
        return InputFilterEnable.fromValue(this.filterEnable);
    }

    public final String filterEnableAsString() {
        return this.filterEnable;
    }

    public final Integer filterStrength() {
        return this.filterStrength;
    }

    public final ImageInserter imageInserter() {
        return this.imageInserter;
    }

    public final boolean hasInputClippings() {
        return this.inputClippings != null && !(this.inputClippings instanceof SdkAutoConstructList);
    }

    public final List<InputClipping> inputClippings() {
        return this.inputClippings;
    }

    public final InputScanType inputScanType() {
        return InputScanType.fromValue(this.inputScanType);
    }

    public final String inputScanTypeAsString() {
        return this.inputScanType;
    }

    public final Rectangle position() {
        return this.position;
    }

    public final Integer programNumber() {
        return this.programNumber;
    }

    public final InputPsiControl psiControl() {
        return InputPsiControl.fromValue(this.psiControl);
    }

    public final String psiControlAsString() {
        return this.psiControl;
    }

    public final InputTimecodeSource timecodeSource() {
        return InputTimecodeSource.fromValue(this.timecodeSource);
    }

    public final String timecodeSourceAsString() {
        return this.timecodeSource;
    }

    public final String timecodeStart() {
        return this.timecodeStart;
    }

    public final boolean hasVideoOverlays() {
        return this.videoOverlays != null && !(this.videoOverlays instanceof SdkAutoConstructList);
    }

    public final List<VideoOverlay> videoOverlays() {
        return this.videoOverlays;
    }

    public final VideoSelector videoSelector() {
        return this.videoSelector;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedInputFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.advancedInputFilterSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudioSelectorGroups() ? this.audioSelectorGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAudioSelectors() ? this.audioSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCaptionSelectors() ? this.captionSelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.crop());
        hashCode = 31 * hashCode + Objects.hashCode(this.deblockFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.denoiseFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dolbyVisionMetadataXml());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterEnableAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterStrength());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageInserter());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputClippings() ? this.inputClippings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.inputScanTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.position());
        hashCode = 31 * hashCode + Objects.hashCode(this.programNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.psiControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timecodeStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVideoOverlays() ? this.videoOverlays() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.videoSelector());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputTemplate)) {
            return false;
        }
        InputTemplate other = (InputTemplate)obj;
        return Objects.equals(this.advancedInputFilterAsString(), other.advancedInputFilterAsString()) && Objects.equals(this.advancedInputFilterSettings(), other.advancedInputFilterSettings()) && this.hasAudioSelectorGroups() == other.hasAudioSelectorGroups() && Objects.equals(this.audioSelectorGroups(), other.audioSelectorGroups()) && this.hasAudioSelectors() == other.hasAudioSelectors() && Objects.equals(this.audioSelectors(), other.audioSelectors()) && this.hasCaptionSelectors() == other.hasCaptionSelectors() && Objects.equals(this.captionSelectors(), other.captionSelectors()) && Objects.equals(this.crop(), other.crop()) && Objects.equals(this.deblockFilterAsString(), other.deblockFilterAsString()) && Objects.equals(this.denoiseFilterAsString(), other.denoiseFilterAsString()) && Objects.equals(this.dolbyVisionMetadataXml(), other.dolbyVisionMetadataXml()) && Objects.equals(this.filterEnableAsString(), other.filterEnableAsString()) && Objects.equals(this.filterStrength(), other.filterStrength()) && Objects.equals(this.imageInserter(), other.imageInserter()) && this.hasInputClippings() == other.hasInputClippings() && Objects.equals(this.inputClippings(), other.inputClippings()) && Objects.equals(this.inputScanTypeAsString(), other.inputScanTypeAsString()) && Objects.equals(this.position(), other.position()) && Objects.equals(this.programNumber(), other.programNumber()) && Objects.equals(this.psiControlAsString(), other.psiControlAsString()) && Objects.equals(this.timecodeSourceAsString(), other.timecodeSourceAsString()) && Objects.equals(this.timecodeStart(), other.timecodeStart()) && this.hasVideoOverlays() == other.hasVideoOverlays() && Objects.equals(this.videoOverlays(), other.videoOverlays()) && Objects.equals(this.videoSelector(), other.videoSelector());
    }

    public final String toString() {
        return ToString.builder((String)"InputTemplate").add("AdvancedInputFilter", (Object)this.advancedInputFilterAsString()).add("AdvancedInputFilterSettings", (Object)this.advancedInputFilterSettings()).add("AudioSelectorGroups", this.hasAudioSelectorGroups() ? this.audioSelectorGroups() : null).add("AudioSelectors", this.hasAudioSelectors() ? this.audioSelectors() : null).add("CaptionSelectors", this.hasCaptionSelectors() ? this.captionSelectors() : null).add("Crop", (Object)this.crop()).add("DeblockFilter", (Object)this.deblockFilterAsString()).add("DenoiseFilter", (Object)this.denoiseFilterAsString()).add("DolbyVisionMetadataXml", (Object)this.dolbyVisionMetadataXml()).add("FilterEnable", (Object)this.filterEnableAsString()).add("FilterStrength", (Object)this.filterStrength()).add("ImageInserter", (Object)this.imageInserter()).add("InputClippings", this.hasInputClippings() ? this.inputClippings() : null).add("InputScanType", (Object)this.inputScanTypeAsString()).add("Position", (Object)this.position()).add("ProgramNumber", (Object)this.programNumber()).add("PsiControl", (Object)this.psiControlAsString()).add("TimecodeSource", (Object)this.timecodeSourceAsString()).add("TimecodeStart", (Object)this.timecodeStart()).add("VideoOverlays", this.hasVideoOverlays() ? this.videoOverlays() : null).add("VideoSelector", (Object)this.videoSelector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdvancedInputFilter": {
                return Optional.ofNullable(clazz.cast(this.advancedInputFilterAsString()));
            }
            case "AdvancedInputFilterSettings": {
                return Optional.ofNullable(clazz.cast(this.advancedInputFilterSettings()));
            }
            case "AudioSelectorGroups": {
                return Optional.ofNullable(clazz.cast(this.audioSelectorGroups()));
            }
            case "AudioSelectors": {
                return Optional.ofNullable(clazz.cast(this.audioSelectors()));
            }
            case "CaptionSelectors": {
                return Optional.ofNullable(clazz.cast(this.captionSelectors()));
            }
            case "Crop": {
                return Optional.ofNullable(clazz.cast(this.crop()));
            }
            case "DeblockFilter": {
                return Optional.ofNullable(clazz.cast(this.deblockFilterAsString()));
            }
            case "DenoiseFilter": {
                return Optional.ofNullable(clazz.cast(this.denoiseFilterAsString()));
            }
            case "DolbyVisionMetadataXml": {
                return Optional.ofNullable(clazz.cast(this.dolbyVisionMetadataXml()));
            }
            case "FilterEnable": {
                return Optional.ofNullable(clazz.cast(this.filterEnableAsString()));
            }
            case "FilterStrength": {
                return Optional.ofNullable(clazz.cast(this.filterStrength()));
            }
            case "ImageInserter": {
                return Optional.ofNullable(clazz.cast(this.imageInserter()));
            }
            case "InputClippings": {
                return Optional.ofNullable(clazz.cast(this.inputClippings()));
            }
            case "InputScanType": {
                return Optional.ofNullable(clazz.cast(this.inputScanTypeAsString()));
            }
            case "Position": {
                return Optional.ofNullable(clazz.cast(this.position()));
            }
            case "ProgramNumber": {
                return Optional.ofNullable(clazz.cast(this.programNumber()));
            }
            case "PsiControl": {
                return Optional.ofNullable(clazz.cast(this.psiControlAsString()));
            }
            case "TimecodeSource": {
                return Optional.ofNullable(clazz.cast(this.timecodeSourceAsString()));
            }
            case "TimecodeStart": {
                return Optional.ofNullable(clazz.cast(this.timecodeStart()));
            }
            case "VideoOverlays": {
                return Optional.ofNullable(clazz.cast(this.videoOverlays()));
            }
            case "VideoSelector": {
                return Optional.ofNullable(clazz.cast(this.videoSelector()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InputTemplate, T> g) {
        return obj -> g.apply((InputTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String advancedInputFilter;
        private AdvancedInputFilterSettings advancedInputFilterSettings;
        private Map<String, AudioSelectorGroup> audioSelectorGroups = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, AudioSelector> audioSelectors = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, CaptionSelector> captionSelectors = DefaultSdkAutoConstructMap.getInstance();
        private Rectangle crop;
        private String deblockFilter;
        private String denoiseFilter;
        private String dolbyVisionMetadataXml;
        private String filterEnable;
        private Integer filterStrength;
        private ImageInserter imageInserter;
        private List<InputClipping> inputClippings = DefaultSdkAutoConstructList.getInstance();
        private String inputScanType;
        private Rectangle position;
        private Integer programNumber;
        private String psiControl;
        private String timecodeSource;
        private String timecodeStart;
        private List<VideoOverlay> videoOverlays = DefaultSdkAutoConstructList.getInstance();
        private VideoSelector videoSelector;

        private BuilderImpl() {
        }

        private BuilderImpl(InputTemplate model) {
            this.advancedInputFilter(model.advancedInputFilter);
            this.advancedInputFilterSettings(model.advancedInputFilterSettings);
            this.audioSelectorGroups(model.audioSelectorGroups);
            this.audioSelectors(model.audioSelectors);
            this.captionSelectors(model.captionSelectors);
            this.crop(model.crop);
            this.deblockFilter(model.deblockFilter);
            this.denoiseFilter(model.denoiseFilter);
            this.dolbyVisionMetadataXml(model.dolbyVisionMetadataXml);
            this.filterEnable(model.filterEnable);
            this.filterStrength(model.filterStrength);
            this.imageInserter(model.imageInserter);
            this.inputClippings(model.inputClippings);
            this.inputScanType(model.inputScanType);
            this.position(model.position);
            this.programNumber(model.programNumber);
            this.psiControl(model.psiControl);
            this.timecodeSource(model.timecodeSource);
            this.timecodeStart(model.timecodeStart);
            this.videoOverlays(model.videoOverlays);
            this.videoSelector(model.videoSelector);
        }

        public final String getAdvancedInputFilter() {
            return this.advancedInputFilter;
        }

        public final void setAdvancedInputFilter(String advancedInputFilter) {
            this.advancedInputFilter = advancedInputFilter;
        }

        @Override
        public final Builder advancedInputFilter(String advancedInputFilter) {
            this.advancedInputFilter = advancedInputFilter;
            return this;
        }

        @Override
        public final Builder advancedInputFilter(AdvancedInputFilter advancedInputFilter) {
            this.advancedInputFilter(advancedInputFilter == null ? null : advancedInputFilter.toString());
            return this;
        }

        public final AdvancedInputFilterSettings.Builder getAdvancedInputFilterSettings() {
            return this.advancedInputFilterSettings != null ? this.advancedInputFilterSettings.toBuilder() : null;
        }

        public final void setAdvancedInputFilterSettings(AdvancedInputFilterSettings.BuilderImpl advancedInputFilterSettings) {
            this.advancedInputFilterSettings = advancedInputFilterSettings != null ? advancedInputFilterSettings.build() : null;
        }

        @Override
        public final Builder advancedInputFilterSettings(AdvancedInputFilterSettings advancedInputFilterSettings) {
            this.advancedInputFilterSettings = advancedInputFilterSettings;
            return this;
        }

        public final Map<String, AudioSelectorGroup.Builder> getAudioSelectorGroups() {
            Map<String, AudioSelectorGroup.Builder> result = ___mapOfAudioSelectorGroupCopier.copyToBuilder(this.audioSelectorGroups);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAudioSelectorGroups(Map<String, AudioSelectorGroup.BuilderImpl> audioSelectorGroups) {
            this.audioSelectorGroups = ___mapOfAudioSelectorGroupCopier.copyFromBuilder(audioSelectorGroups);
        }

        @Override
        public final Builder audioSelectorGroups(Map<String, AudioSelectorGroup> audioSelectorGroups) {
            this.audioSelectorGroups = ___mapOfAudioSelectorGroupCopier.copy(audioSelectorGroups);
            return this;
        }

        public final Map<String, AudioSelector.Builder> getAudioSelectors() {
            Map<String, AudioSelector.Builder> result = ___mapOfAudioSelectorCopier.copyToBuilder(this.audioSelectors);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAudioSelectors(Map<String, AudioSelector.BuilderImpl> audioSelectors) {
            this.audioSelectors = ___mapOfAudioSelectorCopier.copyFromBuilder(audioSelectors);
        }

        @Override
        public final Builder audioSelectors(Map<String, AudioSelector> audioSelectors) {
            this.audioSelectors = ___mapOfAudioSelectorCopier.copy(audioSelectors);
            return this;
        }

        public final Map<String, CaptionSelector.Builder> getCaptionSelectors() {
            Map<String, CaptionSelector.Builder> result = ___mapOfCaptionSelectorCopier.copyToBuilder(this.captionSelectors);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setCaptionSelectors(Map<String, CaptionSelector.BuilderImpl> captionSelectors) {
            this.captionSelectors = ___mapOfCaptionSelectorCopier.copyFromBuilder(captionSelectors);
        }

        @Override
        public final Builder captionSelectors(Map<String, CaptionSelector> captionSelectors) {
            this.captionSelectors = ___mapOfCaptionSelectorCopier.copy(captionSelectors);
            return this;
        }

        public final Rectangle.Builder getCrop() {
            return this.crop != null ? this.crop.toBuilder() : null;
        }

        public final void setCrop(Rectangle.BuilderImpl crop) {
            this.crop = crop != null ? crop.build() : null;
        }

        @Override
        public final Builder crop(Rectangle crop) {
            this.crop = crop;
            return this;
        }

        public final String getDeblockFilter() {
            return this.deblockFilter;
        }

        public final void setDeblockFilter(String deblockFilter) {
            this.deblockFilter = deblockFilter;
        }

        @Override
        public final Builder deblockFilter(String deblockFilter) {
            this.deblockFilter = deblockFilter;
            return this;
        }

        @Override
        public final Builder deblockFilter(InputDeblockFilter deblockFilter) {
            this.deblockFilter(deblockFilter == null ? null : deblockFilter.toString());
            return this;
        }

        public final String getDenoiseFilter() {
            return this.denoiseFilter;
        }

        public final void setDenoiseFilter(String denoiseFilter) {
            this.denoiseFilter = denoiseFilter;
        }

        @Override
        public final Builder denoiseFilter(String denoiseFilter) {
            this.denoiseFilter = denoiseFilter;
            return this;
        }

        @Override
        public final Builder denoiseFilter(InputDenoiseFilter denoiseFilter) {
            this.denoiseFilter(denoiseFilter == null ? null : denoiseFilter.toString());
            return this;
        }

        public final String getDolbyVisionMetadataXml() {
            return this.dolbyVisionMetadataXml;
        }

        public final void setDolbyVisionMetadataXml(String dolbyVisionMetadataXml) {
            this.dolbyVisionMetadataXml = dolbyVisionMetadataXml;
        }

        @Override
        public final Builder dolbyVisionMetadataXml(String dolbyVisionMetadataXml) {
            this.dolbyVisionMetadataXml = dolbyVisionMetadataXml;
            return this;
        }

        public final String getFilterEnable() {
            return this.filterEnable;
        }

        public final void setFilterEnable(String filterEnable) {
            this.filterEnable = filterEnable;
        }

        @Override
        public final Builder filterEnable(String filterEnable) {
            this.filterEnable = filterEnable;
            return this;
        }

        @Override
        public final Builder filterEnable(InputFilterEnable filterEnable) {
            this.filterEnable(filterEnable == null ? null : filterEnable.toString());
            return this;
        }

        public final Integer getFilterStrength() {
            return this.filterStrength;
        }

        public final void setFilterStrength(Integer filterStrength) {
            this.filterStrength = filterStrength;
        }

        @Override
        public final Builder filterStrength(Integer filterStrength) {
            this.filterStrength = filterStrength;
            return this;
        }

        public final ImageInserter.Builder getImageInserter() {
            return this.imageInserter != null ? this.imageInserter.toBuilder() : null;
        }

        public final void setImageInserter(ImageInserter.BuilderImpl imageInserter) {
            this.imageInserter = imageInserter != null ? imageInserter.build() : null;
        }

        @Override
        public final Builder imageInserter(ImageInserter imageInserter) {
            this.imageInserter = imageInserter;
            return this;
        }

        public final List<InputClipping.Builder> getInputClippings() {
            List<InputClipping.Builder> result = ___listOfInputClippingCopier.copyToBuilder(this.inputClippings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputClippings(Collection<InputClipping.BuilderImpl> inputClippings) {
            this.inputClippings = ___listOfInputClippingCopier.copyFromBuilder(inputClippings);
        }

        @Override
        public final Builder inputClippings(Collection<InputClipping> inputClippings) {
            this.inputClippings = ___listOfInputClippingCopier.copy(inputClippings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputClippings(InputClipping ... inputClippings) {
            this.inputClippings(Arrays.asList(inputClippings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputClippings(Consumer<InputClipping.Builder> ... inputClippings) {
            this.inputClippings(Stream.of(inputClippings).map(c -> (InputClipping)((InputClipping.Builder)InputClipping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getInputScanType() {
            return this.inputScanType;
        }

        public final void setInputScanType(String inputScanType) {
            this.inputScanType = inputScanType;
        }

        @Override
        public final Builder inputScanType(String inputScanType) {
            this.inputScanType = inputScanType;
            return this;
        }

        @Override
        public final Builder inputScanType(InputScanType inputScanType) {
            this.inputScanType(inputScanType == null ? null : inputScanType.toString());
            return this;
        }

        public final Rectangle.Builder getPosition() {
            return this.position != null ? this.position.toBuilder() : null;
        }

        public final void setPosition(Rectangle.BuilderImpl position) {
            this.position = position != null ? position.build() : null;
        }

        @Override
        public final Builder position(Rectangle position) {
            this.position = position;
            return this;
        }

        public final Integer getProgramNumber() {
            return this.programNumber;
        }

        public final void setProgramNumber(Integer programNumber) {
            this.programNumber = programNumber;
        }

        @Override
        public final Builder programNumber(Integer programNumber) {
            this.programNumber = programNumber;
            return this;
        }

        public final String getPsiControl() {
            return this.psiControl;
        }

        public final void setPsiControl(String psiControl) {
            this.psiControl = psiControl;
        }

        @Override
        public final Builder psiControl(String psiControl) {
            this.psiControl = psiControl;
            return this;
        }

        @Override
        public final Builder psiControl(InputPsiControl psiControl) {
            this.psiControl(psiControl == null ? null : psiControl.toString());
            return this;
        }

        public final String getTimecodeSource() {
            return this.timecodeSource;
        }

        public final void setTimecodeSource(String timecodeSource) {
            this.timecodeSource = timecodeSource;
        }

        @Override
        public final Builder timecodeSource(String timecodeSource) {
            this.timecodeSource = timecodeSource;
            return this;
        }

        @Override
        public final Builder timecodeSource(InputTimecodeSource timecodeSource) {
            this.timecodeSource(timecodeSource == null ? null : timecodeSource.toString());
            return this;
        }

        public final String getTimecodeStart() {
            return this.timecodeStart;
        }

        public final void setTimecodeStart(String timecodeStart) {
            this.timecodeStart = timecodeStart;
        }

        @Override
        public final Builder timecodeStart(String timecodeStart) {
            this.timecodeStart = timecodeStart;
            return this;
        }

        public final List<VideoOverlay.Builder> getVideoOverlays() {
            List<VideoOverlay.Builder> result = ___listOfVideoOverlayCopier.copyToBuilder(this.videoOverlays);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVideoOverlays(Collection<VideoOverlay.BuilderImpl> videoOverlays) {
            this.videoOverlays = ___listOfVideoOverlayCopier.copyFromBuilder(videoOverlays);
        }

        @Override
        public final Builder videoOverlays(Collection<VideoOverlay> videoOverlays) {
            this.videoOverlays = ___listOfVideoOverlayCopier.copy(videoOverlays);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoOverlays(VideoOverlay ... videoOverlays) {
            this.videoOverlays(Arrays.asList(videoOverlays));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder videoOverlays(Consumer<VideoOverlay.Builder> ... videoOverlays) {
            this.videoOverlays(Stream.of(videoOverlays).map(c -> (VideoOverlay)((VideoOverlay.Builder)VideoOverlay.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VideoSelector.Builder getVideoSelector() {
            return this.videoSelector != null ? this.videoSelector.toBuilder() : null;
        }

        public final void setVideoSelector(VideoSelector.BuilderImpl videoSelector) {
            this.videoSelector = videoSelector != null ? videoSelector.build() : null;
        }

        @Override
        public final Builder videoSelector(VideoSelector videoSelector) {
            this.videoSelector = videoSelector;
            return this;
        }

        public InputTemplate build() {
            return new InputTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InputTemplate> {
        public Builder advancedInputFilter(String var1);

        public Builder advancedInputFilter(AdvancedInputFilter var1);

        public Builder advancedInputFilterSettings(AdvancedInputFilterSettings var1);

        default public Builder advancedInputFilterSettings(Consumer<AdvancedInputFilterSettings.Builder> advancedInputFilterSettings) {
            return this.advancedInputFilterSettings((AdvancedInputFilterSettings)((AdvancedInputFilterSettings.Builder)AdvancedInputFilterSettings.builder().applyMutation(advancedInputFilterSettings)).build());
        }

        public Builder audioSelectorGroups(Map<String, AudioSelectorGroup> var1);

        public Builder audioSelectors(Map<String, AudioSelector> var1);

        public Builder captionSelectors(Map<String, CaptionSelector> var1);

        public Builder crop(Rectangle var1);

        default public Builder crop(Consumer<Rectangle.Builder> crop) {
            return this.crop((Rectangle)((Rectangle.Builder)Rectangle.builder().applyMutation(crop)).build());
        }

        public Builder deblockFilter(String var1);

        public Builder deblockFilter(InputDeblockFilter var1);

        public Builder denoiseFilter(String var1);

        public Builder denoiseFilter(InputDenoiseFilter var1);

        public Builder dolbyVisionMetadataXml(String var1);

        public Builder filterEnable(String var1);

        public Builder filterEnable(InputFilterEnable var1);

        public Builder filterStrength(Integer var1);

        public Builder imageInserter(ImageInserter var1);

        default public Builder imageInserter(Consumer<ImageInserter.Builder> imageInserter) {
            return this.imageInserter((ImageInserter)((ImageInserter.Builder)ImageInserter.builder().applyMutation(imageInserter)).build());
        }

        public Builder inputClippings(Collection<InputClipping> var1);

        public Builder inputClippings(InputClipping ... var1);

        public Builder inputClippings(Consumer<InputClipping.Builder> ... var1);

        public Builder inputScanType(String var1);

        public Builder inputScanType(InputScanType var1);

        public Builder position(Rectangle var1);

        default public Builder position(Consumer<Rectangle.Builder> position) {
            return this.position((Rectangle)((Rectangle.Builder)Rectangle.builder().applyMutation(position)).build());
        }

        public Builder programNumber(Integer var1);

        public Builder psiControl(String var1);

        public Builder psiControl(InputPsiControl var1);

        public Builder timecodeSource(String var1);

        public Builder timecodeSource(InputTimecodeSource var1);

        public Builder timecodeStart(String var1);

        public Builder videoOverlays(Collection<VideoOverlay> var1);

        public Builder videoOverlays(VideoOverlay ... var1);

        public Builder videoOverlays(Consumer<VideoOverlay.Builder> ... var1);

        public Builder videoSelector(VideoSelector var1);

        default public Builder videoSelector(Consumer<VideoSelector.Builder> videoSelector) {
            return this.videoSelector((VideoSelector)((VideoSelector.Builder)VideoSelector.builder().applyMutation(videoSelector)).build());
        }
    }
}

