/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum HlsKeyProviderType {
    SPEKE("SPEKE"),
    STATIC_KEY("STATIC_KEY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, HlsKeyProviderType> VALUE_MAP;
    private final String value;

    private HlsKeyProviderType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HlsKeyProviderType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HlsKeyProviderType> knownValues() {
        EnumSet<HlsKeyProviderType> knownValues = EnumSet.allOf(HlsKeyProviderType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(HlsKeyProviderType.class, HlsKeyProviderType::toString);
    }
}

