/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.UncompressedFourcc;
import software.amazon.awssdk.services.mediaconvert.model.UncompressedFramerateControl;
import software.amazon.awssdk.services.mediaconvert.model.UncompressedFramerateConversionAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.UncompressedInterlaceMode;
import software.amazon.awssdk.services.mediaconvert.model.UncompressedScanTypeConversionMode;
import software.amazon.awssdk.services.mediaconvert.model.UncompressedSlowPal;
import software.amazon.awssdk.services.mediaconvert.model.UncompressedTelecine;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UncompressedSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UncompressedSettings> {
    private static final SdkField<String> FOURCC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Fourcc").getter(UncompressedSettings.getter(UncompressedSettings::fourccAsString)).setter(UncompressedSettings.setter(Builder::fourcc)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fourcc").build()}).build();
    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateControl").getter(UncompressedSettings.getter(UncompressedSettings::framerateControlAsString)).setter(UncompressedSettings.setter(Builder::framerateControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()}).build();
    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateConversionAlgorithm").getter(UncompressedSettings.getter(UncompressedSettings::framerateConversionAlgorithmAsString)).setter(UncompressedSettings.setter(Builder::framerateConversionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm").build()}).build();
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateDenominator").getter(UncompressedSettings.getter(UncompressedSettings::framerateDenominator)).setter(UncompressedSettings.setter(Builder::framerateDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build()}).build();
    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateNumerator").getter(UncompressedSettings.getter(UncompressedSettings::framerateNumerator)).setter(UncompressedSettings.setter(Builder::framerateNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build()}).build();
    private static final SdkField<String> INTERLACE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterlaceMode").getter(UncompressedSettings.getter(UncompressedSettings::interlaceModeAsString)).setter(UncompressedSettings.setter(Builder::interlaceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interlaceMode").build()}).build();
    private static final SdkField<String> SCAN_TYPE_CONVERSION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanTypeConversionMode").getter(UncompressedSettings.getter(UncompressedSettings::scanTypeConversionModeAsString)).setter(UncompressedSettings.setter(Builder::scanTypeConversionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanTypeConversionMode").build()}).build();
    private static final SdkField<String> SLOW_PAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlowPal").getter(UncompressedSettings.getter(UncompressedSettings::slowPalAsString)).setter(UncompressedSettings.setter(Builder::slowPal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slowPal").build()}).build();
    private static final SdkField<String> TELECINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Telecine").getter(UncompressedSettings.getter(UncompressedSettings::telecineAsString)).setter(UncompressedSettings.setter(Builder::telecine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telecine").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FOURCC_FIELD, FRAMERATE_CONTROL_FIELD, FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, INTERLACE_MODE_FIELD, SCAN_TYPE_CONVERSION_MODE_FIELD, SLOW_PAL_FIELD, TELECINE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fourcc;
    private final String framerateControl;
    private final String framerateConversionAlgorithm;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final String interlaceMode;
    private final String scanTypeConversionMode;
    private final String slowPal;
    private final String telecine;

    private UncompressedSettings(BuilderImpl builder) {
        this.fourcc = builder.fourcc;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.interlaceMode = builder.interlaceMode;
        this.scanTypeConversionMode = builder.scanTypeConversionMode;
        this.slowPal = builder.slowPal;
        this.telecine = builder.telecine;
    }

    public final UncompressedFourcc fourcc() {
        return UncompressedFourcc.fromValue(this.fourcc);
    }

    public final String fourccAsString() {
        return this.fourcc;
    }

    public final UncompressedFramerateControl framerateControl() {
        return UncompressedFramerateControl.fromValue(this.framerateControl);
    }

    public final String framerateControlAsString() {
        return this.framerateControl;
    }

    public final UncompressedFramerateConversionAlgorithm framerateConversionAlgorithm() {
        return UncompressedFramerateConversionAlgorithm.fromValue(this.framerateConversionAlgorithm);
    }

    public final String framerateConversionAlgorithmAsString() {
        return this.framerateConversionAlgorithm;
    }

    public final Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public final Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public final UncompressedInterlaceMode interlaceMode() {
        return UncompressedInterlaceMode.fromValue(this.interlaceMode);
    }

    public final String interlaceModeAsString() {
        return this.interlaceMode;
    }

    public final UncompressedScanTypeConversionMode scanTypeConversionMode() {
        return UncompressedScanTypeConversionMode.fromValue(this.scanTypeConversionMode);
    }

    public final String scanTypeConversionModeAsString() {
        return this.scanTypeConversionMode;
    }

    public final UncompressedSlowPal slowPal() {
        return UncompressedSlowPal.fromValue(this.slowPal);
    }

    public final String slowPalAsString() {
        return this.slowPal;
    }

    public final UncompressedTelecine telecine() {
        return UncompressedTelecine.fromValue(this.telecine);
    }

    public final String telecineAsString() {
        return this.telecine;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fourccAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanTypeConversionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.telecineAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UncompressedSettings)) {
            return false;
        }
        UncompressedSettings other = (UncompressedSettings)obj;
        return Objects.equals(this.fourccAsString(), other.fourccAsString()) && Objects.equals(this.framerateControlAsString(), other.framerateControlAsString()) && Objects.equals(this.framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.interlaceModeAsString(), other.interlaceModeAsString()) && Objects.equals(this.scanTypeConversionModeAsString(), other.scanTypeConversionModeAsString()) && Objects.equals(this.slowPalAsString(), other.slowPalAsString()) && Objects.equals(this.telecineAsString(), other.telecineAsString());
    }

    public final String toString() {
        return ToString.builder((String)"UncompressedSettings").add("Fourcc", (Object)this.fourccAsString()).add("FramerateControl", (Object)this.framerateControlAsString()).add("FramerateConversionAlgorithm", (Object)this.framerateConversionAlgorithmAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("InterlaceMode", (Object)this.interlaceModeAsString()).add("ScanTypeConversionMode", (Object)this.scanTypeConversionModeAsString()).add("SlowPal", (Object)this.slowPalAsString()).add("Telecine", (Object)this.telecineAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Fourcc": {
                return Optional.ofNullable(clazz.cast(this.fourccAsString()));
            }
            case "FramerateControl": {
                return Optional.ofNullable(clazz.cast(this.framerateControlAsString()));
            }
            case "FramerateConversionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.framerateConversionAlgorithmAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "InterlaceMode": {
                return Optional.ofNullable(clazz.cast(this.interlaceModeAsString()));
            }
            case "ScanTypeConversionMode": {
                return Optional.ofNullable(clazz.cast(this.scanTypeConversionModeAsString()));
            }
            case "SlowPal": {
                return Optional.ofNullable(clazz.cast(this.slowPalAsString()));
            }
            case "Telecine": {
                return Optional.ofNullable(clazz.cast(this.telecineAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UncompressedSettings, T> g) {
        return obj -> g.apply((UncompressedSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fourcc;
        private String framerateControl;
        private String framerateConversionAlgorithm;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private String interlaceMode;
        private String scanTypeConversionMode;
        private String slowPal;
        private String telecine;

        private BuilderImpl() {
        }

        private BuilderImpl(UncompressedSettings model) {
            this.fourcc(model.fourcc);
            this.framerateControl(model.framerateControl);
            this.framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.interlaceMode(model.interlaceMode);
            this.scanTypeConversionMode(model.scanTypeConversionMode);
            this.slowPal(model.slowPal);
            this.telecine(model.telecine);
        }

        public final String getFourcc() {
            return this.fourcc;
        }

        public final void setFourcc(String fourcc) {
            this.fourcc = fourcc;
        }

        @Override
        public final Builder fourcc(String fourcc) {
            this.fourcc = fourcc;
            return this;
        }

        @Override
        public final Builder fourcc(UncompressedFourcc fourcc) {
            this.fourcc(fourcc == null ? null : fourcc.toString());
            return this;
        }

        public final String getFramerateControl() {
            return this.framerateControl;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(UncompressedFramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final String getFramerateConversionAlgorithm() {
            return this.framerateConversionAlgorithm;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(UncompressedFramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm.toString());
            return this;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final String getInterlaceMode() {
            return this.interlaceMode;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(UncompressedInterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode == null ? null : interlaceMode.toString());
            return this;
        }

        public final String getScanTypeConversionMode() {
            return this.scanTypeConversionMode;
        }

        public final void setScanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
        }

        @Override
        public final Builder scanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
            return this;
        }

        @Override
        public final Builder scanTypeConversionMode(UncompressedScanTypeConversionMode scanTypeConversionMode) {
            this.scanTypeConversionMode(scanTypeConversionMode == null ? null : scanTypeConversionMode.toString());
            return this;
        }

        public final String getSlowPal() {
            return this.slowPal;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(UncompressedSlowPal slowPal) {
            this.slowPal(slowPal == null ? null : slowPal.toString());
            return this;
        }

        public final String getTelecine() {
            return this.telecine;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(UncompressedTelecine telecine) {
            this.telecine(telecine == null ? null : telecine.toString());
            return this;
        }

        public UncompressedSettings build() {
            return new UncompressedSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UncompressedSettings> {
        public Builder fourcc(String var1);

        public Builder fourcc(UncompressedFourcc var1);

        public Builder framerateControl(String var1);

        public Builder framerateControl(UncompressedFramerateControl var1);

        public Builder framerateConversionAlgorithm(String var1);

        public Builder framerateConversionAlgorithm(UncompressedFramerateConversionAlgorithm var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder interlaceMode(String var1);

        public Builder interlaceMode(UncompressedInterlaceMode var1);

        public Builder scanTypeConversionMode(String var1);

        public Builder scanTypeConversionMode(UncompressedScanTypeConversionMode var1);

        public Builder slowPal(String var1);

        public Builder slowPal(UncompressedSlowPal var1);

        public Builder telecine(String var1);

        public Builder telecine(UncompressedTelecine var1);
    }
}

