/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum VideoCodec {
    AV1("AV1"),
    AVC_INTRA("AVC_INTRA"),
    FRAME_CAPTURE("FRAME_CAPTURE"),
    H_264("H_264"),
    H_265("H_265"),
    MPEG2("MPEG2"),
    PASSTHROUGH("PASSTHROUGH"),
    PRORES("PRORES"),
    UNCOMPRESSED("UNCOMPRESSED"),
    VC3("VC3"),
    VP8("VP8"),
    VP9("VP9"),
    XAVC("XAVC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, VideoCodec> VALUE_MAP;
    private final String value;

    private VideoCodec(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static VideoCodec fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<VideoCodec> knownValues() {
        EnumSet<VideoCodec> knownValues = EnumSet.allOf(VideoCodec.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(VideoCodec.class, VideoCodec::toString);
    }
}

