/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Ignore this setting unless this input is a QuickTime animation with an alpha channel. Use this setting to create
 * separate Key and Fill outputs. In each output, specify which part of the input MediaConvert uses. Leave this setting
 * at the default value DISCARD to delete the alpha channel and preserve the video. Set it to REMAP_TO_LUMA to delete
 * the video and map the alpha channel to the luma channel of your outputs.
 */
@Generated("software.amazon.awssdk:codegen")
public enum AlphaBehavior {
    DISCARD("DISCARD"),

    REMAP_TO_LUMA("REMAP_TO_LUMA"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AlphaBehavior> VALUE_MAP = EnumUtils.uniqueIndex(AlphaBehavior.class,
            AlphaBehavior::toString);

    private final String value;

    private AlphaBehavior(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return AlphaBehavior corresponding to the value
     */
    public static AlphaBehavior fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link AlphaBehavior}s
     */
    public static Set<AlphaBehavior> knownValues() {
        Set<AlphaBehavior> knownValues = EnumSet.allOf(AlphaBehavior.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
