/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediaconvert.DefaultMediaConvertBaseClientBuilder;
import software.amazon.awssdk.services.mediaconvert.DefaultMediaConvertClient;
import software.amazon.awssdk.services.mediaconvert.MediaConvertClient;
import software.amazon.awssdk.services.mediaconvert.MediaConvertClientBuilder;
import software.amazon.awssdk.services.mediaconvert.MediaConvertServiceClientConfiguration;
import software.amazon.awssdk.services.mediaconvert.endpoints.MediaConvertEndpointProvider;

@SdkInternalApi
final class DefaultMediaConvertClientBuilder
extends DefaultMediaConvertBaseClientBuilder<MediaConvertClientBuilder, MediaConvertClient>
implements MediaConvertClientBuilder {
    DefaultMediaConvertClientBuilder() {
    }

    @Override
    public DefaultMediaConvertClientBuilder endpointProvider(MediaConvertEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaConvertClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMediaConvertClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        MediaConvertServiceClientConfiguration serviceClientConfiguration = MediaConvertServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultMediaConvertClient(serviceClientConfiguration, clientConfiguration);
    }
}

