/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DolbyVisionMapping {
    HDR10_NOMAP("HDR10_NOMAP"),
    HDR10_1000("HDR10_1000"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DolbyVisionMapping> VALUE_MAP;
    private final String value;

    private DolbyVisionMapping(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DolbyVisionMapping fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DolbyVisionMapping> knownValues() {
        EnumSet<DolbyVisionMapping> knownValues = EnumSet.allOf(DolbyVisionMapping.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DolbyVisionMapping.class, DolbyVisionMapping::toString);
    }
}

