/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MxfProfile {
    D_10("D_10"),
    XDCAM("XDCAM"),
    OP1_A("OP1A"),
    XAVC("XAVC"),
    XDCAM_RDD9("XDCAM_RDD9"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MxfProfile> VALUE_MAP;
    private final String value;

    private MxfProfile(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MxfProfile fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MxfProfile> knownValues() {
        EnumSet<MxfProfile> knownValues = EnumSet.allOf(MxfProfile.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MxfProfile.class, MxfProfile::toString);
    }
}

