/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Use this setting only when your output video stream has B-frames, which causes the initial presentation time stamp
 * (PTS) to be offset from the initial decode time stamp (DTS). Specify how MediaConvert handles PTS when writing time
 * stamps in output DASH manifests. Choose Match initial PTS when you want MediaConvert to use the initial PTS as the
 * first time stamp in the manifest. Choose Zero-based to have MediaConvert ignore the initial PTS in the video stream
 * and instead write the initial time stamp as zero in the manifest. For outputs that don't have B-frames, the time
 * stamps in your DASH manifests start at zero regardless of your choice here.
 */
@Generated("software.amazon.awssdk:codegen")
public enum DashIsoPtsOffsetHandlingForBFrames {
    ZERO_BASED("ZERO_BASED"),

    MATCH_INITIAL_PTS("MATCH_INITIAL_PTS"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DashIsoPtsOffsetHandlingForBFrames> VALUE_MAP = EnumUtils.uniqueIndex(
            DashIsoPtsOffsetHandlingForBFrames.class, DashIsoPtsOffsetHandlingForBFrames::toString);

    private final String value;

    private DashIsoPtsOffsetHandlingForBFrames(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return DashIsoPtsOffsetHandlingForBFrames corresponding to the value
     */
    public static DashIsoPtsOffsetHandlingForBFrames fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link DashIsoPtsOffsetHandlingForBFrames}s
     */
    public static Set<DashIsoPtsOffsetHandlingForBFrames> knownValues() {
        Set<DashIsoPtsOffsetHandlingForBFrames> knownValues = EnumSet.allOf(DashIsoPtsOffsetHandlingForBFrames.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
