/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * Specify whether this output's video uses the D10 syntax. Keep the default value to not use the syntax. Related
 * settings: When you choose D10 (D_10) for your MXF profile (profile), you must also set this value to D10 (D_10).
 */
@Generated("software.amazon.awssdk:codegen")
public enum Mpeg2Syntax {
    DEFAULT("DEFAULT"),

    D_10("D_10"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Mpeg2Syntax> VALUE_MAP = EnumUtils.uniqueIndex(Mpeg2Syntax.class, Mpeg2Syntax::toString);

    private final String value;

    private Mpeg2Syntax(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Mpeg2Syntax corresponding to the value
     */
    public static Mpeg2Syntax fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Mpeg2Syntax}s
     */
    public static Set<Mpeg2Syntax> knownValues() {
        Set<Mpeg2Syntax> knownValues = EnumSet.allOf(Mpeg2Syntax.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
