/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.mediaconvert.DefaultMediaConvertAsyncClient;
import software.amazon.awssdk.services.mediaconvert.DefaultMediaConvertBaseClientBuilder;
import software.amazon.awssdk.services.mediaconvert.MediaConvertAsyncClient;
import software.amazon.awssdk.services.mediaconvert.MediaConvertAsyncClientBuilder;
import software.amazon.awssdk.services.mediaconvert.MediaConvertServiceClientConfiguration;
import software.amazon.awssdk.services.mediaconvert.endpoints.MediaConvertEndpointProvider;

@SdkInternalApi
final class DefaultMediaConvertAsyncClientBuilder
extends DefaultMediaConvertBaseClientBuilder<MediaConvertAsyncClientBuilder, MediaConvertAsyncClient>
implements MediaConvertAsyncClientBuilder {
    DefaultMediaConvertAsyncClientBuilder() {
    }

    @Override
    public DefaultMediaConvertAsyncClientBuilder endpointProvider(MediaConvertEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MediaConvertAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultMediaConvertAsyncClientBuilder.validateClientOptions(clientConfiguration);
        MediaConvertServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultMediaConvertAsyncClient client = new DefaultMediaConvertAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private MediaConvertServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return MediaConvertServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

