/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.S3DestinationAccessControl;
import software.amazon.awssdk.services.mediaconvert.model.S3EncryptionSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3DestinationSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3DestinationSettings> {
    private static final SdkField<S3DestinationAccessControl> ACCESS_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessControl").getter(S3DestinationSettings.getter(S3DestinationSettings::accessControl)).setter(S3DestinationSettings.setter(Builder::accessControl)).constructor(S3DestinationAccessControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessControl").build()}).build();
    private static final SdkField<S3EncryptionSettings> ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Encryption").getter(S3DestinationSettings.getter(S3DestinationSettings::encryption)).setter(S3DestinationSettings.setter(Builder::encryption)).constructor(S3EncryptionSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_CONTROL_FIELD, ENCRYPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final S3DestinationAccessControl accessControl;
    private final S3EncryptionSettings encryption;

    private S3DestinationSettings(BuilderImpl builder) {
        this.accessControl = builder.accessControl;
        this.encryption = builder.encryption;
    }

    public final S3DestinationAccessControl accessControl() {
        return this.accessControl;
    }

    public final S3EncryptionSettings encryption() {
        return this.encryption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessControl());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryption());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DestinationSettings)) {
            return false;
        }
        S3DestinationSettings other = (S3DestinationSettings)obj;
        return Objects.equals(this.accessControl(), other.accessControl()) && Objects.equals(this.encryption(), other.encryption());
    }

    public final String toString() {
        return ToString.builder((String)"S3DestinationSettings").add("AccessControl", (Object)this.accessControl()).add("Encryption", (Object)this.encryption()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessControl": {
                return Optional.ofNullable(clazz.cast(this.accessControl()));
            }
            case "Encryption": {
                return Optional.ofNullable(clazz.cast(this.encryption()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3DestinationSettings, T> g) {
        return obj -> g.apply((S3DestinationSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private S3DestinationAccessControl accessControl;
        private S3EncryptionSettings encryption;

        private BuilderImpl() {
        }

        private BuilderImpl(S3DestinationSettings model) {
            this.accessControl(model.accessControl);
            this.encryption(model.encryption);
        }

        public final S3DestinationAccessControl.Builder getAccessControl() {
            return this.accessControl != null ? this.accessControl.toBuilder() : null;
        }

        public final void setAccessControl(S3DestinationAccessControl.BuilderImpl accessControl) {
            this.accessControl = accessControl != null ? accessControl.build() : null;
        }

        @Override
        public final Builder accessControl(S3DestinationAccessControl accessControl) {
            this.accessControl = accessControl;
            return this;
        }

        public final S3EncryptionSettings.Builder getEncryption() {
            return this.encryption != null ? this.encryption.toBuilder() : null;
        }

        public final void setEncryption(S3EncryptionSettings.BuilderImpl encryption) {
            this.encryption = encryption != null ? encryption.build() : null;
        }

        @Override
        public final Builder encryption(S3EncryptionSettings encryption) {
            this.encryption = encryption;
            return this;
        }

        public S3DestinationSettings build() {
            return new S3DestinationSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3DestinationSettings> {
        public Builder accessControl(S3DestinationAccessControl var1);

        default public Builder accessControl(Consumer<S3DestinationAccessControl.Builder> accessControl) {
            return this.accessControl((S3DestinationAccessControl)((S3DestinationAccessControl.Builder)S3DestinationAccessControl.builder().applyMutation(accessControl)).build());
        }

        public Builder encryption(S3EncryptionSettings var1);

        default public Builder encryption(Consumer<S3EncryptionSettings.Builder> encryption) {
            return this.encryption((S3EncryptionSettings)((S3EncryptionSettings.Builder)S3EncryptionSettings.builder().applyMutation(encryption)).build());
        }
    }
}

