/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.MpdAccessibilityCaptionHints;
import software.amazon.awssdk.services.mediaconvert.model.MpdAudioDuration;
import software.amazon.awssdk.services.mediaconvert.model.MpdCaptionContainerType;
import software.amazon.awssdk.services.mediaconvert.model.MpdScte35Esam;
import software.amazon.awssdk.services.mediaconvert.model.MpdScte35Source;
import software.amazon.awssdk.services.mediaconvert.model.MpdTimedMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MpdSettings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MpdSettings> {
    private static final SdkField<String> ACCESSIBILITY_CAPTION_HINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessibilityCaptionHints").getter(MpdSettings.getter(MpdSettings::accessibilityCaptionHintsAsString)).setter(MpdSettings.setter(Builder::accessibilityCaptionHints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessibilityCaptionHints").build()}).build();
    private static final SdkField<String> AUDIO_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AudioDuration").getter(MpdSettings.getter(MpdSettings::audioDurationAsString)).setter(MpdSettings.setter(Builder::audioDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioDuration").build()}).build();
    private static final SdkField<String> CAPTION_CONTAINER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CaptionContainerType").getter(MpdSettings.getter(MpdSettings::captionContainerTypeAsString)).setter(MpdSettings.setter(Builder::captionContainerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captionContainerType").build()}).build();
    private static final SdkField<String> SCTE35_ESAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scte35Esam").getter(MpdSettings.getter(MpdSettings::scte35EsamAsString)).setter(MpdSettings.setter(Builder::scte35Esam)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Esam").build()}).build();
    private static final SdkField<String> SCTE35_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Scte35Source").getter(MpdSettings.getter(MpdSettings::scte35SourceAsString)).setter(MpdSettings.setter(Builder::scte35Source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scte35Source").build()}).build();
    private static final SdkField<String> TIMED_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TimedMetadata").getter(MpdSettings.getter(MpdSettings::timedMetadataAsString)).setter(MpdSettings.setter(Builder::timedMetadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timedMetadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESSIBILITY_CAPTION_HINTS_FIELD, AUDIO_DURATION_FIELD, CAPTION_CONTAINER_TYPE_FIELD, SCTE35_ESAM_FIELD, SCTE35_SOURCE_FIELD, TIMED_METADATA_FIELD));
    private static final long serialVersionUID = 1L;
    private final String accessibilityCaptionHints;
    private final String audioDuration;
    private final String captionContainerType;
    private final String scte35Esam;
    private final String scte35Source;
    private final String timedMetadata;

    private MpdSettings(BuilderImpl builder) {
        this.accessibilityCaptionHints = builder.accessibilityCaptionHints;
        this.audioDuration = builder.audioDuration;
        this.captionContainerType = builder.captionContainerType;
        this.scte35Esam = builder.scte35Esam;
        this.scte35Source = builder.scte35Source;
        this.timedMetadata = builder.timedMetadata;
    }

    public final MpdAccessibilityCaptionHints accessibilityCaptionHints() {
        return MpdAccessibilityCaptionHints.fromValue(this.accessibilityCaptionHints);
    }

    public final String accessibilityCaptionHintsAsString() {
        return this.accessibilityCaptionHints;
    }

    public final MpdAudioDuration audioDuration() {
        return MpdAudioDuration.fromValue(this.audioDuration);
    }

    public final String audioDurationAsString() {
        return this.audioDuration;
    }

    public final MpdCaptionContainerType captionContainerType() {
        return MpdCaptionContainerType.fromValue(this.captionContainerType);
    }

    public final String captionContainerTypeAsString() {
        return this.captionContainerType;
    }

    public final MpdScte35Esam scte35Esam() {
        return MpdScte35Esam.fromValue(this.scte35Esam);
    }

    public final String scte35EsamAsString() {
        return this.scte35Esam;
    }

    public final MpdScte35Source scte35Source() {
        return MpdScte35Source.fromValue(this.scte35Source);
    }

    public final String scte35SourceAsString() {
        return this.scte35Source;
    }

    public final MpdTimedMetadata timedMetadata() {
        return MpdTimedMetadata.fromValue(this.timedMetadata);
    }

    public final String timedMetadataAsString() {
        return this.timedMetadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessibilityCaptionHintsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.audioDurationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.captionContainerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35EsamAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scte35SourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timedMetadataAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MpdSettings)) {
            return false;
        }
        MpdSettings other = (MpdSettings)obj;
        return Objects.equals(this.accessibilityCaptionHintsAsString(), other.accessibilityCaptionHintsAsString()) && Objects.equals(this.audioDurationAsString(), other.audioDurationAsString()) && Objects.equals(this.captionContainerTypeAsString(), other.captionContainerTypeAsString()) && Objects.equals(this.scte35EsamAsString(), other.scte35EsamAsString()) && Objects.equals(this.scte35SourceAsString(), other.scte35SourceAsString()) && Objects.equals(this.timedMetadataAsString(), other.timedMetadataAsString());
    }

    public final String toString() {
        return ToString.builder((String)"MpdSettings").add("AccessibilityCaptionHints", (Object)this.accessibilityCaptionHintsAsString()).add("AudioDuration", (Object)this.audioDurationAsString()).add("CaptionContainerType", (Object)this.captionContainerTypeAsString()).add("Scte35Esam", (Object)this.scte35EsamAsString()).add("Scte35Source", (Object)this.scte35SourceAsString()).add("TimedMetadata", (Object)this.timedMetadataAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessibilityCaptionHints": {
                return Optional.ofNullable(clazz.cast(this.accessibilityCaptionHintsAsString()));
            }
            case "AudioDuration": {
                return Optional.ofNullable(clazz.cast(this.audioDurationAsString()));
            }
            case "CaptionContainerType": {
                return Optional.ofNullable(clazz.cast(this.captionContainerTypeAsString()));
            }
            case "Scte35Esam": {
                return Optional.ofNullable(clazz.cast(this.scte35EsamAsString()));
            }
            case "Scte35Source": {
                return Optional.ofNullable(clazz.cast(this.scte35SourceAsString()));
            }
            case "TimedMetadata": {
                return Optional.ofNullable(clazz.cast(this.timedMetadataAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MpdSettings, T> g) {
        return obj -> g.apply((MpdSettings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessibilityCaptionHints;
        private String audioDuration;
        private String captionContainerType;
        private String scte35Esam;
        private String scte35Source;
        private String timedMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(MpdSettings model) {
            this.accessibilityCaptionHints(model.accessibilityCaptionHints);
            this.audioDuration(model.audioDuration);
            this.captionContainerType(model.captionContainerType);
            this.scte35Esam(model.scte35Esam);
            this.scte35Source(model.scte35Source);
            this.timedMetadata(model.timedMetadata);
        }

        public final String getAccessibilityCaptionHints() {
            return this.accessibilityCaptionHints;
        }

        public final void setAccessibilityCaptionHints(String accessibilityCaptionHints) {
            this.accessibilityCaptionHints = accessibilityCaptionHints;
        }

        @Override
        public final Builder accessibilityCaptionHints(String accessibilityCaptionHints) {
            this.accessibilityCaptionHints = accessibilityCaptionHints;
            return this;
        }

        @Override
        public final Builder accessibilityCaptionHints(MpdAccessibilityCaptionHints accessibilityCaptionHints) {
            this.accessibilityCaptionHints(accessibilityCaptionHints == null ? null : accessibilityCaptionHints.toString());
            return this;
        }

        public final String getAudioDuration() {
            return this.audioDuration;
        }

        public final void setAudioDuration(String audioDuration) {
            this.audioDuration = audioDuration;
        }

        @Override
        public final Builder audioDuration(String audioDuration) {
            this.audioDuration = audioDuration;
            return this;
        }

        @Override
        public final Builder audioDuration(MpdAudioDuration audioDuration) {
            this.audioDuration(audioDuration == null ? null : audioDuration.toString());
            return this;
        }

        public final String getCaptionContainerType() {
            return this.captionContainerType;
        }

        public final void setCaptionContainerType(String captionContainerType) {
            this.captionContainerType = captionContainerType;
        }

        @Override
        public final Builder captionContainerType(String captionContainerType) {
            this.captionContainerType = captionContainerType;
            return this;
        }

        @Override
        public final Builder captionContainerType(MpdCaptionContainerType captionContainerType) {
            this.captionContainerType(captionContainerType == null ? null : captionContainerType.toString());
            return this;
        }

        public final String getScte35Esam() {
            return this.scte35Esam;
        }

        public final void setScte35Esam(String scte35Esam) {
            this.scte35Esam = scte35Esam;
        }

        @Override
        public final Builder scte35Esam(String scte35Esam) {
            this.scte35Esam = scte35Esam;
            return this;
        }

        @Override
        public final Builder scte35Esam(MpdScte35Esam scte35Esam) {
            this.scte35Esam(scte35Esam == null ? null : scte35Esam.toString());
            return this;
        }

        public final String getScte35Source() {
            return this.scte35Source;
        }

        public final void setScte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
        }

        @Override
        public final Builder scte35Source(String scte35Source) {
            this.scte35Source = scte35Source;
            return this;
        }

        @Override
        public final Builder scte35Source(MpdScte35Source scte35Source) {
            this.scte35Source(scte35Source == null ? null : scte35Source.toString());
            return this;
        }

        public final String getTimedMetadata() {
            return this.timedMetadata;
        }

        public final void setTimedMetadata(String timedMetadata) {
            this.timedMetadata = timedMetadata;
        }

        @Override
        public final Builder timedMetadata(String timedMetadata) {
            this.timedMetadata = timedMetadata;
            return this;
        }

        @Override
        public final Builder timedMetadata(MpdTimedMetadata timedMetadata) {
            this.timedMetadata(timedMetadata == null ? null : timedMetadata.toString());
            return this;
        }

        public MpdSettings build() {
            return new MpdSettings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MpdSettings> {
        public Builder accessibilityCaptionHints(String var1);

        public Builder accessibilityCaptionHints(MpdAccessibilityCaptionHints var1);

        public Builder audioDuration(String var1);

        public Builder audioDuration(MpdAudioDuration var1);

        public Builder captionContainerType(String var1);

        public Builder captionContainerType(MpdCaptionContainerType var1);

        public Builder scte35Esam(String var1);

        public Builder scte35Esam(MpdScte35Esam var1);

        public Builder scte35Source(String var1);

        public Builder scte35Source(MpdScte35Source var1);

        public Builder timedMetadata(String var1);

        public Builder timedMetadata(MpdTimedMetadata var1);
    }
}

