/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum H264SceneChangeDetect {
    DISABLED("DISABLED"),
    ENABLED("ENABLED"),
    TRANSITION_DETECTION("TRANSITION_DETECTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, H264SceneChangeDetect> VALUE_MAP;
    private final String value;

    private H264SceneChangeDetect(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static H264SceneChangeDetect fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<H264SceneChangeDetect> knownValues() {
        EnumSet<H264SceneChangeDetect> knownValues = EnumSet.allOf(H264SceneChangeDetect.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(H264SceneChangeDetect.class, H264SceneChangeDetect::toString);
    }
}

