/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mediaconvert.model.H264AdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.H264CodecLevel;
import software.amazon.awssdk.services.mediaconvert.model.H264CodecProfile;
import software.amazon.awssdk.services.mediaconvert.model.H264DynamicSubGop;
import software.amazon.awssdk.services.mediaconvert.model.H264EntropyEncoding;
import software.amazon.awssdk.services.mediaconvert.model.H264FieldEncoding;
import software.amazon.awssdk.services.mediaconvert.model.H264FlickerAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.H264FramerateControl;
import software.amazon.awssdk.services.mediaconvert.model.H264FramerateConversionAlgorithm;
import software.amazon.awssdk.services.mediaconvert.model.H264GopBReference;
import software.amazon.awssdk.services.mediaconvert.model.H264GopSizeUnits;
import software.amazon.awssdk.services.mediaconvert.model.H264InterlaceMode;
import software.amazon.awssdk.services.mediaconvert.model.H264ParControl;
import software.amazon.awssdk.services.mediaconvert.model.H264QualityTuningLevel;
import software.amazon.awssdk.services.mediaconvert.model.H264QvbrSettings;
import software.amazon.awssdk.services.mediaconvert.model.H264RateControlMode;
import software.amazon.awssdk.services.mediaconvert.model.H264RepeatPps;
import software.amazon.awssdk.services.mediaconvert.model.H264ScanTypeConversionMode;
import software.amazon.awssdk.services.mediaconvert.model.H264SceneChangeDetect;
import software.amazon.awssdk.services.mediaconvert.model.H264SlowPal;
import software.amazon.awssdk.services.mediaconvert.model.H264SpatialAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.H264Syntax;
import software.amazon.awssdk.services.mediaconvert.model.H264Telecine;
import software.amazon.awssdk.services.mediaconvert.model.H264TemporalAdaptiveQuantization;
import software.amazon.awssdk.services.mediaconvert.model.H264UnregisteredSeiTimecode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class H264Settings
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, H264Settings> {
    private static final SdkField<String> ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdaptiveQuantization").getter(H264Settings.getter(H264Settings::adaptiveQuantizationAsString)).setter(H264Settings.setter(Builder::adaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adaptiveQuantization").build()}).build();
    private static final SdkField<Integer> BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Bitrate").getter(H264Settings.getter(H264Settings::bitrate)).setter(H264Settings.setter(Builder::bitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitrate").build()}).build();
    private static final SdkField<String> CODEC_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodecLevel").getter(H264Settings.getter(H264Settings::codecLevelAsString)).setter(H264Settings.setter(Builder::codecLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecLevel").build()}).build();
    private static final SdkField<String> CODEC_PROFILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CodecProfile").getter(H264Settings.getter(H264Settings::codecProfileAsString)).setter(H264Settings.setter(Builder::codecProfile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codecProfile").build()}).build();
    private static final SdkField<String> DYNAMIC_SUB_GOP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DynamicSubGop").getter(H264Settings.getter(H264Settings::dynamicSubGopAsString)).setter(H264Settings.setter(Builder::dynamicSubGop)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dynamicSubGop").build()}).build();
    private static final SdkField<String> ENTROPY_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EntropyEncoding").getter(H264Settings.getter(H264Settings::entropyEncodingAsString)).setter(H264Settings.setter(Builder::entropyEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entropyEncoding").build()}).build();
    private static final SdkField<String> FIELD_ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldEncoding").getter(H264Settings.getter(H264Settings::fieldEncodingAsString)).setter(H264Settings.setter(Builder::fieldEncoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldEncoding").build()}).build();
    private static final SdkField<String> FLICKER_ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlickerAdaptiveQuantization").getter(H264Settings.getter(H264Settings::flickerAdaptiveQuantizationAsString)).setter(H264Settings.setter(Builder::flickerAdaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flickerAdaptiveQuantization").build()}).build();
    private static final SdkField<String> FRAMERATE_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateControl").getter(H264Settings.getter(H264Settings::framerateControlAsString)).setter(H264Settings.setter(Builder::framerateControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateControl").build()}).build();
    private static final SdkField<String> FRAMERATE_CONVERSION_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FramerateConversionAlgorithm").getter(H264Settings.getter(H264Settings::framerateConversionAlgorithmAsString)).setter(H264Settings.setter(Builder::framerateConversionAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateConversionAlgorithm").build()}).build();
    private static final SdkField<Integer> FRAMERATE_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateDenominator").getter(H264Settings.getter(H264Settings::framerateDenominator)).setter(H264Settings.setter(Builder::framerateDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateDenominator").build()}).build();
    private static final SdkField<Integer> FRAMERATE_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FramerateNumerator").getter(H264Settings.getter(H264Settings::framerateNumerator)).setter(H264Settings.setter(Builder::framerateNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("framerateNumerator").build()}).build();
    private static final SdkField<String> GOP_B_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GopBReference").getter(H264Settings.getter(H264Settings::gopBReferenceAsString)).setter(H264Settings.setter(Builder::gopBReference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopBReference").build()}).build();
    private static final SdkField<Integer> GOP_CLOSED_CADENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("GopClosedCadence").getter(H264Settings.getter(H264Settings::gopClosedCadence)).setter(H264Settings.setter(Builder::gopClosedCadence)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopClosedCadence").build()}).build();
    private static final SdkField<Double> GOP_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("GopSize").getter(H264Settings.getter(H264Settings::gopSize)).setter(H264Settings.setter(Builder::gopSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSize").build()}).build();
    private static final SdkField<String> GOP_SIZE_UNITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GopSizeUnits").getter(H264Settings.getter(H264Settings::gopSizeUnitsAsString)).setter(H264Settings.setter(Builder::gopSizeUnits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gopSizeUnits").build()}).build();
    private static final SdkField<Integer> HRD_BUFFER_INITIAL_FILL_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HrdBufferInitialFillPercentage").getter(H264Settings.getter(H264Settings::hrdBufferInitialFillPercentage)).setter(H264Settings.setter(Builder::hrdBufferInitialFillPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferInitialFillPercentage").build()}).build();
    private static final SdkField<Integer> HRD_BUFFER_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("HrdBufferSize").getter(H264Settings.getter(H264Settings::hrdBufferSize)).setter(H264Settings.setter(Builder::hrdBufferSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hrdBufferSize").build()}).build();
    private static final SdkField<String> INTERLACE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterlaceMode").getter(H264Settings.getter(H264Settings::interlaceModeAsString)).setter(H264Settings.setter(Builder::interlaceMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interlaceMode").build()}).build();
    private static final SdkField<Integer> MAX_BITRATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxBitrate").getter(H264Settings.getter(H264Settings::maxBitrate)).setter(H264Settings.setter(Builder::maxBitrate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBitrate").build()}).build();
    private static final SdkField<Integer> MIN_I_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinIInterval").getter(H264Settings.getter(H264Settings::minIInterval)).setter(H264Settings.setter(Builder::minIInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minIInterval").build()}).build();
    private static final SdkField<Integer> NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberBFramesBetweenReferenceFrames").getter(H264Settings.getter(H264Settings::numberBFramesBetweenReferenceFrames)).setter(H264Settings.setter(Builder::numberBFramesBetweenReferenceFrames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberBFramesBetweenReferenceFrames").build()}).build();
    private static final SdkField<Integer> NUMBER_REFERENCE_FRAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberReferenceFrames").getter(H264Settings.getter(H264Settings::numberReferenceFrames)).setter(H264Settings.setter(Builder::numberReferenceFrames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberReferenceFrames").build()}).build();
    private static final SdkField<String> PAR_CONTROL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParControl").getter(H264Settings.getter(H264Settings::parControlAsString)).setter(H264Settings.setter(Builder::parControl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parControl").build()}).build();
    private static final SdkField<Integer> PAR_DENOMINATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParDenominator").getter(H264Settings.getter(H264Settings::parDenominator)).setter(H264Settings.setter(Builder::parDenominator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parDenominator").build()}).build();
    private static final SdkField<Integer> PAR_NUMERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ParNumerator").getter(H264Settings.getter(H264Settings::parNumerator)).setter(H264Settings.setter(Builder::parNumerator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parNumerator").build()}).build();
    private static final SdkField<String> QUALITY_TUNING_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("QualityTuningLevel").getter(H264Settings.getter(H264Settings::qualityTuningLevelAsString)).setter(H264Settings.setter(Builder::qualityTuningLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qualityTuningLevel").build()}).build();
    private static final SdkField<H264QvbrSettings> QVBR_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QvbrSettings").getter(H264Settings.getter(H264Settings::qvbrSettings)).setter(H264Settings.setter(Builder::qvbrSettings)).constructor(H264QvbrSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qvbrSettings").build()}).build();
    private static final SdkField<String> RATE_CONTROL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RateControlMode").getter(H264Settings.getter(H264Settings::rateControlModeAsString)).setter(H264Settings.setter(Builder::rateControlMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateControlMode").build()}).build();
    private static final SdkField<String> REPEAT_PPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RepeatPps").getter(H264Settings.getter(H264Settings::repeatPpsAsString)).setter(H264Settings.setter(Builder::repeatPps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repeatPps").build()}).build();
    private static final SdkField<String> SCAN_TYPE_CONVERSION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanTypeConversionMode").getter(H264Settings.getter(H264Settings::scanTypeConversionModeAsString)).setter(H264Settings.setter(Builder::scanTypeConversionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanTypeConversionMode").build()}).build();
    private static final SdkField<String> SCENE_CHANGE_DETECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SceneChangeDetect").getter(H264Settings.getter(H264Settings::sceneChangeDetectAsString)).setter(H264Settings.setter(Builder::sceneChangeDetect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneChangeDetect").build()}).build();
    private static final SdkField<Integer> SLICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Slices").getter(H264Settings.getter(H264Settings::slices)).setter(H264Settings.setter(Builder::slices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slices").build()}).build();
    private static final SdkField<String> SLOW_PAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlowPal").getter(H264Settings.getter(H264Settings::slowPalAsString)).setter(H264Settings.setter(Builder::slowPal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slowPal").build()}).build();
    private static final SdkField<Integer> SOFTNESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Softness").getter(H264Settings.getter(H264Settings::softness)).setter(H264Settings.setter(Builder::softness)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softness").build()}).build();
    private static final SdkField<String> SPATIAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpatialAdaptiveQuantization").getter(H264Settings.getter(H264Settings::spatialAdaptiveQuantizationAsString)).setter(H264Settings.setter(Builder::spatialAdaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spatialAdaptiveQuantization").build()}).build();
    private static final SdkField<String> SYNTAX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Syntax").getter(H264Settings.getter(H264Settings::syntaxAsString)).setter(H264Settings.setter(Builder::syntax)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syntax").build()}).build();
    private static final SdkField<String> TELECINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Telecine").getter(H264Settings.getter(H264Settings::telecineAsString)).setter(H264Settings.setter(Builder::telecine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("telecine").build()}).build();
    private static final SdkField<String> TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemporalAdaptiveQuantization").getter(H264Settings.getter(H264Settings::temporalAdaptiveQuantizationAsString)).setter(H264Settings.setter(Builder::temporalAdaptiveQuantization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temporalAdaptiveQuantization").build()}).build();
    private static final SdkField<String> UNREGISTERED_SEI_TIMECODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UnregisteredSeiTimecode").getter(H264Settings.getter(H264Settings::unregisteredSeiTimecodeAsString)).setter(H264Settings.setter(Builder::unregisteredSeiTimecode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unregisteredSeiTimecode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADAPTIVE_QUANTIZATION_FIELD, BITRATE_FIELD, CODEC_LEVEL_FIELD, CODEC_PROFILE_FIELD, DYNAMIC_SUB_GOP_FIELD, ENTROPY_ENCODING_FIELD, FIELD_ENCODING_FIELD, FLICKER_ADAPTIVE_QUANTIZATION_FIELD, FRAMERATE_CONTROL_FIELD, FRAMERATE_CONVERSION_ALGORITHM_FIELD, FRAMERATE_DENOMINATOR_FIELD, FRAMERATE_NUMERATOR_FIELD, GOP_B_REFERENCE_FIELD, GOP_CLOSED_CADENCE_FIELD, GOP_SIZE_FIELD, GOP_SIZE_UNITS_FIELD, HRD_BUFFER_INITIAL_FILL_PERCENTAGE_FIELD, HRD_BUFFER_SIZE_FIELD, INTERLACE_MODE_FIELD, MAX_BITRATE_FIELD, MIN_I_INTERVAL_FIELD, NUMBER_B_FRAMES_BETWEEN_REFERENCE_FRAMES_FIELD, NUMBER_REFERENCE_FRAMES_FIELD, PAR_CONTROL_FIELD, PAR_DENOMINATOR_FIELD, PAR_NUMERATOR_FIELD, QUALITY_TUNING_LEVEL_FIELD, QVBR_SETTINGS_FIELD, RATE_CONTROL_MODE_FIELD, REPEAT_PPS_FIELD, SCAN_TYPE_CONVERSION_MODE_FIELD, SCENE_CHANGE_DETECT_FIELD, SLICES_FIELD, SLOW_PAL_FIELD, SOFTNESS_FIELD, SPATIAL_ADAPTIVE_QUANTIZATION_FIELD, SYNTAX_FIELD, TELECINE_FIELD, TEMPORAL_ADAPTIVE_QUANTIZATION_FIELD, UNREGISTERED_SEI_TIMECODE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String adaptiveQuantization;
    private final Integer bitrate;
    private final String codecLevel;
    private final String codecProfile;
    private final String dynamicSubGop;
    private final String entropyEncoding;
    private final String fieldEncoding;
    private final String flickerAdaptiveQuantization;
    private final String framerateControl;
    private final String framerateConversionAlgorithm;
    private final Integer framerateDenominator;
    private final Integer framerateNumerator;
    private final String gopBReference;
    private final Integer gopClosedCadence;
    private final Double gopSize;
    private final String gopSizeUnits;
    private final Integer hrdBufferInitialFillPercentage;
    private final Integer hrdBufferSize;
    private final String interlaceMode;
    private final Integer maxBitrate;
    private final Integer minIInterval;
    private final Integer numberBFramesBetweenReferenceFrames;
    private final Integer numberReferenceFrames;
    private final String parControl;
    private final Integer parDenominator;
    private final Integer parNumerator;
    private final String qualityTuningLevel;
    private final H264QvbrSettings qvbrSettings;
    private final String rateControlMode;
    private final String repeatPps;
    private final String scanTypeConversionMode;
    private final String sceneChangeDetect;
    private final Integer slices;
    private final String slowPal;
    private final Integer softness;
    private final String spatialAdaptiveQuantization;
    private final String syntax;
    private final String telecine;
    private final String temporalAdaptiveQuantization;
    private final String unregisteredSeiTimecode;

    private H264Settings(BuilderImpl builder) {
        this.adaptiveQuantization = builder.adaptiveQuantization;
        this.bitrate = builder.bitrate;
        this.codecLevel = builder.codecLevel;
        this.codecProfile = builder.codecProfile;
        this.dynamicSubGop = builder.dynamicSubGop;
        this.entropyEncoding = builder.entropyEncoding;
        this.fieldEncoding = builder.fieldEncoding;
        this.flickerAdaptiveQuantization = builder.flickerAdaptiveQuantization;
        this.framerateControl = builder.framerateControl;
        this.framerateConversionAlgorithm = builder.framerateConversionAlgorithm;
        this.framerateDenominator = builder.framerateDenominator;
        this.framerateNumerator = builder.framerateNumerator;
        this.gopBReference = builder.gopBReference;
        this.gopClosedCadence = builder.gopClosedCadence;
        this.gopSize = builder.gopSize;
        this.gopSizeUnits = builder.gopSizeUnits;
        this.hrdBufferInitialFillPercentage = builder.hrdBufferInitialFillPercentage;
        this.hrdBufferSize = builder.hrdBufferSize;
        this.interlaceMode = builder.interlaceMode;
        this.maxBitrate = builder.maxBitrate;
        this.minIInterval = builder.minIInterval;
        this.numberBFramesBetweenReferenceFrames = builder.numberBFramesBetweenReferenceFrames;
        this.numberReferenceFrames = builder.numberReferenceFrames;
        this.parControl = builder.parControl;
        this.parDenominator = builder.parDenominator;
        this.parNumerator = builder.parNumerator;
        this.qualityTuningLevel = builder.qualityTuningLevel;
        this.qvbrSettings = builder.qvbrSettings;
        this.rateControlMode = builder.rateControlMode;
        this.repeatPps = builder.repeatPps;
        this.scanTypeConversionMode = builder.scanTypeConversionMode;
        this.sceneChangeDetect = builder.sceneChangeDetect;
        this.slices = builder.slices;
        this.slowPal = builder.slowPal;
        this.softness = builder.softness;
        this.spatialAdaptiveQuantization = builder.spatialAdaptiveQuantization;
        this.syntax = builder.syntax;
        this.telecine = builder.telecine;
        this.temporalAdaptiveQuantization = builder.temporalAdaptiveQuantization;
        this.unregisteredSeiTimecode = builder.unregisteredSeiTimecode;
    }

    public final H264AdaptiveQuantization adaptiveQuantization() {
        return H264AdaptiveQuantization.fromValue(this.adaptiveQuantization);
    }

    public final String adaptiveQuantizationAsString() {
        return this.adaptiveQuantization;
    }

    public final Integer bitrate() {
        return this.bitrate;
    }

    public final H264CodecLevel codecLevel() {
        return H264CodecLevel.fromValue(this.codecLevel);
    }

    public final String codecLevelAsString() {
        return this.codecLevel;
    }

    public final H264CodecProfile codecProfile() {
        return H264CodecProfile.fromValue(this.codecProfile);
    }

    public final String codecProfileAsString() {
        return this.codecProfile;
    }

    public final H264DynamicSubGop dynamicSubGop() {
        return H264DynamicSubGop.fromValue(this.dynamicSubGop);
    }

    public final String dynamicSubGopAsString() {
        return this.dynamicSubGop;
    }

    public final H264EntropyEncoding entropyEncoding() {
        return H264EntropyEncoding.fromValue(this.entropyEncoding);
    }

    public final String entropyEncodingAsString() {
        return this.entropyEncoding;
    }

    public final H264FieldEncoding fieldEncoding() {
        return H264FieldEncoding.fromValue(this.fieldEncoding);
    }

    public final String fieldEncodingAsString() {
        return this.fieldEncoding;
    }

    public final H264FlickerAdaptiveQuantization flickerAdaptiveQuantization() {
        return H264FlickerAdaptiveQuantization.fromValue(this.flickerAdaptiveQuantization);
    }

    public final String flickerAdaptiveQuantizationAsString() {
        return this.flickerAdaptiveQuantization;
    }

    public final H264FramerateControl framerateControl() {
        return H264FramerateControl.fromValue(this.framerateControl);
    }

    public final String framerateControlAsString() {
        return this.framerateControl;
    }

    public final H264FramerateConversionAlgorithm framerateConversionAlgorithm() {
        return H264FramerateConversionAlgorithm.fromValue(this.framerateConversionAlgorithm);
    }

    public final String framerateConversionAlgorithmAsString() {
        return this.framerateConversionAlgorithm;
    }

    public final Integer framerateDenominator() {
        return this.framerateDenominator;
    }

    public final Integer framerateNumerator() {
        return this.framerateNumerator;
    }

    public final H264GopBReference gopBReference() {
        return H264GopBReference.fromValue(this.gopBReference);
    }

    public final String gopBReferenceAsString() {
        return this.gopBReference;
    }

    public final Integer gopClosedCadence() {
        return this.gopClosedCadence;
    }

    public final Double gopSize() {
        return this.gopSize;
    }

    public final H264GopSizeUnits gopSizeUnits() {
        return H264GopSizeUnits.fromValue(this.gopSizeUnits);
    }

    public final String gopSizeUnitsAsString() {
        return this.gopSizeUnits;
    }

    public final Integer hrdBufferInitialFillPercentage() {
        return this.hrdBufferInitialFillPercentage;
    }

    public final Integer hrdBufferSize() {
        return this.hrdBufferSize;
    }

    public final H264InterlaceMode interlaceMode() {
        return H264InterlaceMode.fromValue(this.interlaceMode);
    }

    public final String interlaceModeAsString() {
        return this.interlaceMode;
    }

    public final Integer maxBitrate() {
        return this.maxBitrate;
    }

    public final Integer minIInterval() {
        return this.minIInterval;
    }

    public final Integer numberBFramesBetweenReferenceFrames() {
        return this.numberBFramesBetweenReferenceFrames;
    }

    public final Integer numberReferenceFrames() {
        return this.numberReferenceFrames;
    }

    public final H264ParControl parControl() {
        return H264ParControl.fromValue(this.parControl);
    }

    public final String parControlAsString() {
        return this.parControl;
    }

    public final Integer parDenominator() {
        return this.parDenominator;
    }

    public final Integer parNumerator() {
        return this.parNumerator;
    }

    public final H264QualityTuningLevel qualityTuningLevel() {
        return H264QualityTuningLevel.fromValue(this.qualityTuningLevel);
    }

    public final String qualityTuningLevelAsString() {
        return this.qualityTuningLevel;
    }

    public final H264QvbrSettings qvbrSettings() {
        return this.qvbrSettings;
    }

    public final H264RateControlMode rateControlMode() {
        return H264RateControlMode.fromValue(this.rateControlMode);
    }

    public final String rateControlModeAsString() {
        return this.rateControlMode;
    }

    public final H264RepeatPps repeatPps() {
        return H264RepeatPps.fromValue(this.repeatPps);
    }

    public final String repeatPpsAsString() {
        return this.repeatPps;
    }

    public final H264ScanTypeConversionMode scanTypeConversionMode() {
        return H264ScanTypeConversionMode.fromValue(this.scanTypeConversionMode);
    }

    public final String scanTypeConversionModeAsString() {
        return this.scanTypeConversionMode;
    }

    public final H264SceneChangeDetect sceneChangeDetect() {
        return H264SceneChangeDetect.fromValue(this.sceneChangeDetect);
    }

    public final String sceneChangeDetectAsString() {
        return this.sceneChangeDetect;
    }

    public final Integer slices() {
        return this.slices;
    }

    public final H264SlowPal slowPal() {
        return H264SlowPal.fromValue(this.slowPal);
    }

    public final String slowPalAsString() {
        return this.slowPal;
    }

    public final Integer softness() {
        return this.softness;
    }

    public final H264SpatialAdaptiveQuantization spatialAdaptiveQuantization() {
        return H264SpatialAdaptiveQuantization.fromValue(this.spatialAdaptiveQuantization);
    }

    public final String spatialAdaptiveQuantizationAsString() {
        return this.spatialAdaptiveQuantization;
    }

    public final H264Syntax syntax() {
        return H264Syntax.fromValue(this.syntax);
    }

    public final String syntaxAsString() {
        return this.syntax;
    }

    public final H264Telecine telecine() {
        return H264Telecine.fromValue(this.telecine);
    }

    public final String telecineAsString() {
        return this.telecine;
    }

    public final H264TemporalAdaptiveQuantization temporalAdaptiveQuantization() {
        return H264TemporalAdaptiveQuantization.fromValue(this.temporalAdaptiveQuantization);
    }

    public final String temporalAdaptiveQuantizationAsString() {
        return this.temporalAdaptiveQuantization;
    }

    public final H264UnregisteredSeiTimecode unregisteredSeiTimecode() {
        return H264UnregisteredSeiTimecode.fromValue(this.unregisteredSeiTimecode);
    }

    public final String unregisteredSeiTimecodeAsString() {
        return this.unregisteredSeiTimecode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.codecProfileAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dynamicSubGopAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.entropyEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldEncodingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.flickerAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateConversionAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.framerateNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopBReferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopClosedCadence());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.gopSizeUnitsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hrdBufferInitialFillPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hrdBufferSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.interlaceModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxBitrate());
        hashCode = 31 * hashCode + Objects.hashCode(this.minIInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberBFramesBetweenReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberReferenceFrames());
        hashCode = 31 * hashCode + Objects.hashCode(this.parControlAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.parDenominator());
        hashCode = 31 * hashCode + Objects.hashCode(this.parNumerator());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualityTuningLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.qvbrSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.rateControlModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.repeatPpsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanTypeConversionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sceneChangeDetectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.slices());
        hashCode = 31 * hashCode + Objects.hashCode(this.slowPalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.softness());
        hashCode = 31 * hashCode + Objects.hashCode(this.spatialAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.syntaxAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.telecineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.temporalAdaptiveQuantizationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.unregisteredSeiTimecodeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof H264Settings)) {
            return false;
        }
        H264Settings other = (H264Settings)obj;
        return Objects.equals(this.adaptiveQuantizationAsString(), other.adaptiveQuantizationAsString()) && Objects.equals(this.bitrate(), other.bitrate()) && Objects.equals(this.codecLevelAsString(), other.codecLevelAsString()) && Objects.equals(this.codecProfileAsString(), other.codecProfileAsString()) && Objects.equals(this.dynamicSubGopAsString(), other.dynamicSubGopAsString()) && Objects.equals(this.entropyEncodingAsString(), other.entropyEncodingAsString()) && Objects.equals(this.fieldEncodingAsString(), other.fieldEncodingAsString()) && Objects.equals(this.flickerAdaptiveQuantizationAsString(), other.flickerAdaptiveQuantizationAsString()) && Objects.equals(this.framerateControlAsString(), other.framerateControlAsString()) && Objects.equals(this.framerateConversionAlgorithmAsString(), other.framerateConversionAlgorithmAsString()) && Objects.equals(this.framerateDenominator(), other.framerateDenominator()) && Objects.equals(this.framerateNumerator(), other.framerateNumerator()) && Objects.equals(this.gopBReferenceAsString(), other.gopBReferenceAsString()) && Objects.equals(this.gopClosedCadence(), other.gopClosedCadence()) && Objects.equals(this.gopSize(), other.gopSize()) && Objects.equals(this.gopSizeUnitsAsString(), other.gopSizeUnitsAsString()) && Objects.equals(this.hrdBufferInitialFillPercentage(), other.hrdBufferInitialFillPercentage()) && Objects.equals(this.hrdBufferSize(), other.hrdBufferSize()) && Objects.equals(this.interlaceModeAsString(), other.interlaceModeAsString()) && Objects.equals(this.maxBitrate(), other.maxBitrate()) && Objects.equals(this.minIInterval(), other.minIInterval()) && Objects.equals(this.numberBFramesBetweenReferenceFrames(), other.numberBFramesBetweenReferenceFrames()) && Objects.equals(this.numberReferenceFrames(), other.numberReferenceFrames()) && Objects.equals(this.parControlAsString(), other.parControlAsString()) && Objects.equals(this.parDenominator(), other.parDenominator()) && Objects.equals(this.parNumerator(), other.parNumerator()) && Objects.equals(this.qualityTuningLevelAsString(), other.qualityTuningLevelAsString()) && Objects.equals(this.qvbrSettings(), other.qvbrSettings()) && Objects.equals(this.rateControlModeAsString(), other.rateControlModeAsString()) && Objects.equals(this.repeatPpsAsString(), other.repeatPpsAsString()) && Objects.equals(this.scanTypeConversionModeAsString(), other.scanTypeConversionModeAsString()) && Objects.equals(this.sceneChangeDetectAsString(), other.sceneChangeDetectAsString()) && Objects.equals(this.slices(), other.slices()) && Objects.equals(this.slowPalAsString(), other.slowPalAsString()) && Objects.equals(this.softness(), other.softness()) && Objects.equals(this.spatialAdaptiveQuantizationAsString(), other.spatialAdaptiveQuantizationAsString()) && Objects.equals(this.syntaxAsString(), other.syntaxAsString()) && Objects.equals(this.telecineAsString(), other.telecineAsString()) && Objects.equals(this.temporalAdaptiveQuantizationAsString(), other.temporalAdaptiveQuantizationAsString()) && Objects.equals(this.unregisteredSeiTimecodeAsString(), other.unregisteredSeiTimecodeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"H264Settings").add("AdaptiveQuantization", (Object)this.adaptiveQuantizationAsString()).add("Bitrate", (Object)this.bitrate()).add("CodecLevel", (Object)this.codecLevelAsString()).add("CodecProfile", (Object)this.codecProfileAsString()).add("DynamicSubGop", (Object)this.dynamicSubGopAsString()).add("EntropyEncoding", (Object)this.entropyEncodingAsString()).add("FieldEncoding", (Object)this.fieldEncodingAsString()).add("FlickerAdaptiveQuantization", (Object)this.flickerAdaptiveQuantizationAsString()).add("FramerateControl", (Object)this.framerateControlAsString()).add("FramerateConversionAlgorithm", (Object)this.framerateConversionAlgorithmAsString()).add("FramerateDenominator", (Object)this.framerateDenominator()).add("FramerateNumerator", (Object)this.framerateNumerator()).add("GopBReference", (Object)this.gopBReferenceAsString()).add("GopClosedCadence", (Object)this.gopClosedCadence()).add("GopSize", (Object)this.gopSize()).add("GopSizeUnits", (Object)this.gopSizeUnitsAsString()).add("HrdBufferInitialFillPercentage", (Object)this.hrdBufferInitialFillPercentage()).add("HrdBufferSize", (Object)this.hrdBufferSize()).add("InterlaceMode", (Object)this.interlaceModeAsString()).add("MaxBitrate", (Object)this.maxBitrate()).add("MinIInterval", (Object)this.minIInterval()).add("NumberBFramesBetweenReferenceFrames", (Object)this.numberBFramesBetweenReferenceFrames()).add("NumberReferenceFrames", (Object)this.numberReferenceFrames()).add("ParControl", (Object)this.parControlAsString()).add("ParDenominator", (Object)this.parDenominator()).add("ParNumerator", (Object)this.parNumerator()).add("QualityTuningLevel", (Object)this.qualityTuningLevelAsString()).add("QvbrSettings", (Object)this.qvbrSettings()).add("RateControlMode", (Object)this.rateControlModeAsString()).add("RepeatPps", (Object)this.repeatPpsAsString()).add("ScanTypeConversionMode", (Object)this.scanTypeConversionModeAsString()).add("SceneChangeDetect", (Object)this.sceneChangeDetectAsString()).add("Slices", (Object)this.slices()).add("SlowPal", (Object)this.slowPalAsString()).add("Softness", (Object)this.softness()).add("SpatialAdaptiveQuantization", (Object)this.spatialAdaptiveQuantizationAsString()).add("Syntax", (Object)this.syntaxAsString()).add("Telecine", (Object)this.telecineAsString()).add("TemporalAdaptiveQuantization", (Object)this.temporalAdaptiveQuantizationAsString()).add("UnregisteredSeiTimecode", (Object)this.unregisteredSeiTimecodeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.adaptiveQuantizationAsString()));
            }
            case "Bitrate": {
                return Optional.ofNullable(clazz.cast(this.bitrate()));
            }
            case "CodecLevel": {
                return Optional.ofNullable(clazz.cast(this.codecLevelAsString()));
            }
            case "CodecProfile": {
                return Optional.ofNullable(clazz.cast(this.codecProfileAsString()));
            }
            case "DynamicSubGop": {
                return Optional.ofNullable(clazz.cast(this.dynamicSubGopAsString()));
            }
            case "EntropyEncoding": {
                return Optional.ofNullable(clazz.cast(this.entropyEncodingAsString()));
            }
            case "FieldEncoding": {
                return Optional.ofNullable(clazz.cast(this.fieldEncodingAsString()));
            }
            case "FlickerAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.flickerAdaptiveQuantizationAsString()));
            }
            case "FramerateControl": {
                return Optional.ofNullable(clazz.cast(this.framerateControlAsString()));
            }
            case "FramerateConversionAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.framerateConversionAlgorithmAsString()));
            }
            case "FramerateDenominator": {
                return Optional.ofNullable(clazz.cast(this.framerateDenominator()));
            }
            case "FramerateNumerator": {
                return Optional.ofNullable(clazz.cast(this.framerateNumerator()));
            }
            case "GopBReference": {
                return Optional.ofNullable(clazz.cast(this.gopBReferenceAsString()));
            }
            case "GopClosedCadence": {
                return Optional.ofNullable(clazz.cast(this.gopClosedCadence()));
            }
            case "GopSize": {
                return Optional.ofNullable(clazz.cast(this.gopSize()));
            }
            case "GopSizeUnits": {
                return Optional.ofNullable(clazz.cast(this.gopSizeUnitsAsString()));
            }
            case "HrdBufferInitialFillPercentage": {
                return Optional.ofNullable(clazz.cast(this.hrdBufferInitialFillPercentage()));
            }
            case "HrdBufferSize": {
                return Optional.ofNullable(clazz.cast(this.hrdBufferSize()));
            }
            case "InterlaceMode": {
                return Optional.ofNullable(clazz.cast(this.interlaceModeAsString()));
            }
            case "MaxBitrate": {
                return Optional.ofNullable(clazz.cast(this.maxBitrate()));
            }
            case "MinIInterval": {
                return Optional.ofNullable(clazz.cast(this.minIInterval()));
            }
            case "NumberBFramesBetweenReferenceFrames": {
                return Optional.ofNullable(clazz.cast(this.numberBFramesBetweenReferenceFrames()));
            }
            case "NumberReferenceFrames": {
                return Optional.ofNullable(clazz.cast(this.numberReferenceFrames()));
            }
            case "ParControl": {
                return Optional.ofNullable(clazz.cast(this.parControlAsString()));
            }
            case "ParDenominator": {
                return Optional.ofNullable(clazz.cast(this.parDenominator()));
            }
            case "ParNumerator": {
                return Optional.ofNullable(clazz.cast(this.parNumerator()));
            }
            case "QualityTuningLevel": {
                return Optional.ofNullable(clazz.cast(this.qualityTuningLevelAsString()));
            }
            case "QvbrSettings": {
                return Optional.ofNullable(clazz.cast(this.qvbrSettings()));
            }
            case "RateControlMode": {
                return Optional.ofNullable(clazz.cast(this.rateControlModeAsString()));
            }
            case "RepeatPps": {
                return Optional.ofNullable(clazz.cast(this.repeatPpsAsString()));
            }
            case "ScanTypeConversionMode": {
                return Optional.ofNullable(clazz.cast(this.scanTypeConversionModeAsString()));
            }
            case "SceneChangeDetect": {
                return Optional.ofNullable(clazz.cast(this.sceneChangeDetectAsString()));
            }
            case "Slices": {
                return Optional.ofNullable(clazz.cast(this.slices()));
            }
            case "SlowPal": {
                return Optional.ofNullable(clazz.cast(this.slowPalAsString()));
            }
            case "Softness": {
                return Optional.ofNullable(clazz.cast(this.softness()));
            }
            case "SpatialAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.spatialAdaptiveQuantizationAsString()));
            }
            case "Syntax": {
                return Optional.ofNullable(clazz.cast(this.syntaxAsString()));
            }
            case "Telecine": {
                return Optional.ofNullable(clazz.cast(this.telecineAsString()));
            }
            case "TemporalAdaptiveQuantization": {
                return Optional.ofNullable(clazz.cast(this.temporalAdaptiveQuantizationAsString()));
            }
            case "UnregisteredSeiTimecode": {
                return Optional.ofNullable(clazz.cast(this.unregisteredSeiTimecodeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<H264Settings, T> g) {
        return obj -> g.apply((H264Settings)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String adaptiveQuantization;
        private Integer bitrate;
        private String codecLevel;
        private String codecProfile;
        private String dynamicSubGop;
        private String entropyEncoding;
        private String fieldEncoding;
        private String flickerAdaptiveQuantization;
        private String framerateControl;
        private String framerateConversionAlgorithm;
        private Integer framerateDenominator;
        private Integer framerateNumerator;
        private String gopBReference;
        private Integer gopClosedCadence;
        private Double gopSize;
        private String gopSizeUnits;
        private Integer hrdBufferInitialFillPercentage;
        private Integer hrdBufferSize;
        private String interlaceMode;
        private Integer maxBitrate;
        private Integer minIInterval;
        private Integer numberBFramesBetweenReferenceFrames;
        private Integer numberReferenceFrames;
        private String parControl;
        private Integer parDenominator;
        private Integer parNumerator;
        private String qualityTuningLevel;
        private H264QvbrSettings qvbrSettings;
        private String rateControlMode;
        private String repeatPps;
        private String scanTypeConversionMode;
        private String sceneChangeDetect;
        private Integer slices;
        private String slowPal;
        private Integer softness;
        private String spatialAdaptiveQuantization;
        private String syntax;
        private String telecine;
        private String temporalAdaptiveQuantization;
        private String unregisteredSeiTimecode;

        private BuilderImpl() {
        }

        private BuilderImpl(H264Settings model) {
            this.adaptiveQuantization(model.adaptiveQuantization);
            this.bitrate(model.bitrate);
            this.codecLevel(model.codecLevel);
            this.codecProfile(model.codecProfile);
            this.dynamicSubGop(model.dynamicSubGop);
            this.entropyEncoding(model.entropyEncoding);
            this.fieldEncoding(model.fieldEncoding);
            this.flickerAdaptiveQuantization(model.flickerAdaptiveQuantization);
            this.framerateControl(model.framerateControl);
            this.framerateConversionAlgorithm(model.framerateConversionAlgorithm);
            this.framerateDenominator(model.framerateDenominator);
            this.framerateNumerator(model.framerateNumerator);
            this.gopBReference(model.gopBReference);
            this.gopClosedCadence(model.gopClosedCadence);
            this.gopSize(model.gopSize);
            this.gopSizeUnits(model.gopSizeUnits);
            this.hrdBufferInitialFillPercentage(model.hrdBufferInitialFillPercentage);
            this.hrdBufferSize(model.hrdBufferSize);
            this.interlaceMode(model.interlaceMode);
            this.maxBitrate(model.maxBitrate);
            this.minIInterval(model.minIInterval);
            this.numberBFramesBetweenReferenceFrames(model.numberBFramesBetweenReferenceFrames);
            this.numberReferenceFrames(model.numberReferenceFrames);
            this.parControl(model.parControl);
            this.parDenominator(model.parDenominator);
            this.parNumerator(model.parNumerator);
            this.qualityTuningLevel(model.qualityTuningLevel);
            this.qvbrSettings(model.qvbrSettings);
            this.rateControlMode(model.rateControlMode);
            this.repeatPps(model.repeatPps);
            this.scanTypeConversionMode(model.scanTypeConversionMode);
            this.sceneChangeDetect(model.sceneChangeDetect);
            this.slices(model.slices);
            this.slowPal(model.slowPal);
            this.softness(model.softness);
            this.spatialAdaptiveQuantization(model.spatialAdaptiveQuantization);
            this.syntax(model.syntax);
            this.telecine(model.telecine);
            this.temporalAdaptiveQuantization(model.temporalAdaptiveQuantization);
            this.unregisteredSeiTimecode(model.unregisteredSeiTimecode);
        }

        public final String getAdaptiveQuantization() {
            return this.adaptiveQuantization;
        }

        @Override
        public final Builder adaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
            return this;
        }

        @Override
        public final Builder adaptiveQuantization(H264AdaptiveQuantization adaptiveQuantization) {
            this.adaptiveQuantization(adaptiveQuantization == null ? null : adaptiveQuantization.toString());
            return this;
        }

        public final void setAdaptiveQuantization(String adaptiveQuantization) {
            this.adaptiveQuantization = adaptiveQuantization;
        }

        public final Integer getBitrate() {
            return this.bitrate;
        }

        @Override
        public final Builder bitrate(Integer bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        public final void setBitrate(Integer bitrate) {
            this.bitrate = bitrate;
        }

        public final String getCodecLevel() {
            return this.codecLevel;
        }

        @Override
        public final Builder codecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
            return this;
        }

        @Override
        public final Builder codecLevel(H264CodecLevel codecLevel) {
            this.codecLevel(codecLevel == null ? null : codecLevel.toString());
            return this;
        }

        public final void setCodecLevel(String codecLevel) {
            this.codecLevel = codecLevel;
        }

        public final String getCodecProfile() {
            return this.codecProfile;
        }

        @Override
        public final Builder codecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
            return this;
        }

        @Override
        public final Builder codecProfile(H264CodecProfile codecProfile) {
            this.codecProfile(codecProfile == null ? null : codecProfile.toString());
            return this;
        }

        public final void setCodecProfile(String codecProfile) {
            this.codecProfile = codecProfile;
        }

        public final String getDynamicSubGop() {
            return this.dynamicSubGop;
        }

        @Override
        public final Builder dynamicSubGop(String dynamicSubGop) {
            this.dynamicSubGop = dynamicSubGop;
            return this;
        }

        @Override
        public final Builder dynamicSubGop(H264DynamicSubGop dynamicSubGop) {
            this.dynamicSubGop(dynamicSubGop == null ? null : dynamicSubGop.toString());
            return this;
        }

        public final void setDynamicSubGop(String dynamicSubGop) {
            this.dynamicSubGop = dynamicSubGop;
        }

        public final String getEntropyEncoding() {
            return this.entropyEncoding;
        }

        @Override
        public final Builder entropyEncoding(String entropyEncoding) {
            this.entropyEncoding = entropyEncoding;
            return this;
        }

        @Override
        public final Builder entropyEncoding(H264EntropyEncoding entropyEncoding) {
            this.entropyEncoding(entropyEncoding == null ? null : entropyEncoding.toString());
            return this;
        }

        public final void setEntropyEncoding(String entropyEncoding) {
            this.entropyEncoding = entropyEncoding;
        }

        public final String getFieldEncoding() {
            return this.fieldEncoding;
        }

        @Override
        public final Builder fieldEncoding(String fieldEncoding) {
            this.fieldEncoding = fieldEncoding;
            return this;
        }

        @Override
        public final Builder fieldEncoding(H264FieldEncoding fieldEncoding) {
            this.fieldEncoding(fieldEncoding == null ? null : fieldEncoding.toString());
            return this;
        }

        public final void setFieldEncoding(String fieldEncoding) {
            this.fieldEncoding = fieldEncoding;
        }

        public final String getFlickerAdaptiveQuantization() {
            return this.flickerAdaptiveQuantization;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder flickerAdaptiveQuantization(H264FlickerAdaptiveQuantization flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization(flickerAdaptiveQuantization == null ? null : flickerAdaptiveQuantization.toString());
            return this;
        }

        public final void setFlickerAdaptiveQuantization(String flickerAdaptiveQuantization) {
            this.flickerAdaptiveQuantization = flickerAdaptiveQuantization;
        }

        public final String getFramerateControl() {
            return this.framerateControl;
        }

        @Override
        public final Builder framerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
            return this;
        }

        @Override
        public final Builder framerateControl(H264FramerateControl framerateControl) {
            this.framerateControl(framerateControl == null ? null : framerateControl.toString());
            return this;
        }

        public final void setFramerateControl(String framerateControl) {
            this.framerateControl = framerateControl;
        }

        public final String getFramerateConversionAlgorithm() {
            return this.framerateConversionAlgorithm;
        }

        @Override
        public final Builder framerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
            return this;
        }

        @Override
        public final Builder framerateConversionAlgorithm(H264FramerateConversionAlgorithm framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm(framerateConversionAlgorithm == null ? null : framerateConversionAlgorithm.toString());
            return this;
        }

        public final void setFramerateConversionAlgorithm(String framerateConversionAlgorithm) {
            this.framerateConversionAlgorithm = framerateConversionAlgorithm;
        }

        public final Integer getFramerateDenominator() {
            return this.framerateDenominator;
        }

        @Override
        public final Builder framerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
            return this;
        }

        public final void setFramerateDenominator(Integer framerateDenominator) {
            this.framerateDenominator = framerateDenominator;
        }

        public final Integer getFramerateNumerator() {
            return this.framerateNumerator;
        }

        @Override
        public final Builder framerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
            return this;
        }

        public final void setFramerateNumerator(Integer framerateNumerator) {
            this.framerateNumerator = framerateNumerator;
        }

        public final String getGopBReference() {
            return this.gopBReference;
        }

        @Override
        public final Builder gopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
            return this;
        }

        @Override
        public final Builder gopBReference(H264GopBReference gopBReference) {
            this.gopBReference(gopBReference == null ? null : gopBReference.toString());
            return this;
        }

        public final void setGopBReference(String gopBReference) {
            this.gopBReference = gopBReference;
        }

        public final Integer getGopClosedCadence() {
            return this.gopClosedCadence;
        }

        @Override
        public final Builder gopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
            return this;
        }

        public final void setGopClosedCadence(Integer gopClosedCadence) {
            this.gopClosedCadence = gopClosedCadence;
        }

        public final Double getGopSize() {
            return this.gopSize;
        }

        @Override
        public final Builder gopSize(Double gopSize) {
            this.gopSize = gopSize;
            return this;
        }

        public final void setGopSize(Double gopSize) {
            this.gopSize = gopSize;
        }

        public final String getGopSizeUnits() {
            return this.gopSizeUnits;
        }

        @Override
        public final Builder gopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
            return this;
        }

        @Override
        public final Builder gopSizeUnits(H264GopSizeUnits gopSizeUnits) {
            this.gopSizeUnits(gopSizeUnits == null ? null : gopSizeUnits.toString());
            return this;
        }

        public final void setGopSizeUnits(String gopSizeUnits) {
            this.gopSizeUnits = gopSizeUnits;
        }

        public final Integer getHrdBufferInitialFillPercentage() {
            return this.hrdBufferInitialFillPercentage;
        }

        @Override
        public final Builder hrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
            return this;
        }

        public final void setHrdBufferInitialFillPercentage(Integer hrdBufferInitialFillPercentage) {
            this.hrdBufferInitialFillPercentage = hrdBufferInitialFillPercentage;
        }

        public final Integer getHrdBufferSize() {
            return this.hrdBufferSize;
        }

        @Override
        public final Builder hrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
            return this;
        }

        public final void setHrdBufferSize(Integer hrdBufferSize) {
            this.hrdBufferSize = hrdBufferSize;
        }

        public final String getInterlaceMode() {
            return this.interlaceMode;
        }

        @Override
        public final Builder interlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
            return this;
        }

        @Override
        public final Builder interlaceMode(H264InterlaceMode interlaceMode) {
            this.interlaceMode(interlaceMode == null ? null : interlaceMode.toString());
            return this;
        }

        public final void setInterlaceMode(String interlaceMode) {
            this.interlaceMode = interlaceMode;
        }

        public final Integer getMaxBitrate() {
            return this.maxBitrate;
        }

        @Override
        public final Builder maxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
            return this;
        }

        public final void setMaxBitrate(Integer maxBitrate) {
            this.maxBitrate = maxBitrate;
        }

        public final Integer getMinIInterval() {
            return this.minIInterval;
        }

        @Override
        public final Builder minIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
            return this;
        }

        public final void setMinIInterval(Integer minIInterval) {
            this.minIInterval = minIInterval;
        }

        public final Integer getNumberBFramesBetweenReferenceFrames() {
            return this.numberBFramesBetweenReferenceFrames;
        }

        @Override
        public final Builder numberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
            return this;
        }

        public final void setNumberBFramesBetweenReferenceFrames(Integer numberBFramesBetweenReferenceFrames) {
            this.numberBFramesBetweenReferenceFrames = numberBFramesBetweenReferenceFrames;
        }

        public final Integer getNumberReferenceFrames() {
            return this.numberReferenceFrames;
        }

        @Override
        public final Builder numberReferenceFrames(Integer numberReferenceFrames) {
            this.numberReferenceFrames = numberReferenceFrames;
            return this;
        }

        public final void setNumberReferenceFrames(Integer numberReferenceFrames) {
            this.numberReferenceFrames = numberReferenceFrames;
        }

        public final String getParControl() {
            return this.parControl;
        }

        @Override
        public final Builder parControl(String parControl) {
            this.parControl = parControl;
            return this;
        }

        @Override
        public final Builder parControl(H264ParControl parControl) {
            this.parControl(parControl == null ? null : parControl.toString());
            return this;
        }

        public final void setParControl(String parControl) {
            this.parControl = parControl;
        }

        public final Integer getParDenominator() {
            return this.parDenominator;
        }

        @Override
        public final Builder parDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
            return this;
        }

        public final void setParDenominator(Integer parDenominator) {
            this.parDenominator = parDenominator;
        }

        public final Integer getParNumerator() {
            return this.parNumerator;
        }

        @Override
        public final Builder parNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
            return this;
        }

        public final void setParNumerator(Integer parNumerator) {
            this.parNumerator = parNumerator;
        }

        public final String getQualityTuningLevel() {
            return this.qualityTuningLevel;
        }

        @Override
        public final Builder qualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
            return this;
        }

        @Override
        public final Builder qualityTuningLevel(H264QualityTuningLevel qualityTuningLevel) {
            this.qualityTuningLevel(qualityTuningLevel == null ? null : qualityTuningLevel.toString());
            return this;
        }

        public final void setQualityTuningLevel(String qualityTuningLevel) {
            this.qualityTuningLevel = qualityTuningLevel;
        }

        public final H264QvbrSettings.Builder getQvbrSettings() {
            return this.qvbrSettings != null ? this.qvbrSettings.toBuilder() : null;
        }

        @Override
        public final Builder qvbrSettings(H264QvbrSettings qvbrSettings) {
            this.qvbrSettings = qvbrSettings;
            return this;
        }

        public final void setQvbrSettings(H264QvbrSettings.BuilderImpl qvbrSettings) {
            this.qvbrSettings = qvbrSettings != null ? qvbrSettings.build() : null;
        }

        public final String getRateControlMode() {
            return this.rateControlMode;
        }

        @Override
        public final Builder rateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
            return this;
        }

        @Override
        public final Builder rateControlMode(H264RateControlMode rateControlMode) {
            this.rateControlMode(rateControlMode == null ? null : rateControlMode.toString());
            return this;
        }

        public final void setRateControlMode(String rateControlMode) {
            this.rateControlMode = rateControlMode;
        }

        public final String getRepeatPps() {
            return this.repeatPps;
        }

        @Override
        public final Builder repeatPps(String repeatPps) {
            this.repeatPps = repeatPps;
            return this;
        }

        @Override
        public final Builder repeatPps(H264RepeatPps repeatPps) {
            this.repeatPps(repeatPps == null ? null : repeatPps.toString());
            return this;
        }

        public final void setRepeatPps(String repeatPps) {
            this.repeatPps = repeatPps;
        }

        public final String getScanTypeConversionMode() {
            return this.scanTypeConversionMode;
        }

        @Override
        public final Builder scanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
            return this;
        }

        @Override
        public final Builder scanTypeConversionMode(H264ScanTypeConversionMode scanTypeConversionMode) {
            this.scanTypeConversionMode(scanTypeConversionMode == null ? null : scanTypeConversionMode.toString());
            return this;
        }

        public final void setScanTypeConversionMode(String scanTypeConversionMode) {
            this.scanTypeConversionMode = scanTypeConversionMode;
        }

        public final String getSceneChangeDetect() {
            return this.sceneChangeDetect;
        }

        @Override
        public final Builder sceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
            return this;
        }

        @Override
        public final Builder sceneChangeDetect(H264SceneChangeDetect sceneChangeDetect) {
            this.sceneChangeDetect(sceneChangeDetect == null ? null : sceneChangeDetect.toString());
            return this;
        }

        public final void setSceneChangeDetect(String sceneChangeDetect) {
            this.sceneChangeDetect = sceneChangeDetect;
        }

        public final Integer getSlices() {
            return this.slices;
        }

        @Override
        public final Builder slices(Integer slices) {
            this.slices = slices;
            return this;
        }

        public final void setSlices(Integer slices) {
            this.slices = slices;
        }

        public final String getSlowPal() {
            return this.slowPal;
        }

        @Override
        public final Builder slowPal(String slowPal) {
            this.slowPal = slowPal;
            return this;
        }

        @Override
        public final Builder slowPal(H264SlowPal slowPal) {
            this.slowPal(slowPal == null ? null : slowPal.toString());
            return this;
        }

        public final void setSlowPal(String slowPal) {
            this.slowPal = slowPal;
        }

        public final Integer getSoftness() {
            return this.softness;
        }

        @Override
        public final Builder softness(Integer softness) {
            this.softness = softness;
            return this;
        }

        public final void setSoftness(Integer softness) {
            this.softness = softness;
        }

        public final String getSpatialAdaptiveQuantization() {
            return this.spatialAdaptiveQuantization;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder spatialAdaptiveQuantization(H264SpatialAdaptiveQuantization spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization(spatialAdaptiveQuantization == null ? null : spatialAdaptiveQuantization.toString());
            return this;
        }

        public final void setSpatialAdaptiveQuantization(String spatialAdaptiveQuantization) {
            this.spatialAdaptiveQuantization = spatialAdaptiveQuantization;
        }

        public final String getSyntax() {
            return this.syntax;
        }

        @Override
        public final Builder syntax(String syntax) {
            this.syntax = syntax;
            return this;
        }

        @Override
        public final Builder syntax(H264Syntax syntax) {
            this.syntax(syntax == null ? null : syntax.toString());
            return this;
        }

        public final void setSyntax(String syntax) {
            this.syntax = syntax;
        }

        public final String getTelecine() {
            return this.telecine;
        }

        @Override
        public final Builder telecine(String telecine) {
            this.telecine = telecine;
            return this;
        }

        @Override
        public final Builder telecine(H264Telecine telecine) {
            this.telecine(telecine == null ? null : telecine.toString());
            return this;
        }

        public final void setTelecine(String telecine) {
            this.telecine = telecine;
        }

        public final String getTemporalAdaptiveQuantization() {
            return this.temporalAdaptiveQuantization;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
            return this;
        }

        @Override
        public final Builder temporalAdaptiveQuantization(H264TemporalAdaptiveQuantization temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization(temporalAdaptiveQuantization == null ? null : temporalAdaptiveQuantization.toString());
            return this;
        }

        public final void setTemporalAdaptiveQuantization(String temporalAdaptiveQuantization) {
            this.temporalAdaptiveQuantization = temporalAdaptiveQuantization;
        }

        public final String getUnregisteredSeiTimecode() {
            return this.unregisteredSeiTimecode;
        }

        @Override
        public final Builder unregisteredSeiTimecode(String unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode = unregisteredSeiTimecode;
            return this;
        }

        @Override
        public final Builder unregisteredSeiTimecode(H264UnregisteredSeiTimecode unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode(unregisteredSeiTimecode == null ? null : unregisteredSeiTimecode.toString());
            return this;
        }

        public final void setUnregisteredSeiTimecode(String unregisteredSeiTimecode) {
            this.unregisteredSeiTimecode = unregisteredSeiTimecode;
        }

        public H264Settings build() {
            return new H264Settings(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, H264Settings> {
        public Builder adaptiveQuantization(String var1);

        public Builder adaptiveQuantization(H264AdaptiveQuantization var1);

        public Builder bitrate(Integer var1);

        public Builder codecLevel(String var1);

        public Builder codecLevel(H264CodecLevel var1);

        public Builder codecProfile(String var1);

        public Builder codecProfile(H264CodecProfile var1);

        public Builder dynamicSubGop(String var1);

        public Builder dynamicSubGop(H264DynamicSubGop var1);

        public Builder entropyEncoding(String var1);

        public Builder entropyEncoding(H264EntropyEncoding var1);

        public Builder fieldEncoding(String var1);

        public Builder fieldEncoding(H264FieldEncoding var1);

        public Builder flickerAdaptiveQuantization(String var1);

        public Builder flickerAdaptiveQuantization(H264FlickerAdaptiveQuantization var1);

        public Builder framerateControl(String var1);

        public Builder framerateControl(H264FramerateControl var1);

        public Builder framerateConversionAlgorithm(String var1);

        public Builder framerateConversionAlgorithm(H264FramerateConversionAlgorithm var1);

        public Builder framerateDenominator(Integer var1);

        public Builder framerateNumerator(Integer var1);

        public Builder gopBReference(String var1);

        public Builder gopBReference(H264GopBReference var1);

        public Builder gopClosedCadence(Integer var1);

        public Builder gopSize(Double var1);

        public Builder gopSizeUnits(String var1);

        public Builder gopSizeUnits(H264GopSizeUnits var1);

        public Builder hrdBufferInitialFillPercentage(Integer var1);

        public Builder hrdBufferSize(Integer var1);

        public Builder interlaceMode(String var1);

        public Builder interlaceMode(H264InterlaceMode var1);

        public Builder maxBitrate(Integer var1);

        public Builder minIInterval(Integer var1);

        public Builder numberBFramesBetweenReferenceFrames(Integer var1);

        public Builder numberReferenceFrames(Integer var1);

        public Builder parControl(String var1);

        public Builder parControl(H264ParControl var1);

        public Builder parDenominator(Integer var1);

        public Builder parNumerator(Integer var1);

        public Builder qualityTuningLevel(String var1);

        public Builder qualityTuningLevel(H264QualityTuningLevel var1);

        public Builder qvbrSettings(H264QvbrSettings var1);

        default public Builder qvbrSettings(Consumer<H264QvbrSettings.Builder> qvbrSettings) {
            return this.qvbrSettings((H264QvbrSettings)((H264QvbrSettings.Builder)H264QvbrSettings.builder().applyMutation(qvbrSettings)).build());
        }

        public Builder rateControlMode(String var1);

        public Builder rateControlMode(H264RateControlMode var1);

        public Builder repeatPps(String var1);

        public Builder repeatPps(H264RepeatPps var1);

        public Builder scanTypeConversionMode(String var1);

        public Builder scanTypeConversionMode(H264ScanTypeConversionMode var1);

        public Builder sceneChangeDetect(String var1);

        public Builder sceneChangeDetect(H264SceneChangeDetect var1);

        public Builder slices(Integer var1);

        public Builder slowPal(String var1);

        public Builder slowPal(H264SlowPal var1);

        public Builder softness(Integer var1);

        public Builder spatialAdaptiveQuantization(String var1);

        public Builder spatialAdaptiveQuantization(H264SpatialAdaptiveQuantization var1);

        public Builder syntax(String var1);

        public Builder syntax(H264Syntax var1);

        public Builder telecine(String var1);

        public Builder telecine(H264Telecine var1);

        public Builder temporalAdaptiveQuantization(String var1);

        public Builder temporalAdaptiveQuantization(H264TemporalAdaptiveQuantization var1);

        public Builder unregisteredSeiTimecode(String var1);

        public Builder unregisteredSeiTimecode(H264UnregisteredSeiTimecode var1);
    }
}

