/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Optional. Specify how the service determines the pixel aspect ratio (PAR) for this output. The default behavior,
 * Follow source (INITIALIZE_FROM_SOURCE), uses the PAR from your input video for your output. To specify a different
 * PAR in the console, choose any value other than Follow source. To specify a different PAR by editing the JSON job
 * specification, choose SPECIFIED. When you choose SPECIFIED for this setting, you must also specify values for the
 * parNumerator and parDenominator settings.
 */
@Generated("software.amazon.awssdk:codegen")
public enum Vp8ParControl {
    INITIALIZE_FROM_SOURCE("INITIALIZE_FROM_SOURCE"),

    SPECIFIED("SPECIFIED"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Vp8ParControl(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Vp8ParControl corresponding to the value
     */
    public static Vp8ParControl fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Vp8ParControl.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Vp8ParControl}s
     */
    public static Set<Vp8ParControl> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
