/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * Settings specific to caption sources that are specified by track number. Currently, this is only IMSC captions in an
 * IMF package. If your caption source is IMSC 1.1 in a separate xml file, use FileSourceSettings instead of
 * TrackSourceSettings.
 */
@Generated("software.amazon.awssdk:codegen")
public final class TrackSourceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<TrackSourceSettings.Builder, TrackSourceSettings> {
    private static final SdkField<Integer> TRACK_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TrackNumber").getter(getter(TrackSourceSettings::trackNumber)).setter(setter(Builder::trackNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trackNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACK_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer trackNumber;

    private TrackSourceSettings(BuilderImpl builder) {
        this.trackNumber = builder.trackNumber;
    }

    /**
     * Use this setting to select a single captions track from a source. Track numbers correspond to the order in the
     * captions source file. For IMF sources, track numbering is based on the order that the captions appear in the CPL.
     * For example, use 1 to select the captions asset that is listed first in the CPL. To include more than one
     * captions track in your job outputs, create multiple input captions selectors. Specify one track per selector.
     * 
     * @return Use this setting to select a single captions track from a source. Track numbers correspond to the order
     *         in the captions source file. For IMF sources, track numbering is based on the order that the captions
     *         appear in the CPL. For example, use 1 to select the captions asset that is listed first in the CPL. To
     *         include more than one captions track in your job outputs, create multiple input captions selectors.
     *         Specify one track per selector.
     */
    public final Integer trackNumber() {
        return trackNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(trackNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrackSourceSettings)) {
            return false;
        }
        TrackSourceSettings other = (TrackSourceSettings) obj;
        return Objects.equals(trackNumber(), other.trackNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TrackSourceSettings").add("TrackNumber", trackNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrackNumber":
            return Optional.ofNullable(clazz.cast(trackNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrackSourceSettings, T> g) {
        return obj -> g.apply((TrackSourceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TrackSourceSettings> {
        /**
         * Use this setting to select a single captions track from a source. Track numbers correspond to the order in
         * the captions source file. For IMF sources, track numbering is based on the order that the captions appear in
         * the CPL. For example, use 1 to select the captions asset that is listed first in the CPL. To include more
         * than one captions track in your job outputs, create multiple input captions selectors. Specify one track per
         * selector.
         * 
         * @param trackNumber
         *        Use this setting to select a single captions track from a source. Track numbers correspond to the
         *        order in the captions source file. For IMF sources, track numbering is based on the order that the
         *        captions appear in the CPL. For example, use 1 to select the captions asset that is listed first in
         *        the CPL. To include more than one captions track in your job outputs, create multiple input captions
         *        selectors. Specify one track per selector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackNumber(Integer trackNumber);
    }

    static final class BuilderImpl implements Builder {
        private Integer trackNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(TrackSourceSettings model) {
            trackNumber(model.trackNumber);
        }

        public final Integer getTrackNumber() {
            return trackNumber;
        }

        @Override
        public final Builder trackNumber(Integer trackNumber) {
            this.trackNumber = trackNumber;
            return this;
        }

        public final void setTrackNumber(Integer trackNumber) {
            this.trackNumber = trackNumber;
        }

        @Override
        public TrackSourceSettings build() {
            return new TrackSourceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
