/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediaconvert.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

/**
 * Specify how often MediaConvert sends STATUS_UPDATE events to Amazon CloudWatch Events. Set the interval, in seconds,
 * between status updates. MediaConvert sends an update at this interval from the time the service begins processing
 * your job to the time it completes the transcode or encounters an error.
 */
@Generated("software.amazon.awssdk:codegen")
public enum StatusUpdateInterval {
    SECONDS_10("SECONDS_10"),

    SECONDS_12("SECONDS_12"),

    SECONDS_15("SECONDS_15"),

    SECONDS_20("SECONDS_20"),

    SECONDS_30("SECONDS_30"),

    SECONDS_60("SECONDS_60"),

    SECONDS_120("SECONDS_120"),

    SECONDS_180("SECONDS_180"),

    SECONDS_240("SECONDS_240"),

    SECONDS_300("SECONDS_300"),

    SECONDS_360("SECONDS_360"),

    SECONDS_420("SECONDS_420"),

    SECONDS_480("SECONDS_480"),

    SECONDS_540("SECONDS_540"),

    SECONDS_600("SECONDS_600"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StatusUpdateInterval(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return StatusUpdateInterval corresponding to the value
     */
    public static StatusUpdateInterval fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StatusUpdateInterval.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link StatusUpdateInterval}s
     */
    public static Set<StatusUpdateInterval> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
